/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.stub.MetadataUtils;
import io.milvus.grpc.GetVersionRequest;
import io.milvus.grpc.GetVersionResponse;
import io.milvus.grpc.ListDatabasesRequest;
import io.milvus.grpc.ListDatabasesResponse;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.v2.client.ConnectConfig;
import io.milvus.v2.utils.RpcUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtils {
    Logger logger = LoggerFactory.getLogger(ClientUtils.class);
    RpcUtils rpcUtils = new RpcUtils();

    public ManagedChannel getChannel(ConnectConfig connectConfig) {
        ManagedChannel channel = null;
        Metadata metadata = new Metadata();
        if (connectConfig.getAuthorization() != null) {
            metadata.put(Metadata.Key.of((String)"authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)Base64.getEncoder().encodeToString(connectConfig.getAuthorization().getBytes(StandardCharsets.UTF_8)));
        }
        if (StringUtils.isNotEmpty((CharSequence)connectConfig.getDbName())) {
            metadata.put(Metadata.Key.of((String)"dbname", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)connectConfig.getDbName());
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)connectConfig.getServerPemPath())) {
                SslContext sslContext = GrpcSslContexts.forClient().trustManager(new File(connectConfig.getServerPemPath())).build();
                NettyChannelBuilder builder = (NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)connectConfig.getHost(), (int)connectConfig.getPort()).overrideAuthority(connectConfig.getServerName())).sslContext(sslContext).maxInboundMessageSize(Integer.MAX_VALUE).keepAliveTime(connectConfig.getKeepAliveTimeMs(), TimeUnit.MILLISECONDS).keepAliveTimeout(connectConfig.getKeepAliveTimeoutMs(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(connectConfig.isKeepAliveWithoutCalls()).idleTimeout(connectConfig.getIdleTimeoutMs(), TimeUnit.MILLISECONDS)).intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)});
                if (connectConfig.isSecure().booleanValue()) {
                    builder.useTransportSecurity();
                }
                channel = builder.build();
            } else if (StringUtils.isNotEmpty((CharSequence)connectConfig.getClientPemPath()) && StringUtils.isNotEmpty((CharSequence)connectConfig.getClientKeyPath()) && StringUtils.isNotEmpty((CharSequence)connectConfig.getCaPemPath())) {
                SslContext sslContext = GrpcSslContexts.forClient().trustManager(new File(connectConfig.getCaPemPath())).keyManager(new File(connectConfig.getClientPemPath()), new File(connectConfig.getClientKeyPath())).build();
                NettyChannelBuilder builder = (NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)connectConfig.getHost(), (int)connectConfig.getPort()).sslContext(sslContext).maxInboundMessageSize(Integer.MAX_VALUE).keepAliveTime(connectConfig.getKeepAliveTimeMs(), TimeUnit.MILLISECONDS).keepAliveTimeout(connectConfig.getKeepAliveTimeoutMs(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(connectConfig.isKeepAliveWithoutCalls()).idleTimeout(connectConfig.getIdleTimeoutMs(), TimeUnit.MILLISECONDS)).intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)});
                if (connectConfig.getSecure().booleanValue()) {
                    builder.useTransportSecurity();
                }
                if (StringUtils.isNotEmpty((CharSequence)connectConfig.getServerName())) {
                    builder.overrideAuthority(connectConfig.getServerName());
                }
                channel = builder.build();
            } else {
                ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)connectConfig.getHost(), (int)connectConfig.getPort()).usePlaintext().maxInboundMessageSize(Integer.MAX_VALUE).keepAliveTime(connectConfig.getKeepAliveTimeMs(), TimeUnit.MILLISECONDS).keepAliveTimeout(connectConfig.getKeepAliveTimeoutMs(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(connectConfig.isKeepAliveWithoutCalls()).idleTimeout(connectConfig.getIdleTimeoutMs(), TimeUnit.MILLISECONDS).intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)});
                if (connectConfig.isSecure().booleanValue()) {
                    builder.useTransportSecurity();
                }
                channel = builder.build();
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to open credentials file, error:{}\n", (Object)e.getMessage());
        }
        assert (channel != null);
        return channel;
    }

    public void checkDatabaseExist(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, String dbName) {
        String title = String.format("Check database %s exist", dbName);
        ListDatabasesRequest listDatabasesRequest = ListDatabasesRequest.newBuilder().build();
        ListDatabasesResponse response = blockingStub.listDatabases(listDatabasesRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        if (!response.getDbNamesList().contains((Object)dbName)) {
            throw new IllegalArgumentException("Database " + dbName + " not exist");
        }
    }

    public String getServerVersion(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        GetVersionResponse response = blockingStub.getVersion(GetVersionRequest.newBuilder().build());
        this.rpcUtils.handleResponse("Get server version", response.getStatus());
        return response.getVersion();
    }
}

