/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ProtocolStringList;
import io.milvus.exception.IllegalResponseException;
import io.milvus.exception.ParamException;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.IDs;
import io.milvus.grpc.LongArray;
import io.milvus.grpc.SearchResultData;
import io.milvus.grpc.StringArray;
import io.milvus.response.FieldDataWrapper;
import io.milvus.response.QueryResultsWrapper;
import io.milvus.response.basic.RowRecordWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class SearchResultsWrapper
extends RowRecordWrapper {
    private final SearchResultData results;

    public SearchResultsWrapper(@NonNull SearchResultData results) {
        if (results == null) {
            throw new NullPointerException("results is marked non-null but is null");
        }
        this.results = results;
    }

    public FieldDataWrapper getFieldWrapper(@NonNull String fieldName) throws ParamException {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        List<FieldData> fields = this.results.getFieldsDataList();
        for (FieldData field : fields) {
            if (fieldName.compareTo(field.getFieldName()) != 0) continue;
            return new FieldDataWrapper(field);
        }
        throw new ParamException("The field name doesn't exist");
    }

    @Override
    @Deprecated
    public List<QueryResultsWrapper.RowRecord> getRowRecords() {
        return this.getRowRecords(0);
    }

    public List<QueryResultsWrapper.RowRecord> getRowRecords(int indexOfTarget) {
        ArrayList<QueryResultsWrapper.RowRecord> records = new ArrayList<QueryResultsWrapper.RowRecord>();
        List<IDScore> idScore = this.getIDScore(indexOfTarget);
        long topK = Math.min(this.results.getTopK(), (long)idScore.size());
        int i = 0;
        while ((long)i < topK) {
            IDScore score = idScore.get(i);
            QueryResultsWrapper.RowRecord record = new QueryResultsWrapper.RowRecord();
            if (score.getStrID().isEmpty()) {
                record.put("id", score.getLongID());
            } else {
                record.put("id", score.getStrID());
            }
            record.put("distance", Float.valueOf(score.getScore()));
            this.buildRowRecord(record, i);
            records.add(record);
            ++i;
        }
        return records;
    }

    @Override
    protected List<FieldData> getFieldDataList() {
        return this.results.getFieldsDataList();
    }

    @Override
    protected List<String> getOutputFields() {
        return this.results.getOutputFieldsList();
    }

    public List<?> getFieldData(@NonNull String fieldName, int indexOfTarget) {
        List<?> allData;
        long k;
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        FieldDataWrapper wrapper = null;
        for (int i = 0; i < this.results.getFieldsDataCount(); ++i) {
            FieldData data = this.results.getFieldsData(i);
            if (fieldName.compareTo(data.getFieldName()) != 0) continue;
            wrapper = new FieldDataWrapper(data);
        }
        if (wrapper == null) {
            throw new ParamException("Illegal field name: " + fieldName);
        }
        Position position = this.getOffsetByIndex(indexOfTarget);
        long offset = position.getOffset();
        if (offset + (k = position.getK()) > (long)(allData = wrapper.getFieldData()).size()) {
            throw new IllegalResponseException("Field data row count is wrong");
        }
        return allData.subList((int)offset, (int)offset + (int)k);
    }

    public List<IDScore> getIDScore(int indexOfTarget) throws ParamException, IllegalResponseException {
        int n;
        long k;
        Position position = this.getOffsetByIndex(indexOfTarget);
        long offset = position.getOffset();
        if (offset + (k = position.getK()) > (long)this.results.getScoresCount()) {
            throw new IllegalResponseException("Result scores count is wrong");
        }
        ArrayList<IDScore> idScores = new ArrayList<IDScore>();
        IDs ids = this.results.getIds();
        if (ids.hasIntId()) {
            LongArray longIDs = ids.getIntId();
            if (offset + k > (long)longIDs.getDataCount()) {
                throw new IllegalResponseException("Result ids count is wrong");
            }
            n = 0;
            while ((long)n < k) {
                idScores.add(new IDScore("", longIDs.getData((int)offset + n), this.results.getScores((int)offset + n)));
                ++n;
            }
        } else if (ids.hasStrId()) {
            StringArray strIDs = ids.getStrId();
            if (offset + k > (long)strIDs.getDataCount()) {
                throw new IllegalResponseException("Result ids count is wrong");
            }
            n = 0;
            while ((long)n < k) {
                idScores.add(new IDScore(strIDs.getData((int)offset + n), 0L, this.results.getScores((int)offset + n)));
                ++n;
            }
        } else {
            return idScores;
        }
        ProtocolStringList outputFields = this.results.getOutputFieldsList();
        List<FieldData> fields = this.results.getFieldsDataList();
        if (fields.isEmpty()) {
            return idScores;
        }
        for (String outputKey : outputFields) {
            boolean isField = false;
            FieldDataWrapper dynamicField = null;
            for (FieldData field : fields) {
                if (field.getIsDynamic()) {
                    dynamicField = new FieldDataWrapper(field);
                }
                if (!outputKey.equals(field.getFieldName())) continue;
                FieldDataWrapper wrapper = new FieldDataWrapper(field);
                int n2 = 0;
                while ((long)n2 < k) {
                    if (offset + (long)n2 >= wrapper.getRowCount()) {
                        throw new ParamException("Illegal values length of output fields");
                    }
                    Object value = wrapper.valueByIdx((int)offset + n2);
                    if (wrapper.isJsonField()) {
                        ((IDScore)idScores.get(n2)).put(field.getFieldName(), FieldDataWrapper.ParseJSONObject(value));
                    } else {
                        ((IDScore)idScores.get(n2)).put(field.getFieldName(), value);
                    }
                    ++n2;
                }
                isField = true;
                break;
            }
            if (isField || dynamicField == null) continue;
            int n3 = 0;
            while ((long)n3 < k) {
                Object obj = dynamicField.get((int)offset + n3, outputKey);
                if (obj != null) {
                    ((IDScore)idScores.get(n3)).put(outputKey, obj);
                }
                ++n3;
            }
        }
        return idScores;
    }

    private Position getOffsetByIndex(int indexOfTarget) {
        List<Long> kList = this.results.getTopksList();
        if (kList.isEmpty()) {
            kList = new ArrayList<Long>();
            for (long i = 0L; i < this.results.getNumQueries(); ++i) {
                kList.add(this.results.getTopK());
            }
        }
        if (indexOfTarget < 0 || indexOfTarget >= kList.size()) {
            throw new ParamException("Illegal index of target: " + indexOfTarget);
        }
        long offset = 0L;
        for (int i = 0; i < indexOfTarget; ++i) {
            offset += kList.get(i).longValue();
        }
        long k = kList.get(indexOfTarget);
        return new Position(offset, k);
    }

    public static final class IDScore {
        private final String strID;
        private final long longID;
        private final float score;
        Map<String, Object> fieldValues = new HashMap<String, Object>();

        public IDScore(String strID, long longID, float score) {
            this.strID = strID;
            this.longID = longID;
            this.score = score;
        }

        public boolean put(String keyName, Object obj) {
            if (this.fieldValues.containsKey(keyName)) {
                return false;
            }
            this.fieldValues.put(keyName, obj);
            return true;
        }

        public Object get(String keyName) throws ParamException {
            JSONObject jsonMata;
            Object innerObj;
            Object meta;
            if (this.fieldValues.isEmpty()) {
                throw new ParamException("This record is empty");
            }
            Object obj = this.fieldValues.get(keyName);
            if (obj == null && (meta = this.fieldValues.get("$meta")) != null && (innerObj = (jsonMata = (JSONObject)meta).get((Object)keyName)) != null) {
                return innerObj;
            }
            return obj;
        }

        public String toString() {
            ArrayList pairs = new ArrayList();
            this.fieldValues.forEach((keyName, fieldValue) -> pairs.add(keyName + ":" + fieldValue.toString()));
            if (this.strID.isEmpty()) {
                return "(ID: " + this.getLongID() + " Score: " + this.getScore() + " OutputFields: " + pairs + ")";
            }
            return "(ID: '" + this.getStrID() + "' Score: " + this.getScore() + " OutputFields: " + pairs + ")";
        }

        public String getStrID() {
            return this.strID;
        }

        public long getLongID() {
            return this.longID;
        }

        public float getScore() {
            return this.score;
        }

        public Map<String, Object> getFieldValues() {
            return this.fieldValues;
        }
    }

    private static final class Position {
        private final long offset;
        private final long k;

        public Position(long offset, long k) {
            this.offset = offset;
            this.k = k;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getK() {
            return this.k;
        }
    }
}

