/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter;

import com.google.gson.Gson;
import io.milvus.bulkwriter.response.RestfulResponse;
import io.milvus.common.utils.ExceptionUtils;
import java.util.HashMap;
import java.util.Map;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;

public class BaseCloudImport {
    private static final Gson GSON_INSTANCE = new Gson();

    protected static String postRequest(String url, String apiKey, Map<String, Object> params, int timeout) {
        try {
            HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)url).connectTimeout(timeout)).headers(BaseCloudImport.httpHeaders(apiKey))).body(params).asString();
            if (response.getStatus() == 200) {
                return (String)response.getBody();
            }
            ExceptionUtils.throwUnExpectedException(String.format("Failed to post url: %s, status code: %s", url, response.getStatus()));
        }
        catch (Exception e) {
            ExceptionUtils.throwUnExpectedException(String.format("Failed to post url: %s, error: %s", url, e));
        }
        return null;
    }

    protected static String getRequest(String url, String apiKey, Map<String, Object> params, int timeout) {
        try {
            HttpResponse response = ((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)url).connectTimeout(timeout)).headers(BaseCloudImport.httpHeaders(apiKey))).queryString(params)).asString();
            if (response.getStatus() == 200) {
                return (String)response.getBody();
            }
            ExceptionUtils.throwUnExpectedException(String.format("Failed to get url: %s, status code: %s", url, response.getStatus()));
        }
        catch (Exception e) {
            ExceptionUtils.throwUnExpectedException(String.format("Failed to get url: %s, error: %s", url, e));
        }
        return null;
    }

    protected static Map<String, String> httpHeaders(String apiKey) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_0) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11");
        header.put("Accept", "application/json");
        header.put("Content-Type", "application/json");
        header.put("Accept-Encodin", "gzip,deflate,sdch");
        header.put("Accept-Languag", "en-US,en;q=0.5");
        header.put("Authorization", "Bearer " + apiKey);
        return header;
    }

    protected static void handleResponse(String url, RestfulResponse res) {
        int innerCode = res.getCode();
        if (innerCode != 0) {
            String innerMessage = res.getMessage();
            ExceptionUtils.throwUnExpectedException(String.format("Failed to request url: %s, code: %s, message: %s", url, innerCode, innerMessage));
        }
    }

    protected static String convertToV2ControlBaseURL(String url) {
        if (url.endsWith(".com")) {
            return "https://api.cloud.zilliz.com";
        }
        return "https://api.cloud.zilliz.com.cn";
    }
}

