/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter;

import io.milvus.bulkwriter.common.clientenum.BulkFileType;
import io.milvus.bulkwriter.common.utils.V2AdapterUtils;
import io.milvus.bulkwriter.connect.StorageConnectParam;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.CollectionSchemaParam;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class RemoteBulkWriterParam {
    private final CollectionSchemaParam collectionSchema;
    private final StorageConnectParam connectParam;
    private final String remotePath;
    private final int chunkSize;
    private final BulkFileType fileType;

    private RemoteBulkWriterParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionSchema = builder.collectionSchema;
        this.connectParam = builder.connectParam;
        this.remotePath = builder.remotePath;
        this.chunkSize = builder.chunkSize;
        this.fileType = builder.fileType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public CollectionSchemaParam getCollectionSchema() {
        return this.collectionSchema;
    }

    public StorageConnectParam getConnectParam() {
        return this.connectParam;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public BulkFileType getFileType() {
        return this.fileType;
    }

    public String toString() {
        return "RemoteBulkWriterParam(collectionSchema=" + this.getCollectionSchema() + ", connectParam=" + this.getConnectParam() + ", remotePath=" + this.getRemotePath() + ", chunkSize=" + this.getChunkSize() + ", fileType=" + (Object)((Object)this.getFileType()) + ")";
    }

    public static final class Builder {
        private CollectionSchemaParam collectionSchema;
        private StorageConnectParam connectParam;
        private String remotePath;
        private int chunkSize = 0x40000000;
        private BulkFileType fileType = BulkFileType.PARQUET;

        private Builder() {
        }

        public Builder withCollectionSchema(@NonNull CollectionSchemaParam collectionSchema) {
            if (collectionSchema == null) {
                throw new NullPointerException("collectionSchema is marked non-null but is null");
            }
            this.collectionSchema = collectionSchema;
            return this;
        }

        public Builder withCollectionSchema(@NonNull CreateCollectionReq.CollectionSchema collectionSchema) {
            if (collectionSchema == null) {
                throw new NullPointerException("collectionSchema is marked non-null but is null");
            }
            this.collectionSchema = V2AdapterUtils.convertV2Schema(collectionSchema);
            return this;
        }

        public Builder withConnectParam(@NotNull StorageConnectParam connectParam) {
            this.connectParam = connectParam;
            return this;
        }

        public Builder withRemotePath(@NonNull String remotePath) {
            if (remotePath == null) {
                throw new NullPointerException("remotePath is marked non-null but is null");
            }
            this.remotePath = remotePath;
            return this;
        }

        public Builder withChunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public Builder withFileType(@NonNull BulkFileType fileType) {
            if (fileType == null) {
                throw new NullPointerException("fileType is marked non-null but is null");
            }
            this.fileType = fileType;
            return this;
        }

        public RemoteBulkWriterParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.remotePath, "localPath");
            if (this.collectionSchema == null) {
                throw new ParamException("collectionSchema cannot be null");
            }
            if (this.connectParam == null) {
                throw new ParamException("connectParam cannot be null");
            }
            return new RemoteBulkWriterParam(this);
        }
    }
}

