/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.index;

import io.milvus.grpc.AllocTimestampRequest;
import io.milvus.grpc.AllocTimestampResponse;
import io.milvus.grpc.AlterIndexRequest;
import io.milvus.grpc.CreateIndexRequest;
import io.milvus.grpc.DescribeIndexRequest;
import io.milvus.grpc.DescribeIndexResponse;
import io.milvus.grpc.DropIndexRequest;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.IndexDescription;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.Status;
import io.milvus.param.ParamUtils;
import io.milvus.v2.common.IndexBuildState;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.index.request.AlterIndexPropertiesReq;
import io.milvus.v2.service.index.request.CreateIndexReq;
import io.milvus.v2.service.index.request.DescribeIndexReq;
import io.milvus.v2.service.index.request.DropIndexPropertiesReq;
import io.milvus.v2.service.index.request.DropIndexReq;
import io.milvus.v2.service.index.request.ListIndexesReq;
import io.milvus.v2.service.index.response.DescribeIndexResp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IndexService
extends BaseService {
    public Void createIndex(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateIndexReq request) {
        for (IndexParam indexParam : request.getIndexParams()) {
            Map<String, Object> extraParams;
            String title = String.format("CreateIndexRequest collectionName:%s, fieldName:%s", request.getCollectionName(), indexParam.getFieldName());
            CreateIndexRequest.Builder builder = CreateIndexRequest.newBuilder();
            builder.setCollectionName(request.getCollectionName()).setIndexName(indexParam.getIndexName()).setFieldName(indexParam.getFieldName()).addExtraParams(KeyValuePair.newBuilder().setKey("index_type").setValue(indexParam.getIndexType().getName()).build());
            if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
                builder.setDbName(request.getDatabaseName());
            }
            if (indexParam.getMetricType() != null) {
                builder.addExtraParams(KeyValuePair.newBuilder().setKey("metric_type").setValue(indexParam.getMetricType().name()).build());
            }
            if ((extraParams = indexParam.getExtraParams()) != null && !extraParams.isEmpty()) {
                for (String key : extraParams.keySet()) {
                    builder.addExtraParams(KeyValuePair.newBuilder().setKey(key).setValue(extraParams.get(key).toString()).build());
                }
            }
            Status status = blockingStub.createIndex(builder.build());
            this.rpcUtils.handleResponse(title, status);
            if (!request.getSync().booleanValue()) continue;
            this.WaitForIndexComplete(blockingStub, request.getDatabaseName(), request.getCollectionName(), indexParam.getFieldName(), indexParam.getIndexName(), request.getTimeout());
        }
        return null;
    }

    public Void dropIndex(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropIndexReq request) {
        String title = String.format("DropIndexRequest collectionName:%s, fieldName:%s, indexName:%s", request.getCollectionName(), request.getFieldName(), request.getIndexName());
        DropIndexRequest dropIndexRequest = DropIndexRequest.newBuilder().setCollectionName(request.getCollectionName()).setFieldName(request.getFieldName() == null ? "" : request.getFieldName()).setIndexName(request.getIndexName() == null ? "" : request.getIndexName()).build();
        Status status = blockingStub.dropIndex(dropIndexRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void alterIndexProperties(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, AlterIndexPropertiesReq request) {
        String title = String.format("AlterIndexPropertiesReq collectionName:%s, indexName:%s", request.getCollectionName(), request.getIndexName());
        AlterIndexRequest.Builder builder = AlterIndexRequest.newBuilder().setCollectionName(request.getCollectionName()).setIndexName(request.getIndexName());
        List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(request.getProperties());
        if (CollectionUtils.isNotEmpty(propertiesList)) {
            propertiesList.forEach(builder::addExtraParams);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        Status response = blockingStub.alterIndex(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void dropIndexProperties(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropIndexPropertiesReq request) {
        String title = String.format("DropIndexPropertiesReq collectionName:%s, indexName:%s", request.getCollectionName(), request.getIndexName());
        AlterIndexRequest.Builder builder = AlterIndexRequest.newBuilder().setCollectionName(request.getCollectionName()).setIndexName(request.getIndexName()).addAllDeleteKeys(request.getPropertyKeys());
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        Status response = blockingStub.alterIndex(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public DescribeIndexResp describeIndex(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeIndexReq request) {
        String title = String.format("DescribeIndexRequest databaseName:%s collectionName:%s, fieldName:%s, indexName:%s", request.getDatabaseName(), request.getCollectionName(), request.getFieldName(), request.getIndexName());
        DescribeIndexRequest.Builder builder = DescribeIndexRequest.newBuilder().setCollectionName(request.getCollectionName()).setFieldName(request.getFieldName() == null ? "" : request.getFieldName()).setIndexName(request.getIndexName() == null ? "" : request.getIndexName());
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        DescribeIndexResponse response = blockingStub.describeIndex(builder.build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        List<IndexDescription> indexs = response.getIndexDescriptionsList().stream().filter(index -> index.getIndexName().equals(request.getIndexName()) || index.getFieldName().equals(request.getFieldName())).collect(Collectors.toList());
        if (indexs.isEmpty()) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, "Index not found");
        }
        if (indexs.size() > 1) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, "More than one index found");
        }
        return this.convertUtils.convertToDescribeIndexResp(indexs);
    }

    public List<String> listIndexes(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, ListIndexesReq request) {
        DescribeIndexResponse response;
        String title = String.format("ListIndexesRequest collectionName:%s", request.getCollectionName());
        DescribeIndexRequest describeIndexRequest = DescribeIndexRequest.newBuilder().setCollectionName(request.getCollectionName()).build();
        if (request.getFieldName() != null) {
            describeIndexRequest = describeIndexRequest.toBuilder().setFieldName(request.getFieldName()).build();
        }
        if ((response = blockingStub.describeIndex(describeIndexRequest)).getStatus().getErrorCode() == ErrorCode.IndexNotExist || response.getStatus().getCode() == 700) {
            return new ArrayList<String>();
        }
        this.rpcUtils.handleResponse(title, response.getStatus());
        return response.getIndexDescriptionsList().stream().filter(desc -> request.getFieldName() == null || desc.getFieldName().equals(request.getFieldName())).map(IndexDescription::getIndexName).collect(Collectors.toList());
    }

    private void WaitForIndexComplete(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, String databaseName, String collectionName, String fieldName, String indexName, long timeoutMs) {
        long startTime = System.currentTimeMillis();
        AllocTimestampResponse allocTsResp = blockingStub.allocTimestamp(AllocTimestampRequest.newBuilder().build());
        this.rpcUtils.handleResponse("AllocTimestampRequest", allocTsResp.getStatus());
        long serverTs = allocTsResp.getTimestamp();
        while (true) {
            String msg;
            Object describeIndexReq = ((DescribeIndexReq.DescribeIndexReqBuilder)((DescribeIndexReq.DescribeIndexReqBuilder)((DescribeIndexReq.DescribeIndexReqBuilder)((DescribeIndexReq.DescribeIndexReqBuilder)DescribeIndexReq.builder().collectionName(collectionName)).fieldName(fieldName)).indexName(indexName)).timestamp(serverTs)).build();
            if (StringUtils.isNotEmpty((CharSequence)databaseName)) {
                ((DescribeIndexReq)describeIndexReq).setDatabaseName(databaseName);
            }
            DescribeIndexResp response = this.describeIndex(blockingStub, (DescribeIndexReq)describeIndexReq);
            List<DescribeIndexResp.IndexDesc> indices = response.getIndexDescriptions();
            DescribeIndexResp.IndexDesc desc = null;
            if (indices.size() == 1) {
                desc = indices.get(0);
            } else {
                for (DescribeIndexResp.IndexDesc index : indices) {
                    if (!fieldName.equals(index.getFieldName())) continue;
                    desc = index;
                    break;
                }
            }
            if (desc == null) {
                msg = String.format("Failed to describe the index '%s' of field '%s' from serv side", fieldName, indexName);
                throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, msg);
            }
            if (desc.getIndexState() == IndexBuildState.Finished) {
                return;
            }
            if (desc.getIndexState() == IndexBuildState.Failed) {
                msg = "Index is failed, reason: " + desc.getIndexFailedReason();
                throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, msg);
            }
            if (System.currentTimeMillis() - startTime > timeoutMs) {
                throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, "Create index timeout");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.out.println("Thread was interrupted, failed to complete operation");
                return;
            }
        }
    }
}

