/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.collection;

import io.milvus.common.utils.GTsDict;
import io.milvus.grpc.AlterCollectionFieldRequest;
import io.milvus.grpc.AlterCollectionRequest;
import io.milvus.grpc.BoolResponse;
import io.milvus.grpc.CollectionSchema;
import io.milvus.grpc.CreateCollectionRequest;
import io.milvus.grpc.DataType;
import io.milvus.grpc.DescribeCollectionRequest;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.DropCollectionRequest;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.GetCollectionStatisticsRequest;
import io.milvus.grpc.GetCollectionStatisticsResponse;
import io.milvus.grpc.GetLoadStateRequest;
import io.milvus.grpc.GetLoadStateResponse;
import io.milvus.grpc.GetReplicasRequest;
import io.milvus.grpc.GetReplicasResponse;
import io.milvus.grpc.HasCollectionRequest;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.LoadCollectionRequest;
import io.milvus.grpc.LoadState;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.ReleaseCollectionRequest;
import io.milvus.grpc.RenameCollectionRequest;
import io.milvus.grpc.ShowCollectionsRequest;
import io.milvus.grpc.ShowCollectionsResponse;
import io.milvus.grpc.Status;
import io.milvus.param.ParamUtils;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.collection.ReplicaInfo;
import io.milvus.v2.service.collection.ShardReplica;
import io.milvus.v2.service.collection.request.AlterCollectionFieldReq;
import io.milvus.v2.service.collection.request.AlterCollectionPropertiesReq;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.request.DescribeCollectionReq;
import io.milvus.v2.service.collection.request.DescribeReplicasReq;
import io.milvus.v2.service.collection.request.DropCollectionFieldPropertiesReq;
import io.milvus.v2.service.collection.request.DropCollectionPropertiesReq;
import io.milvus.v2.service.collection.request.DropCollectionReq;
import io.milvus.v2.service.collection.request.GetCollectionStatsReq;
import io.milvus.v2.service.collection.request.GetLoadStateReq;
import io.milvus.v2.service.collection.request.HasCollectionReq;
import io.milvus.v2.service.collection.request.LoadCollectionReq;
import io.milvus.v2.service.collection.request.RefreshLoadReq;
import io.milvus.v2.service.collection.request.ReleaseCollectionReq;
import io.milvus.v2.service.collection.request.RenameCollectionReq;
import io.milvus.v2.service.collection.response.DescribeCollectionResp;
import io.milvus.v2.service.collection.response.DescribeReplicasResp;
import io.milvus.v2.service.collection.response.GetCollectionStatsResp;
import io.milvus.v2.service.collection.response.ListCollectionsResp;
import io.milvus.v2.service.index.IndexService;
import io.milvus.v2.service.index.request.CreateIndexReq;
import io.milvus.v2.utils.SchemaUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CollectionService
extends BaseService {
    public IndexService indexService = new IndexService();

    public Void createCollection(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateCollectionReq request) {
        if (request.getCollectionSchema() != null) {
            this.createCollectionWithSchema(blockingStub, request);
            return null;
        }
        if (request.getDimension() == null) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Dimension is undefined.");
        }
        String title = String.format("CreateCollectionRequest collectionName:%s", request.getCollectionName());
        FieldSchema vectorSchema = FieldSchema.newBuilder().setName(request.getVectorFieldName()).setDataType(DataType.FloatVector).setIsPrimaryKey(Boolean.FALSE).addTypeParams(KeyValuePair.newBuilder().setKey("dim").setValue(String.valueOf(request.getDimension())).build()).build();
        FieldSchema idSchema = FieldSchema.newBuilder().setName(request.getPrimaryFieldName()).setDataType(DataType.valueOf(request.getIdType().name())).setIsPrimaryKey(Boolean.TRUE).setAutoID(request.getAutoID()).build();
        if (request.getIdType().name().equals("VarChar") && request.getMaxLength() != null) {
            idSchema = idSchema.toBuilder().addTypeParams(KeyValuePair.newBuilder().setKey("max_length").setValue(String.valueOf(request.getMaxLength())).build()).build();
        }
        CollectionSchema schema = CollectionSchema.newBuilder().setName(request.getCollectionName()).setDescription(request.getDescription()).addFields(vectorSchema).addFields(idSchema).setEnableDynamicField(request.getEnableDynamicField()).build();
        CreateCollectionRequest.Builder builder = CreateCollectionRequest.newBuilder().setCollectionName(request.getCollectionName()).setSchema(schema.toByteString()).setShardsNum(request.getNumShards()).setConsistencyLevelValue(request.getConsistencyLevel().getCode());
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        Status status = blockingStub.createCollection(builder.build());
        this.rpcUtils.handleResponse(title, status);
        Object indexParam = ((IndexParam.IndexParamBuilder)((IndexParam.IndexParamBuilder)IndexParam.builder().metricType(IndexParam.MetricType.valueOf(request.getMetricType()))).fieldName(request.getVectorFieldName())).build();
        Object createIndexReq = ((CreateIndexReq.CreateIndexReqBuilder)((CreateIndexReq.CreateIndexReqBuilder)((CreateIndexReq.CreateIndexReqBuilder)((CreateIndexReq.CreateIndexReqBuilder)CreateIndexReq.builder().databaseName(request.getDatabaseName())).collectionName(request.getCollectionName())).indexParams(Collections.singletonList(indexParam))).sync(false)).build();
        this.indexService.createIndex(blockingStub, (CreateIndexReq)createIndexReq);
        try {
            this.loadCollection(blockingStub, (LoadCollectionReq)((LoadCollectionReq.LoadCollectionReqBuilder)((LoadCollectionReq.LoadCollectionReqBuilder)((LoadCollectionReq.LoadCollectionReqBuilder)LoadCollectionReq.builder().databaseName(request.getDatabaseName())).collectionName(request.getCollectionName())).sync(false)).build());
        }
        catch (Exception e) {
            throw new MilvusClientException(ErrorCode.SERVER_ERROR, "Load collection failed: " + e);
        }
        return null;
    }

    public Void createCollectionWithSchema(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateCollectionReq request) {
        List<KeyValuePair> propertiesList;
        String title = String.format("CreateCollectionRequest collectionName:%s", request.getCollectionName());
        CollectionSchema.Builder grpcSchemaBuilder = CollectionSchema.newBuilder().setName(request.getCollectionName()).setDescription(request.getDescription()).setEnableDynamicField(request.getCollectionSchema().isEnableDynamicField());
        ArrayList<String> outputFields = new ArrayList<String>();
        for (CreateCollectionReq.Function function : request.getCollectionSchema().getFunctionList()) {
            grpcSchemaBuilder.addFunctions(SchemaUtils.convertToGrpcFunction(function)).build();
            outputFields.addAll(function.getOutputFieldNames());
        }
        for (CreateCollectionReq.FieldSchema fieldSchema : request.getCollectionSchema().getFieldSchemaList()) {
            FieldSchema grpcFieldSchema = SchemaUtils.convertToGrpcFieldSchema(fieldSchema);
            if (outputFields.contains(fieldSchema.getName())) {
                grpcFieldSchema = grpcFieldSchema.toBuilder().setIsFunctionOutput(true).build();
            }
            grpcSchemaBuilder.addFields(grpcFieldSchema);
        }
        CreateCollectionRequest.Builder builder = CreateCollectionRequest.newBuilder().setCollectionName(request.getCollectionName()).setSchema(grpcSchemaBuilder.build().toByteString()).setShardsNum(request.getNumShards()).setConsistencyLevelValue(request.getConsistencyLevel().getCode());
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        if (CollectionUtils.isNotEmpty(propertiesList = ParamUtils.AssembleKvPair(request.getProperties()))) {
            propertiesList.forEach(builder::addProperties);
        }
        if (request.getNumPartitions() != null) {
            builder.setNumPartitions(request.getNumPartitions().intValue());
        }
        Status createCollectionResponse = blockingStub.createCollection(builder.build());
        this.rpcUtils.handleResponse(title, createCollectionResponse);
        if (request.getIndexParams() != null && !request.getIndexParams().isEmpty()) {
            for (IndexParam indexParam : request.getIndexParams()) {
                Object createIndexReq = ((CreateIndexReq.CreateIndexReqBuilder)((CreateIndexReq.CreateIndexReqBuilder)((CreateIndexReq.CreateIndexReqBuilder)((CreateIndexReq.CreateIndexReqBuilder)CreateIndexReq.builder().databaseName(request.getDatabaseName())).collectionName(request.getCollectionName())).indexParams(Collections.singletonList(indexParam))).sync(false)).build();
                this.indexService.createIndex(blockingStub, (CreateIndexReq)createIndexReq);
            }
            this.loadCollection(blockingStub, (LoadCollectionReq)((LoadCollectionReq.LoadCollectionReqBuilder)((LoadCollectionReq.LoadCollectionReqBuilder)((LoadCollectionReq.LoadCollectionReqBuilder)LoadCollectionReq.builder().databaseName(request.getDatabaseName())).collectionName(request.getCollectionName())).sync(false)).build());
        }
        return null;
    }

    public ListCollectionsResp listCollections(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        ShowCollectionsRequest showCollectionsRequest = ShowCollectionsRequest.newBuilder().build();
        ShowCollectionsResponse response = blockingStub.showCollections(showCollectionsRequest);
        Object listCollectionsResp = ((ListCollectionsResp.ListCollectionsRespBuilder)ListCollectionsResp.builder().collectionNames((List<String>)response.getCollectionNamesList())).build();
        return listCollectionsResp;
    }

    public Void dropCollection(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropCollectionReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("DropCollectionRequest collectionName:%s", collectionName);
        DropCollectionRequest.Builder builder = DropCollectionRequest.newBuilder().setCollectionName(collectionName);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        Status status = blockingStub.dropCollection(builder.build());
        this.rpcUtils.handleResponse(title, status);
        String key = GTsDict.CombineCollectionName(this.actualDbName(dbName), collectionName);
        GTsDict.getInstance().removeCollectionTs(key);
        return null;
    }

    public Void alterCollectionProperties(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, AlterCollectionPropertiesReq request) {
        String title = String.format("AlterCollectionPropertiesReq collectionName:%s", request.getCollectionName());
        AlterCollectionRequest.Builder builder = AlterCollectionRequest.newBuilder().setCollectionName(request.getCollectionName());
        List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(request.getProperties());
        if (CollectionUtils.isNotEmpty(propertiesList)) {
            propertiesList.forEach(builder::addProperties);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        Status response = blockingStub.alterCollection(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void alterCollectionField(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, AlterCollectionFieldReq request) {
        String title = String.format("AlterCollectionFieldReq collectionName:%s", request.getCollectionName());
        AlterCollectionFieldRequest.Builder builder = AlterCollectionFieldRequest.newBuilder().setCollectionName(request.getCollectionName()).setFieldName(request.getFieldName());
        List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(request.getProperties());
        if (CollectionUtils.isNotEmpty(propertiesList)) {
            propertiesList.forEach(builder::addProperties);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        Status response = blockingStub.alterCollectionField(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void dropCollectionProperties(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropCollectionPropertiesReq request) {
        String title = String.format("DropCollectionPropertiesReq collectionName:%s", request.getCollectionName());
        AlterCollectionRequest.Builder builder = AlterCollectionRequest.newBuilder().setCollectionName(request.getCollectionName()).addAllDeleteKeys(request.getPropertyKeys());
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        Status response = blockingStub.alterCollection(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void dropCollectionFieldProperties(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropCollectionFieldPropertiesReq request) {
        String title = String.format("DropCollectionFieldPropertiesReq collectionName:%s fieldName:%s", request.getCollectionName(), request.getFieldName());
        AlterCollectionFieldRequest.Builder builder = AlterCollectionFieldRequest.newBuilder().setCollectionName(request.getCollectionName()).setFieldName(request.getFieldName()).addAllDeleteKeys(request.getPropertyKeys());
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        Status response = blockingStub.alterCollectionField(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Boolean hasCollection(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, HasCollectionReq request) {
        HasCollectionRequest hasCollectionRequest = HasCollectionRequest.newBuilder().setCollectionName(request.getCollectionName()).build();
        BoolResponse response = blockingStub.hasCollection(hasCollectionRequest);
        this.rpcUtils.handleResponse("HasCollectionRequest", response.getStatus());
        return response.getValue();
    }

    public DescribeCollectionResp describeCollection(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeCollectionReq request) {
        String title = String.format("DescribeCollectionRequest collectionName:%s, databaseName:%s", request.getCollectionName(), request.getDatabaseName());
        DescribeCollectionRequest.Builder builder = DescribeCollectionRequest.newBuilder().setCollectionName(request.getCollectionName());
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        DescribeCollectionResponse response = blockingStub.describeCollection(builder.build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        return this.convertUtils.convertDescCollectionResp(response);
    }

    public Void renameCollection(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, RenameCollectionReq request) {
        String title = String.format("RenameCollectionRequest collectionName:%s", request.getCollectionName());
        RenameCollectionRequest renameCollectionRequest = RenameCollectionRequest.newBuilder().setOldName(request.getCollectionName()).setNewName(request.getNewCollectionName()).build();
        Status status = blockingStub.renameCollection(renameCollectionRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void loadCollection(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, LoadCollectionReq request) {
        String title = String.format("LoadCollectionRequest collectionName:%s", request.getCollectionName());
        LoadCollectionRequest.Builder builder = LoadCollectionRequest.newBuilder().setCollectionName(request.getCollectionName()).setReplicaNumber(request.getNumReplicas()).setRefresh(request.getRefresh()).addAllLoadFields(request.getLoadFields()).setSkipLoadDynamicField(request.getSkipLoadDynamicField()).addAllResourceGroups(request.getResourceGroups());
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        Status status = blockingStub.loadCollection(builder.build());
        this.rpcUtils.handleResponse(title, status);
        if (request.getSync().booleanValue()) {
            this.WaitForLoadCollection(blockingStub, request.getCollectionName(), request.getTimeout());
        }
        return null;
    }

    public Void refreshLoad(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, RefreshLoadReq request) {
        String title = String.format("RefreshLoadRequest collectionName:%s", request.getCollectionName());
        LoadCollectionRequest.Builder builder = LoadCollectionRequest.newBuilder().setCollectionName(request.getCollectionName()).setRefresh(true);
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        Status status = blockingStub.loadCollection(builder.build());
        this.rpcUtils.handleResponse(title, status);
        if (request.getSync().booleanValue()) {
            this.WaitForLoadCollection(blockingStub, request.getCollectionName(), request.getTimeout());
        }
        return null;
    }

    public Void releaseCollection(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, ReleaseCollectionReq request) {
        String title = String.format("ReleaseCollectionRequest collectionName:%s", request.getCollectionName());
        ReleaseCollectionRequest releaseCollectionRequest = ReleaseCollectionRequest.newBuilder().setCollectionName(request.getCollectionName()).build();
        Status status = blockingStub.releaseCollection(releaseCollectionRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Boolean getLoadState(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GetLoadStateReq request) {
        String title = String.format("GetLoadStateRequest collectionName:%s", request.getCollectionName());
        GetLoadStateRequest getLoadStateRequest = GetLoadStateRequest.newBuilder().setCollectionName(request.getCollectionName()).build();
        if (request.getPartitionName() != null) {
            getLoadStateRequest = getLoadStateRequest.toBuilder().addPartitionNames(request.getPartitionName()).build();
        }
        GetLoadStateResponse response = blockingStub.getLoadState(getLoadStateRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return response.getState() == LoadState.LoadStateLoaded;
    }

    public GetCollectionStatsResp getCollectionStats(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GetCollectionStatsReq request) {
        String title = String.format("GetCollectionStatisticsRequest collectionName:%s", request.getCollectionName());
        GetCollectionStatisticsRequest getCollectionStatisticsRequest = GetCollectionStatisticsRequest.newBuilder().setCollectionName(request.getCollectionName()).build();
        GetCollectionStatisticsResponse response = blockingStub.getCollectionStatistics(getCollectionStatisticsRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        Object getCollectionStatsResp = ((GetCollectionStatsResp.GetCollectionStatsRespBuilder)GetCollectionStatsResp.builder().numOfEntities(response.getStatsList().stream().filter(stat -> stat.getKey().equals("row_count")).map(stat -> Long.parseLong(stat.getValue())).findFirst().get())).build();
        return getCollectionStatsResp;
    }

    public static CreateCollectionReq.CollectionSchema createSchema() {
        return CreateCollectionReq.CollectionSchema.builder().build();
    }

    public DescribeReplicasResp describeReplicas(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeReplicasReq request) {
        if (StringUtils.isEmpty((CharSequence)request.getCollectionName())) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Invalid collection name");
        }
        String title = String.format("DescribeReplicas collectionName:%s", request.getCollectionName());
        GetReplicasRequest.Builder requestBuilder = GetReplicasRequest.newBuilder().setCollectionName(request.getCollectionName()).setWithShardNodes(true);
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            requestBuilder.setDbName(request.getDatabaseName());
        }
        GetReplicasResponse response = blockingStub.getReplicas(requestBuilder.build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        ArrayList<ReplicaInfo> replicas = new ArrayList<ReplicaInfo>();
        List<io.milvus.grpc.ReplicaInfo> rpcReplicas = response.getReplicasList();
        for (io.milvus.grpc.ReplicaInfo info : rpcReplicas) {
            ArrayList<ShardReplica> shardReplicas = new ArrayList<ShardReplica>();
            List<io.milvus.grpc.ShardReplica> rpcShardReplicas = info.getShardReplicasList();
            for (io.milvus.grpc.ShardReplica shardReplica : rpcShardReplicas) {
                shardReplicas.add((ShardReplica)((ShardReplica.ShardReplicaBuilder)((ShardReplica.ShardReplicaBuilder)((ShardReplica.ShardReplicaBuilder)((ShardReplica.ShardReplicaBuilder)ShardReplica.builder().leaderID(shardReplica.getLeaderID())).leaderAddress(shardReplica.getLeaderAddr())).channelName(shardReplica.getDmChannelName())).nodeIDs(shardReplica.getNodeIdsList())).build());
            }
            replicas.add((ReplicaInfo)((ReplicaInfo.ReplicaInfoBuilder)((ReplicaInfo.ReplicaInfoBuilder)((ReplicaInfo.ReplicaInfoBuilder)((ReplicaInfo.ReplicaInfoBuilder)((ReplicaInfo.ReplicaInfoBuilder)((ReplicaInfo.ReplicaInfoBuilder)((ReplicaInfo.ReplicaInfoBuilder)ReplicaInfo.builder().replicaID(info.getReplicaID())).collectionID(info.getCollectionID())).partitionIDs(info.getPartitionIdsList())).nodeIDs(info.getNodeIdsList())).resourceGroupName(info.getResourceGroupName())).numOutboundNode(info.getNumOutboundNodeMap())).shardReplicas(shardReplicas)).build());
        }
        return ((DescribeReplicasResp.DescribeReplicasRespBuilder)DescribeReplicasResp.builder().replicas(replicas)).build();
    }

    private void WaitForLoadCollection(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, String collectionName, long timeoutMs) {
        long startTime = System.currentTimeMillis();
        boolean isLoaded;
        while (!(isLoaded = this.getLoadState(blockingStub, (GetLoadStateReq)((GetLoadStateReq.GetLoadStateReqBuilder)GetLoadStateReq.builder().collectionName(collectionName)).build()).booleanValue())) {
            if (System.currentTimeMillis() - startTime > timeoutMs) {
                throw new MilvusClientException(ErrorCode.SERVER_ERROR, "Load collection timeout");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.out.println("Thread was interrupted, Failed to complete operation");
                return;
            }
        }
        return;
    }
}

