/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import com.google.gson.reflect.TypeToken;
import io.milvus.common.utils.JsonUtils;
import io.milvus.grpc.CollectionSchema;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.FunctionSchema;
import io.milvus.grpc.FunctionType;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.ValueField;
import io.milvus.param.ParamUtils;
import io.milvus.v2.common.DataType;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SchemaUtils {
    public static void checkNullEmptyString(String target, String title) {
        if (target == null || StringUtils.isBlank((CharSequence)target)) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, title + " cannot be null or empty");
        }
    }

    public static FieldSchema convertToGrpcFieldSchema(CreateCollectionReq.FieldSchema fieldSchema) {
        SchemaUtils.checkNullEmptyString(fieldSchema.getName(), "Field name");
        io.milvus.grpc.DataType dType = io.milvus.grpc.DataType.valueOf(fieldSchema.getDataType().name());
        FieldSchema.Builder builder = FieldSchema.newBuilder().setName(fieldSchema.getName()).setDescription(fieldSchema.getDescription()).setDataType(dType).setIsPrimaryKey(fieldSchema.getIsPrimaryKey()).setIsPartitionKey(fieldSchema.getIsPartitionKey()).setIsClusteringKey(fieldSchema.getIsClusteringKey()).setAutoID(fieldSchema.getAutoID()).setNullable(fieldSchema.getIsNullable());
        if (!ParamUtils.isVectorDataType(dType) && !fieldSchema.getIsPrimaryKey().booleanValue()) {
            ValueField value = ParamUtils.objectToValueField(fieldSchema.getDefaultValue(), dType);
            if (value != null) {
                builder.setDefaultValue(value);
            } else if (fieldSchema.getDefaultValue() != null) {
                String msg = String.format("Illegal default value for %s type field. Please use Short for Int8/Int16 fields, Short/Integer for Int32 fields, Short/Integer/Long for Int64 fields, Boolean for Bool fields, String for Varchar fields, JsonObject for JSON fields.", dType.name());
                throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
            }
        }
        if (fieldSchema.getDimension() != null) {
            builder.addTypeParams(KeyValuePair.newBuilder().setKey("dim").setValue(String.valueOf(fieldSchema.getDimension())).build()).build();
        }
        if (fieldSchema.getDataType() == DataType.VarChar && fieldSchema.getMaxLength() != null) {
            builder.addTypeParams(KeyValuePair.newBuilder().setKey("max_length").setValue(String.valueOf(fieldSchema.getMaxLength())).build()).build();
        }
        if (fieldSchema.getDataType() == DataType.Array) {
            builder.addTypeParams(KeyValuePair.newBuilder().setKey("max_capacity").setValue(String.valueOf(fieldSchema.getMaxCapacity())).build()).build();
            builder.setElementType(io.milvus.grpc.DataType.valueOf(fieldSchema.getElementType().name())).build();
            if (fieldSchema.getElementType() == DataType.VarChar && fieldSchema.getMaxLength() != null) {
                builder.addTypeParams(KeyValuePair.newBuilder().setKey("max_length").setValue(String.valueOf(fieldSchema.getMaxLength())).build()).build();
            }
        }
        if (fieldSchema.getEnableAnalyzer() != null) {
            builder.addTypeParams(KeyValuePair.newBuilder().setKey("enable_analyzer").setValue(String.valueOf(fieldSchema.getEnableAnalyzer())).build()).build();
        }
        if (fieldSchema.getEnableMatch() != null) {
            builder.addTypeParams(KeyValuePair.newBuilder().setKey("enable_match").setValue(String.valueOf(fieldSchema.getEnableMatch())).build()).build();
        }
        if (fieldSchema.getAnalyzerParams() != null) {
            String params = JsonUtils.toJson(fieldSchema.getAnalyzerParams());
            builder.addTypeParams(KeyValuePair.newBuilder().setKey("analyzer_params").setValue(params).build()).build();
        }
        return builder.build();
    }

    public static FunctionSchema convertToGrpcFunction(CreateCollectionReq.Function function) {
        SchemaUtils.checkNullEmptyString(function.getName(), "Function name");
        FunctionSchema.Builder builder = FunctionSchema.newBuilder().setName(function.getName()).setDescription(function.getDescription()).setType(FunctionType.valueOf(function.getFunctionType().name()));
        for (String name : function.getInputFieldNames()) {
            builder.addInputFieldNames(name);
        }
        for (String name : function.getOutputFieldNames()) {
            builder.addOutputFieldNames(name);
        }
        return builder.build();
    }

    public static CreateCollectionReq.CollectionSchema convertFromGrpcCollectionSchema(CollectionSchema schema) {
        Object collectionSchema = ((CreateCollectionReq.CollectionSchema.CollectionSchemaBuilder)CreateCollectionReq.CollectionSchema.builder().enableDynamicField(schema.getEnableDynamicField())).build();
        ArrayList<CreateCollectionReq.FieldSchema> fieldSchemas = new ArrayList<CreateCollectionReq.FieldSchema>();
        for (FieldSchema fieldSchema : schema.getFieldsList()) {
            fieldSchemas.add(SchemaUtils.convertFromGrpcFieldSchema(fieldSchema));
        }
        ((CreateCollectionReq.CollectionSchema)collectionSchema).setFieldSchemaList(fieldSchemas);
        ArrayList<CreateCollectionReq.Function> functions = new ArrayList<CreateCollectionReq.Function>();
        for (FunctionSchema functionSchema : schema.getFunctionsList()) {
            functions.add(SchemaUtils.convertFromGrpcFunction(functionSchema));
        }
        ((CreateCollectionReq.CollectionSchema)collectionSchema).setFunctionList(functions);
        return collectionSchema;
    }

    private static CreateCollectionReq.FieldSchema convertFromGrpcFieldSchema(FieldSchema fieldSchema) {
        Object schema = ((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)CreateCollectionReq.FieldSchema.builder().name(fieldSchema.getName())).description(fieldSchema.getDescription())).dataType(DataType.valueOf(fieldSchema.getDataType().name()))).isPrimaryKey(fieldSchema.getIsPrimaryKey())).isPartitionKey(fieldSchema.getIsPartitionKey())).isClusteringKey(fieldSchema.getIsClusteringKey())).autoID(fieldSchema.getAutoID())).elementType(DataType.valueOf(fieldSchema.getElementType().name()))).isNullable(fieldSchema.getNullable())).defaultValue(ParamUtils.valueFieldToObject(fieldSchema.getDefaultValue(), fieldSchema.getDataType()))).build();
        for (KeyValuePair keyValuePair : fieldSchema.getTypeParamsList()) {
            if (keyValuePair.getKey().equals("dim")) {
                ((CreateCollectionReq.FieldSchema)schema).setDimension(Integer.parseInt(keyValuePair.getValue()));
                continue;
            }
            if (keyValuePair.getKey().equals("max_length")) {
                ((CreateCollectionReq.FieldSchema)schema).setMaxLength(Integer.parseInt(keyValuePair.getValue()));
                continue;
            }
            if (keyValuePair.getKey().equals("max_capacity")) {
                ((CreateCollectionReq.FieldSchema)schema).setMaxCapacity(Integer.parseInt(keyValuePair.getValue()));
                continue;
            }
            if (keyValuePair.getKey().equals("enable_analyzer")) {
                ((CreateCollectionReq.FieldSchema)schema).setEnableAnalyzer(Boolean.parseBoolean(keyValuePair.getValue()));
                continue;
            }
            if (keyValuePair.getKey().equals("enable_match")) {
                ((CreateCollectionReq.FieldSchema)schema).setEnableMatch(Boolean.parseBoolean(keyValuePair.getValue()));
                continue;
            }
            if (!keyValuePair.getKey().equals("analyzer_params")) continue;
            Map params = (Map)JsonUtils.fromJson(keyValuePair.getValue(), new TypeToken<Map<String, Object>>(){}.getType());
            ((CreateCollectionReq.FieldSchema)schema).setAnalyzerParams(params);
        }
        return schema;
    }

    public static CreateCollectionReq.Function convertFromGrpcFunction(FunctionSchema functionSchema) {
        Object function = ((CreateCollectionReq.Function.FunctionBuilder)((CreateCollectionReq.Function.FunctionBuilder)((CreateCollectionReq.Function.FunctionBuilder)((CreateCollectionReq.Function.FunctionBuilder)((CreateCollectionReq.Function.FunctionBuilder)CreateCollectionReq.Function.builder().name(functionSchema.getName())).description(functionSchema.getDescription())).functionType(io.milvus.common.clientenum.FunctionType.valueOf(functionSchema.getType().name()))).inputFieldNames(functionSchema.getInputFieldNamesList().stream().collect(Collectors.toList()))).outputFieldNames(functionSchema.getOutputFieldNamesList().stream().collect(Collectors.toList()))).build();
        return function;
    }
}

