/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.common.resourcegroup;

import io.milvus.grpc.KeyValuePair;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;

public class ResourceGroupNodeFilter {
    private final Map<String, String> nodeLabels;

    private ResourceGroupNodeFilter(Builder builder) {
        this.nodeLabels = builder.nodeLabels;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @NonNull
    public io.milvus.grpc.ResourceGroupNodeFilter toGRPC() {
        List<KeyValuePair> pair = ParamUtils.AssembleKvPair(this.nodeLabels);
        return io.milvus.grpc.ResourceGroupNodeFilter.newBuilder().addAllNodeLabels(pair).build();
    }

    public ResourceGroupNodeFilter(io.milvus.grpc.ResourceGroupNodeFilter filter) {
        this.nodeLabels = filter.getNodeLabelsList().stream().collect(Collectors.toMap(KeyValuePair::getKey, KeyValuePair::getValue));
    }

    public Map<String, String> getNodeLabels() {
        return this.nodeLabels;
    }

    public static final class Builder {
        private Map<String, String> nodeLabels = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withNodeLabel(@NonNull String key, @NonNull String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.nodeLabels.put(key, value);
            return this;
        }

        public ResourceGroupNodeFilter build() {
            return new ResourceGroupNodeFilter(this);
        }
    }
}

