/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.index;

import com.google.gson.JsonObject;
import io.milvus.grpc.AlterIndexRequest;
import io.milvus.grpc.CreateIndexRequest;
import io.milvus.grpc.DescribeIndexRequest;
import io.milvus.grpc.DescribeIndexResponse;
import io.milvus.grpc.DropIndexRequest;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.IndexDescription;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.Status;
import io.milvus.param.ParamUtils;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.index.request.AlterIndexPropertiesReq;
import io.milvus.v2.service.index.request.CreateIndexReq;
import io.milvus.v2.service.index.request.DescribeIndexReq;
import io.milvus.v2.service.index.request.DropIndexPropertiesReq;
import io.milvus.v2.service.index.request.DropIndexReq;
import io.milvus.v2.service.index.request.ListIndexesReq;
import io.milvus.v2.service.index.response.DescribeIndexResp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IndexService
extends BaseService {
    public Void createIndex(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateIndexReq request) {
        for (IndexParam indexParam : request.getIndexParams()) {
            Map<String, Object> extraParams;
            String title = String.format("CreateIndexRequest collectionName:%s, fieldName:%s", request.getCollectionName(), indexParam.getFieldName());
            CreateIndexRequest.Builder builder = CreateIndexRequest.newBuilder();
            builder.setCollectionName(request.getCollectionName()).setIndexName(indexParam.getIndexName()).setFieldName(indexParam.getFieldName()).addExtraParams(KeyValuePair.newBuilder().setKey("index_type").setValue(indexParam.getIndexType().getName()).build());
            if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
                builder.setDbName(request.getDatabaseName());
            }
            if (indexParam.getMetricType() != null) {
                builder.addExtraParams(KeyValuePair.newBuilder().setKey("metric_type").setValue(indexParam.getMetricType().name()).build());
            }
            if ((extraParams = indexParam.getExtraParams()) != null && !extraParams.isEmpty()) {
                JsonObject params = new JsonObject();
                for (String key : extraParams.keySet()) {
                    params.addProperty(key, extraParams.get(key).toString());
                }
                builder.addExtraParams(KeyValuePair.newBuilder().setKey("params").setValue(params.toString()).build());
            }
            Status status = blockingStub.createIndex(builder.build());
            this.rpcUtils.handleResponse(title, status);
        }
        return null;
    }

    public Void dropIndex(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropIndexReq request) {
        String title = String.format("DropIndexRequest collectionName:%s, fieldName:%s, indexName:%s", request.getCollectionName(), request.getFieldName(), request.getIndexName());
        DropIndexRequest dropIndexRequest = DropIndexRequest.newBuilder().setCollectionName(request.getCollectionName()).setFieldName(request.getFieldName() == null ? "" : request.getFieldName()).setIndexName(request.getIndexName() == null ? "" : request.getIndexName()).build();
        Status status = blockingStub.dropIndex(dropIndexRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void alterIndexProperties(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, AlterIndexPropertiesReq request) {
        String title = String.format("AlterIndexPropertiesReq collectionName:%s, indexName:%s", request.getCollectionName(), request.getIndexName());
        AlterIndexRequest.Builder builder = AlterIndexRequest.newBuilder().setCollectionName(request.getCollectionName()).setIndexName(request.getIndexName());
        List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(request.getProperties());
        if (CollectionUtils.isNotEmpty(propertiesList)) {
            propertiesList.forEach(builder::addExtraParams);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        Status response = blockingStub.alterIndex(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void dropIndexProperties(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropIndexPropertiesReq request) {
        String title = String.format("DropIndexPropertiesReq collectionName:%s, indexName:%s", request.getCollectionName(), request.getIndexName());
        AlterIndexRequest.Builder builder = AlterIndexRequest.newBuilder().setCollectionName(request.getCollectionName()).setIndexName(request.getIndexName()).addAllDeleteKeys(request.getPropertyKeys());
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        Status response = blockingStub.alterIndex(builder.build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public DescribeIndexResp describeIndex(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeIndexReq request) {
        String title = String.format("DescribeIndexRequest collectionName:%s, fieldName:%s, indexName:%s", request.getCollectionName(), request.getFieldName(), request.getIndexName());
        DescribeIndexRequest describeIndexRequest = DescribeIndexRequest.newBuilder().setCollectionName(request.getCollectionName()).setFieldName(request.getFieldName() == null ? "" : request.getFieldName()).setIndexName(request.getIndexName() == null ? "" : request.getIndexName()).build();
        DescribeIndexResponse response = blockingStub.describeIndex(describeIndexRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        List<IndexDescription> indexs = response.getIndexDescriptionsList().stream().filter(index -> index.getIndexName().equals(request.getIndexName()) || index.getFieldName().equals(request.getFieldName())).collect(Collectors.toList());
        if (indexs.isEmpty()) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, "Index not found");
        }
        if (indexs.size() > 1) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, "More than one index found");
        }
        return this.convertUtils.convertToDescribeIndexResp(indexs);
    }

    public List<String> listIndexes(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, ListIndexesReq request) {
        DescribeIndexResponse response;
        String title = String.format("ListIndexesRequest collectionName:%s", request.getCollectionName());
        DescribeIndexRequest describeIndexRequest = DescribeIndexRequest.newBuilder().setCollectionName(request.getCollectionName()).build();
        if (request.getFieldName() != null) {
            describeIndexRequest = describeIndexRequest.toBuilder().setFieldName(request.getFieldName()).build();
        }
        if ((response = blockingStub.describeIndex(describeIndexRequest)).getStatus().getErrorCode() == ErrorCode.IndexNotExist || response.getStatus().getCode() == 700) {
            return new ArrayList<String>();
        }
        this.rpcUtils.handleResponse(title, response.getStatus());
        ArrayList<String> indexNames = new ArrayList<String>();
        response.getIndexDescriptionsList().forEach(index -> indexNames.add(index.getIndexName()));
        return indexNames;
    }
}

