/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.partition;

import io.milvus.grpc.BoolResponse;
import io.milvus.grpc.CreatePartitionRequest;
import io.milvus.grpc.DropPartitionRequest;
import io.milvus.grpc.GetPartitionStatisticsRequest;
import io.milvus.grpc.GetPartitionStatisticsResponse;
import io.milvus.grpc.HasPartitionRequest;
import io.milvus.grpc.LoadPartitionsRequest;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.ReleasePartitionsRequest;
import io.milvus.grpc.ShowPartitionsRequest;
import io.milvus.grpc.ShowPartitionsResponse;
import io.milvus.grpc.Status;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.partition.request.CreatePartitionReq;
import io.milvus.v2.service.partition.request.DropPartitionReq;
import io.milvus.v2.service.partition.request.GetPartitionStatsReq;
import io.milvus.v2.service.partition.request.HasPartitionReq;
import io.milvus.v2.service.partition.request.ListPartitionsReq;
import io.milvus.v2.service.partition.request.LoadPartitionsReq;
import io.milvus.v2.service.partition.request.ReleasePartitionsReq;
import io.milvus.v2.service.partition.response.GetPartitionStatsResp;
import java.util.List;

public class PartitionService
extends BaseService {
    public Void createPartition(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreatePartitionReq request) {
        String title = String.format("Create partition %s in collection %s", request.getPartitionName(), request.getCollectionName());
        CreatePartitionRequest createPartitionRequest = CreatePartitionRequest.newBuilder().setCollectionName(request.getCollectionName()).setPartitionName(request.getPartitionName()).build();
        Status status = blockingStub.createPartition(createPartitionRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void dropPartition(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropPartitionReq request) {
        String title = String.format("Drop partition %s in collection %s", request.getPartitionName(), request.getCollectionName());
        DropPartitionRequest dropPartitionRequest = DropPartitionRequest.newBuilder().setCollectionName(request.getCollectionName()).setPartitionName(request.getPartitionName()).build();
        Status status = blockingStub.dropPartition(dropPartitionRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Boolean hasPartition(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, HasPartitionReq request) {
        String title = String.format("Has partition %s in collection %s", request.getPartitionName(), request.getCollectionName());
        HasPartitionRequest hasPartitionRequest = HasPartitionRequest.newBuilder().setCollectionName(request.getCollectionName()).setPartitionName(request.getPartitionName()).build();
        BoolResponse boolResponse = blockingStub.hasPartition(hasPartitionRequest);
        this.rpcUtils.handleResponse(title, boolResponse.getStatus());
        return boolResponse.getValue();
    }

    public List<String> listPartitions(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, ListPartitionsReq request) {
        String title = String.format("List partitions in collection %s", request.getCollectionName());
        ShowPartitionsRequest showPartitionsRequest = ShowPartitionsRequest.newBuilder().setCollectionName(request.getCollectionName()).build();
        ShowPartitionsResponse showPartitionsResponse = blockingStub.showPartitions(showPartitionsRequest);
        this.rpcUtils.handleResponse(title, showPartitionsResponse.getStatus());
        return showPartitionsResponse.getPartitionNamesList();
    }

    public GetPartitionStatsResp getPartitionStats(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GetPartitionStatsReq request) {
        String title = String.format("GetCollectionStatisticsRequest collectionName:%s", request.getCollectionName());
        GetPartitionStatisticsRequest getPartitionStatisticsRequest = GetPartitionStatisticsRequest.newBuilder().setCollectionName(request.getCollectionName()).setPartitionName(request.getPartitionName()).build();
        GetPartitionStatisticsResponse response = blockingStub.getPartitionStatistics(getPartitionStatisticsRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        Object getPartitionStatsResp = ((GetPartitionStatsResp.GetPartitionStatsRespBuilder)GetPartitionStatsResp.builder().numOfEntities(response.getStatsList().stream().filter(stat -> stat.getKey().equals("row_count")).map(stat -> Long.parseLong(stat.getValue())).findFirst().get())).build();
        return getPartitionStatsResp;
    }

    public Void loadPartitions(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, LoadPartitionsReq request) {
        String title = String.format("Load partitions %s in collection %s", request.getPartitionNames(), request.getCollectionName());
        LoadPartitionsRequest loadPartitionsRequest = LoadPartitionsRequest.newBuilder().setCollectionName(request.getCollectionName()).addAllPartitionNames(request.getPartitionNames()).setReplicaNumber(request.getNumReplicas()).setRefresh(request.getRefresh()).addAllLoadFields(request.getLoadFields()).setSkipLoadDynamicField(request.getSkipLoadDynamicField()).addAllResourceGroups(request.getResourceGroups()).build();
        Status status = blockingStub.loadPartitions(loadPartitionsRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void releasePartitions(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, ReleasePartitionsReq request) {
        String title = String.format("Release partitions %s in collection %s", request.getPartitionNames(), request.getCollectionName());
        ReleasePartitionsRequest releasePartitionsRequest = ReleasePartitionsRequest.newBuilder().setCollectionName(request.getCollectionName()).addAllPartitionNames(request.getPartitionNames()).build();
        Status status = blockingStub.releasePartitions(releasePartitionsRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }
}

