/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.google.protobuf.ByteString;
import io.milvus.common.utils.GTsDict;
import io.milvus.common.utils.JsonUtils;
import io.milvus.exception.ParamException;
import io.milvus.grpc.BoolArray;
import io.milvus.grpc.DoubleArray;
import io.milvus.grpc.DslType;
import io.milvus.grpc.HybridSearchRequest;
import io.milvus.grpc.JSONArray;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.LongArray;
import io.milvus.grpc.PlaceholderGroup;
import io.milvus.grpc.PlaceholderType;
import io.milvus.grpc.PlaceholderValue;
import io.milvus.grpc.QueryRequest;
import io.milvus.grpc.SearchRequest;
import io.milvus.grpc.StringArray;
import io.milvus.grpc.TemplateArrayValue;
import io.milvus.grpc.TemplateArrayValueArray;
import io.milvus.grpc.TemplateValue;
import io.milvus.param.ParamUtils;
import io.milvus.v2.common.ConsistencyLevel;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.vector.request.AnnSearchReq;
import io.milvus.v2.service.vector.request.HybridSearchReq;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.data.BaseVector;
import io.milvus.v2.service.vector.request.ranker.BaseRanker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class VectorUtils {
    public QueryRequest ConvertToGrpcQueryRequest(QueryReq request) {
        long limit;
        QueryRequest.Builder builder = QueryRequest.newBuilder().setCollectionName(request.getCollectionName()).addAllPartitionNames(request.getPartitionNames()).addAllOutputFields(request.getOutputFields()).setExpr(request.getFilter());
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        if (request.getFilter() != null && !request.getFilter().isEmpty()) {
            Map<String, Object> filterTemplateValues = request.getFilterTemplateValues();
            filterTemplateValues.forEach((key, value) -> builder.putExprTemplateValues((String)key, VectorUtils.deduceAndCreateTemplateValue(value)));
        }
        if (request.getConsistencyLevel() == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(request.getConsistencyLevel().getCode());
        }
        long offset = request.getOffset();
        if (offset > 0L) {
            builder.addQueryParams(KeyValuePair.newBuilder().setKey("offset").setValue(String.valueOf(offset)).build());
        }
        if ((limit = request.getLimit()) > 0L) {
            builder.addQueryParams(KeyValuePair.newBuilder().setKey("limit").setValue(String.valueOf(limit)).build());
        }
        return builder.build();
    }

    private static long getGuaranteeTimestamp(ConsistencyLevel consistencyLevel, String collectionName) {
        if (consistencyLevel == null) {
            Long ts = GTsDict.getInstance().getCollectionTs(collectionName);
            return ts == null ? 1L : ts;
        }
        switch (consistencyLevel) {
            case STRONG: {
                return 0L;
            }
            case SESSION: {
                Long ts = GTsDict.getInstance().getCollectionTs(collectionName);
                return ts == null ? 1L : ts;
            }
            case BOUNDED: {
                return 2L;
            }
        }
        return 1L;
    }

    private static ByteString convertPlaceholder(List<Object> data, PlaceholderType placeType) {
        if (placeType == PlaceholderType.VarChar) {
            ArrayList<ByteString> byteStrings = new ArrayList<ByteString>();
            for (Object obj : data) {
                byteStrings.add(ByteString.copyFrom((byte[])((String)obj).getBytes()));
            }
            PlaceholderValue.Builder pldBuilder = PlaceholderValue.newBuilder().setTag("$0").setType(placeType);
            byteStrings.forEach(pldBuilder::addValues);
            PlaceholderValue plv = pldBuilder.build();
            PlaceholderGroup placeholderGroup = PlaceholderGroup.newBuilder().addPlaceholders(plv).build();
            return placeholderGroup.toByteString();
        }
        try {
            return ParamUtils.convertPlaceholder(data, placeType);
        }
        catch (ParamException e) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, e.getMessage());
        }
    }

    public SearchRequest ConvertToGrpcSearchRequest(SearchReq request) {
        List<BaseVector> vectors;
        SearchRequest.Builder builder = SearchRequest.newBuilder().setCollectionName(request.getCollectionName());
        if (!request.getPartitionNames().isEmpty()) {
            request.getPartitionNames().forEach(builder::addPartitionNames);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        if ((vectors = request.getData()).isEmpty()) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Target data list of search request is empty.");
        }
        PlaceholderType plType = vectors.get(0).getPlaceholderType();
        ArrayList<Object> data = new ArrayList<Object>();
        for (BaseVector vector : vectors) {
            if (vector.getPlaceholderType() != plType) {
                throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Different types of target vectors in a search request is not allowed.");
            }
            data.add(vector.getData());
        }
        ByteString byteStr = VectorUtils.convertPlaceholder(data, plType);
        builder.setPlaceholderGroup(byteStr);
        builder.setNq(vectors.size());
        Map<String, Object> searchParams = request.getSearchParams();
        ParamUtils.compatibleSearchParams(searchParams, builder);
        if (StringUtils.isNotEmpty((CharSequence)request.getAnnsField())) {
            builder.addSearchParams(KeyValuePair.newBuilder().setKey("anns_field").setValue(request.getAnnsField()).build());
        }
        builder.addSearchParams(KeyValuePair.newBuilder().setKey("topk").setValue(String.valueOf(request.getTopK())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("round_decimal").setValue(String.valueOf(request.getRoundDecimal())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("ignore_growing").setValue(String.valueOf(request.isIgnoreGrowing())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("offset").setValue(String.valueOf(request.getOffset())).build());
        if (null != request.getMetricType()) {
            builder.addSearchParams(KeyValuePair.newBuilder().setKey("metric_type").setValue(request.getMetricType().name()).build());
        }
        if (request.getGroupByFieldName() != null && !request.getGroupByFieldName().isEmpty()) {
            builder.addSearchParams(KeyValuePair.newBuilder().setKey("group_by_field").setValue(request.getGroupByFieldName()).build());
            if (request.getGroupSize() != null) {
                builder.addSearchParams(KeyValuePair.newBuilder().setKey("group_size").setValue(request.getGroupSize().toString()).build());
            }
            if (request.getStrictGroupSize() != null) {
                builder.addSearchParams(KeyValuePair.newBuilder().setKey("strict_group_size").setValue(request.getStrictGroupSize().toString()).build());
            }
        }
        if (!request.getOutputFields().isEmpty()) {
            request.getOutputFields().forEach(builder::addOutputFields);
        }
        builder.setDslType(DslType.BoolExprV1);
        if (request.getFilter() != null && !request.getFilter().isEmpty()) {
            builder.setDsl(request.getFilter());
            Map<String, Object> filterTemplateValues = request.getFilterTemplateValues();
            filterTemplateValues.forEach((key, value) -> builder.putExprTemplateValues((String)key, VectorUtils.deduceAndCreateTemplateValue(value)));
        }
        if (request.getSearchParams().containsKey("iterator")) {
            long guaranteeTimestamp = 0L;
            if (request.getSearchParams().containsKey("guarantee_timestamp")) {
                guaranteeTimestamp = (Long)request.getSearchParams().get("guarantee_timestamp");
            }
            builder.setGuaranteeTimestamp(guaranteeTimestamp);
        } else {
            long guaranteeTimestamp = VectorUtils.getGuaranteeTimestamp(request.getConsistencyLevel(), request.getCollectionName());
            builder.setGuaranteeTimestamp(guaranteeTimestamp);
        }
        if (request.getConsistencyLevel() == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(request.getConsistencyLevel().getCode());
        }
        return builder.build();
    }

    private static TemplateArrayValue deduceTemplateArray(List<?> array) {
        if (array.isEmpty()) {
            return TemplateArrayValue.newBuilder().build();
        }
        Object firstObj = array.get(0);
        if (firstObj instanceof Boolean) {
            BoolArray.Builder builder = BoolArray.newBuilder();
            array.forEach(val -> {
                if (!(val instanceof Boolean)) {
                    throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Filter expression template is a list, the first value is Boolean, but some elements are not Boolean");
                }
                builder.addData((Boolean)val);
            });
            return TemplateArrayValue.newBuilder().setBoolData(builder.build()).build();
        }
        if (firstObj instanceof Integer || firstObj instanceof Long) {
            LongArray.Builder builder = LongArray.newBuilder();
            array.forEach(val -> {
                if (!(val instanceof Integer) && !(val instanceof Long)) {
                    throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Filter expression template is a list, the first value is Integer/Long, but some elements are not Integer/Long");
                }
                builder.addData(val instanceof Integer ? (long)((Integer)val).intValue() : (Long)val);
            });
            return TemplateArrayValue.newBuilder().setLongData(builder.build()).build();
        }
        if (firstObj instanceof Double) {
            DoubleArray.Builder builder = DoubleArray.newBuilder();
            array.forEach(val -> {
                if (!(val instanceof Double)) {
                    throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Filter expression template is a list, the first value is Double, but some elements are not Double");
                }
                builder.addData((Double)val);
            });
            return TemplateArrayValue.newBuilder().setDoubleData(builder.build()).build();
        }
        if (firstObj instanceof String) {
            StringArray.Builder builder = StringArray.newBuilder();
            array.forEach(val -> {
                if (!(val instanceof String)) {
                    throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Filter expression template is a list, the first value is String, but some elements are not String");
                }
                builder.addData((String)val);
            });
            return TemplateArrayValue.newBuilder().setStringData(builder.build()).build();
        }
        if (firstObj instanceof JsonElement) {
            JSONArray.Builder builder = JSONArray.newBuilder();
            array.forEach(val -> {
                if (!(val instanceof JsonElement)) {
                    throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Filter expression template is a list, the first value is JsonElement, but some elements are not JsonElement");
                }
                String str = JsonUtils.toJson((JsonElement)val);
                builder.addData(ByteString.copyFromUtf8((String)str));
            });
            return TemplateArrayValue.newBuilder().setJsonData(builder.build()).build();
        }
        if (firstObj instanceof List) {
            TemplateArrayValueArray.Builder builder = TemplateArrayValueArray.newBuilder();
            array.forEach(val -> {
                if (!(val instanceof List)) {
                    throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Filter expression template is a list, the first value is List, but some elements are not List");
                }
                List subArrary = (List)val;
                builder.addData(VectorUtils.deduceTemplateArray(subArrary));
            });
            return TemplateArrayValue.newBuilder().setArrayData(builder.build()).build();
        }
        throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Unsupported value type for filter expression template.");
    }

    public static TemplateValue deduceAndCreateTemplateValue(Object value) {
        if (value instanceof Boolean) {
            return TemplateValue.newBuilder().setBoolVal((Boolean)value).build();
        }
        if (value instanceof Integer || value instanceof Long) {
            return TemplateValue.newBuilder().setInt64Val(value instanceof Integer ? (long)((Integer)value).intValue() : (Long)value).build();
        }
        if (value instanceof Double) {
            return TemplateValue.newBuilder().setFloatVal((Double)value).build();
        }
        if (value instanceof String) {
            return TemplateValue.newBuilder().setStringVal((String)value).build();
        }
        if (value instanceof List) {
            List array = (List)value;
            TemplateArrayValue tav = VectorUtils.deduceTemplateArray(array);
            return TemplateValue.newBuilder().setArrayVal(tav).build();
        }
        throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Unsupported value type for filter expression template.");
    }

    public static SearchRequest convertAnnSearchParam(@NonNull AnnSearchReq annSearchReq, ConsistencyLevel consistencyLevel) {
        if (annSearchReq == null) {
            throw new NullPointerException("annSearchReq is marked non-null but is null");
        }
        SearchRequest.Builder builder = SearchRequest.newBuilder();
        List<BaseVector> vectors = annSearchReq.getVectors();
        if (vectors.isEmpty()) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Target vectors list of search request is empty.");
        }
        PlaceholderType plType = vectors.get(0).getPlaceholderType();
        ArrayList<Object> data = new ArrayList<Object>();
        for (BaseVector vector : vectors) {
            if (vector.getPlaceholderType() != plType) {
                throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Different types of target vectors in a search request is not allowed.");
            }
            data.add(vector.getData());
        }
        ByteString byteStr = VectorUtils.convertPlaceholder(data, plType);
        builder.setPlaceholderGroup(byteStr);
        builder.setNq(vectors.size());
        Map<String, Object> paramMap = new HashMap<String, Object>();
        if (null != annSearchReq.getParams() && !annSearchReq.getParams().isEmpty()) {
            paramMap = (Map)JsonUtils.fromJson(annSearchReq.getParams(), new TypeToken<Map<String, Object>>(){}.getType());
        }
        ParamUtils.compatibleSearchParams(paramMap, builder);
        builder.addSearchParams(KeyValuePair.newBuilder().setKey("anns_field").setValue(annSearchReq.getVectorFieldName()).build()).addSearchParams(KeyValuePair.newBuilder().setKey("topk").setValue(String.valueOf(annSearchReq.getTopK())).build());
        if (annSearchReq.getMetricType() != null) {
            builder.addSearchParams(KeyValuePair.newBuilder().setKey("metric_type").setValue(annSearchReq.getMetricType().name()).build());
        }
        builder.setDslType(DslType.BoolExprV1);
        if (annSearchReq.getExpr() != null && !annSearchReq.getExpr().isEmpty()) {
            builder.setDsl(annSearchReq.getExpr());
        }
        if (consistencyLevel == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(consistencyLevel.getCode());
        }
        return builder.build();
    }

    public HybridSearchRequest ConvertToGrpcHybridSearchRequest(HybridSearchReq request) {
        HybridSearchRequest.Builder builder = HybridSearchRequest.newBuilder().setCollectionName(request.getCollectionName());
        if (request.getPartitionNames() != null && !request.getPartitionNames().isEmpty()) {
            request.getPartitionNames().forEach(builder::addPartitionNames);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        if (request.getSearchRequests() == null || request.getSearchRequests().isEmpty()) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Sub-request list is empty.");
        }
        for (AnnSearchReq req : request.getSearchRequests()) {
            SearchRequest searchRequest = VectorUtils.convertAnnSearchParam(req, request.getConsistencyLevel());
            builder.addRequests(searchRequest);
        }
        BaseRanker ranker = request.getRanker();
        if (request.getRanker() == null) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Ranker is null.");
        }
        Map<String, String> props = ranker.getProperties();
        props.put("limit", String.format("%d", request.getTopK()));
        props.put("round_decimal", String.format("%d", request.getRoundDecimal()));
        List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(props);
        if (CollectionUtils.isNotEmpty(propertiesList)) {
            propertiesList.forEach(builder::addRankParams);
        }
        if (request.getGroupByFieldName() != null && !request.getGroupByFieldName().isEmpty()) {
            builder.addRankParams(KeyValuePair.newBuilder().setKey("group_by_field").setValue(request.getGroupByFieldName()).build());
            if (request.getGroupSize() != null) {
                builder.addRankParams(KeyValuePair.newBuilder().setKey("group_size").setValue(request.getGroupSize().toString().toString()).build());
            }
            if (request.getStrictGroupSize() != null) {
                builder.addRankParams(KeyValuePair.newBuilder().setKey("strict_group_size").setValue(request.getStrictGroupSize().toString()).build());
            }
        }
        if (request.getOutFields() != null && !request.getOutFields().isEmpty()) {
            request.getOutFields().forEach(builder::addOutputFields);
        }
        if (request.getConsistencyLevel() == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(request.getConsistencyLevel().getCode());
        }
        return builder.build();
    }

    public String getExprById(String primaryFieldName, List<?> ids) {
        StringBuilder sb = new StringBuilder();
        sb.append(primaryFieldName).append(" in [");
        for (Object id : ids) {
            if (id instanceof String) {
                sb.append("\"").append(id.toString()).append("\",");
                continue;
            }
            sb.append(id.toString()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }
}

