/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.index.response;

import io.milvus.v2.common.IndexBuildState;
import io.milvus.v2.common.IndexParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class DescribeIndexResp {
    List<IndexDesc> indexDescriptions;

    public IndexDesc getIndexDescByFieldName(@NonNull String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        for (IndexDesc desc : this.indexDescriptions) {
            if (!desc.fieldName.equals(fieldName)) continue;
            return desc;
        }
        return null;
    }

    public IndexDesc getIndexDescByIndexName(@NonNull String indexName) {
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        for (IndexDesc desc : this.indexDescriptions) {
            if (!desc.indexName.equals(indexName)) continue;
            return desc;
        }
        return null;
    }

    private static List<IndexDesc> $default$indexDescriptions() {
        return new ArrayList<IndexDesc>();
    }

    protected DescribeIndexResp(DescribeIndexRespBuilder<?, ?> b) {
        this.indexDescriptions = ((DescribeIndexRespBuilder)b).indexDescriptions$set ? ((DescribeIndexRespBuilder)b).indexDescriptions$value : DescribeIndexResp.$default$indexDescriptions();
    }

    public static DescribeIndexRespBuilder<?, ?> builder() {
        return new DescribeIndexRespBuilderImpl();
    }

    public List<IndexDesc> getIndexDescriptions() {
        return this.indexDescriptions;
    }

    public void setIndexDescriptions(List<IndexDesc> indexDescriptions) {
        this.indexDescriptions = indexDescriptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DescribeIndexResp)) {
            return false;
        }
        DescribeIndexResp other = (DescribeIndexResp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<IndexDesc> this$indexDescriptions = this.getIndexDescriptions();
        List<IndexDesc> other$indexDescriptions = other.getIndexDescriptions();
        return !(this$indexDescriptions == null ? other$indexDescriptions != null : !((Object)this$indexDescriptions).equals(other$indexDescriptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DescribeIndexResp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<IndexDesc> $indexDescriptions = this.getIndexDescriptions();
        result = result * 59 + ($indexDescriptions == null ? 43 : ((Object)$indexDescriptions).hashCode());
        return result;
    }

    public String toString() {
        return "DescribeIndexResp(indexDescriptions=" + this.getIndexDescriptions() + ")";
    }

    private static final class DescribeIndexRespBuilderImpl
    extends DescribeIndexRespBuilder<DescribeIndexResp, DescribeIndexRespBuilderImpl> {
        private DescribeIndexRespBuilderImpl() {
        }

        @Override
        protected DescribeIndexRespBuilderImpl self() {
            return this;
        }

        @Override
        public DescribeIndexResp build() {
            return new DescribeIndexResp(this);
        }
    }

    public static abstract class DescribeIndexRespBuilder<C extends DescribeIndexResp, B extends DescribeIndexRespBuilder<C, B>> {
        private boolean indexDescriptions$set;
        private List<IndexDesc> indexDescriptions$value;

        protected abstract B self();

        public abstract C build();

        public B indexDescriptions(List<IndexDesc> indexDescriptions) {
            this.indexDescriptions$value = indexDescriptions;
            this.indexDescriptions$set = true;
            return this.self();
        }

        public String toString() {
            return "DescribeIndexResp.DescribeIndexRespBuilder(indexDescriptions$value=" + this.indexDescriptions$value + ")";
        }
    }

    public static final class IndexDesc {
        private String fieldName;
        private String indexName;
        private long id;
        private IndexParam.IndexType indexType;
        private IndexParam.MetricType metricType;
        private Map<String, String> extraParams;
        long indexedRows;
        long totalRows;
        long pendingIndexRows;
        private IndexBuildState indexState;
        String indexFailedReason;
        @Deprecated
        private Map<String, String> properties;

        private static IndexParam.IndexType $default$indexType() {
            return IndexParam.IndexType.None;
        }

        private static IndexParam.MetricType $default$metricType() {
            return IndexParam.MetricType.INVALID;
        }

        private static Map<String, String> $default$extraParams() {
            return new HashMap<String, String>();
        }

        private static long $default$indexedRows() {
            return 0L;
        }

        private static long $default$totalRows() {
            return 0L;
        }

        private static long $default$pendingIndexRows() {
            return 0L;
        }

        private static IndexBuildState $default$indexState() {
            return IndexBuildState.IndexStateNone;
        }

        private static String $default$indexFailedReason() {
            return "";
        }

        private static Map<String, String> $default$properties() {
            return new HashMap<String, String>();
        }

        protected IndexDesc(IndexDescBuilder<?, ?> b) {
            this.fieldName = ((IndexDescBuilder)b).fieldName;
            this.indexName = ((IndexDescBuilder)b).indexName;
            this.id = ((IndexDescBuilder)b).id;
            this.indexType = ((IndexDescBuilder)b).indexType$set ? ((IndexDescBuilder)b).indexType$value : IndexDesc.$default$indexType();
            this.metricType = ((IndexDescBuilder)b).metricType$set ? ((IndexDescBuilder)b).metricType$value : IndexDesc.$default$metricType();
            this.extraParams = ((IndexDescBuilder)b).extraParams$set ? ((IndexDescBuilder)b).extraParams$value : IndexDesc.$default$extraParams();
            this.indexedRows = ((IndexDescBuilder)b).indexedRows$set ? ((IndexDescBuilder)b).indexedRows$value : IndexDesc.$default$indexedRows();
            this.totalRows = ((IndexDescBuilder)b).totalRows$set ? ((IndexDescBuilder)b).totalRows$value : IndexDesc.$default$totalRows();
            this.pendingIndexRows = ((IndexDescBuilder)b).pendingIndexRows$set ? ((IndexDescBuilder)b).pendingIndexRows$value : IndexDesc.$default$pendingIndexRows();
            this.indexState = ((IndexDescBuilder)b).indexState$set ? ((IndexDescBuilder)b).indexState$value : IndexDesc.$default$indexState();
            this.indexFailedReason = ((IndexDescBuilder)b).indexFailedReason$set ? ((IndexDescBuilder)b).indexFailedReason$value : IndexDesc.$default$indexFailedReason();
            this.properties = ((IndexDescBuilder)b).properties$set ? ((IndexDescBuilder)b).properties$value : IndexDesc.$default$properties();
        }

        public static IndexDescBuilder<?, ?> builder() {
            return new IndexDescBuilderImpl();
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public long getId() {
            return this.id;
        }

        public IndexParam.IndexType getIndexType() {
            return this.indexType;
        }

        public IndexParam.MetricType getMetricType() {
            return this.metricType;
        }

        public Map<String, String> getExtraParams() {
            return this.extraParams;
        }

        public long getIndexedRows() {
            return this.indexedRows;
        }

        public long getTotalRows() {
            return this.totalRows;
        }

        public long getPendingIndexRows() {
            return this.pendingIndexRows;
        }

        public IndexBuildState getIndexState() {
            return this.indexState;
        }

        public String getIndexFailedReason() {
            return this.indexFailedReason;
        }

        @Deprecated
        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public void setId(long id) {
            this.id = id;
        }

        public void setIndexType(IndexParam.IndexType indexType) {
            this.indexType = indexType;
        }

        public void setMetricType(IndexParam.MetricType metricType) {
            this.metricType = metricType;
        }

        public void setExtraParams(Map<String, String> extraParams) {
            this.extraParams = extraParams;
        }

        public void setIndexedRows(long indexedRows) {
            this.indexedRows = indexedRows;
        }

        public void setTotalRows(long totalRows) {
            this.totalRows = totalRows;
        }

        public void setPendingIndexRows(long pendingIndexRows) {
            this.pendingIndexRows = pendingIndexRows;
        }

        public void setIndexState(IndexBuildState indexState) {
            this.indexState = indexState;
        }

        public void setIndexFailedReason(String indexFailedReason) {
            this.indexFailedReason = indexFailedReason;
        }

        @Deprecated
        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexDesc)) {
                return false;
            }
            IndexDesc other = (IndexDesc)o;
            if (this.getId() != other.getId()) {
                return false;
            }
            if (this.getIndexedRows() != other.getIndexedRows()) {
                return false;
            }
            if (this.getTotalRows() != other.getTotalRows()) {
                return false;
            }
            if (this.getPendingIndexRows() != other.getPendingIndexRows()) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            String this$indexName = this.getIndexName();
            String other$indexName = other.getIndexName();
            if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
                return false;
            }
            IndexParam.IndexType this$indexType = this.getIndexType();
            IndexParam.IndexType other$indexType = other.getIndexType();
            if (this$indexType == null ? other$indexType != null : !((Object)((Object)this$indexType)).equals((Object)other$indexType)) {
                return false;
            }
            IndexParam.MetricType this$metricType = this.getMetricType();
            IndexParam.MetricType other$metricType = other.getMetricType();
            if (this$metricType == null ? other$metricType != null : !((Object)((Object)this$metricType)).equals((Object)other$metricType)) {
                return false;
            }
            Map<String, String> this$extraParams = this.getExtraParams();
            Map<String, String> other$extraParams = other.getExtraParams();
            if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                return false;
            }
            IndexBuildState this$indexState = this.getIndexState();
            IndexBuildState other$indexState = other.getIndexState();
            if (this$indexState == null ? other$indexState != null : !((Object)((Object)this$indexState)).equals((Object)other$indexState)) {
                return false;
            }
            String this$indexFailedReason = this.getIndexFailedReason();
            String other$indexFailedReason = other.getIndexFailedReason();
            if (this$indexFailedReason == null ? other$indexFailedReason != null : !this$indexFailedReason.equals(other$indexFailedReason)) {
                return false;
            }
            Map<String, String> this$properties = this.getProperties();
            Map<String, String> other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            long $indexedRows = this.getIndexedRows();
            result = result * 59 + (int)($indexedRows >>> 32 ^ $indexedRows);
            long $totalRows = this.getTotalRows();
            result = result * 59 + (int)($totalRows >>> 32 ^ $totalRows);
            long $pendingIndexRows = this.getPendingIndexRows();
            result = result * 59 + (int)($pendingIndexRows >>> 32 ^ $pendingIndexRows);
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            String $indexName = this.getIndexName();
            result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
            IndexParam.IndexType $indexType = this.getIndexType();
            result = result * 59 + ($indexType == null ? 43 : ((Object)((Object)$indexType)).hashCode());
            IndexParam.MetricType $metricType = this.getMetricType();
            result = result * 59 + ($metricType == null ? 43 : ((Object)((Object)$metricType)).hashCode());
            Map<String, String> $extraParams = this.getExtraParams();
            result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
            IndexBuildState $indexState = this.getIndexState();
            result = result * 59 + ($indexState == null ? 43 : ((Object)((Object)$indexState)).hashCode());
            String $indexFailedReason = this.getIndexFailedReason();
            result = result * 59 + ($indexFailedReason == null ? 43 : $indexFailedReason.hashCode());
            Map<String, String> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        public String toString() {
            return "DescribeIndexResp.IndexDesc(fieldName=" + this.getFieldName() + ", indexName=" + this.getIndexName() + ", id=" + this.getId() + ", indexType=" + (Object)((Object)this.getIndexType()) + ", metricType=" + (Object)((Object)this.getMetricType()) + ", extraParams=" + this.getExtraParams() + ", indexedRows=" + this.getIndexedRows() + ", totalRows=" + this.getTotalRows() + ", pendingIndexRows=" + this.getPendingIndexRows() + ", indexState=" + (Object)((Object)this.getIndexState()) + ", indexFailedReason=" + this.getIndexFailedReason() + ", properties=" + this.getProperties() + ")";
        }

        private static final class IndexDescBuilderImpl
        extends IndexDescBuilder<IndexDesc, IndexDescBuilderImpl> {
            private IndexDescBuilderImpl() {
            }

            @Override
            protected IndexDescBuilderImpl self() {
                return this;
            }

            @Override
            public IndexDesc build() {
                return new IndexDesc(this);
            }
        }

        public static abstract class IndexDescBuilder<C extends IndexDesc, B extends IndexDescBuilder<C, B>> {
            private String fieldName;
            private String indexName;
            private long id;
            private boolean indexType$set;
            private IndexParam.IndexType indexType$value;
            private boolean metricType$set;
            private IndexParam.MetricType metricType$value;
            private boolean extraParams$set;
            private Map<String, String> extraParams$value;
            private boolean indexedRows$set;
            private long indexedRows$value;
            private boolean totalRows$set;
            private long totalRows$value;
            private boolean pendingIndexRows$set;
            private long pendingIndexRows$value;
            private boolean indexState$set;
            private IndexBuildState indexState$value;
            private boolean indexFailedReason$set;
            private String indexFailedReason$value;
            private boolean properties$set;
            private Map<String, String> properties$value;

            protected abstract B self();

            public abstract C build();

            public B fieldName(String fieldName) {
                this.fieldName = fieldName;
                return this.self();
            }

            public B indexName(String indexName) {
                this.indexName = indexName;
                return this.self();
            }

            public B id(long id) {
                this.id = id;
                return this.self();
            }

            public B indexType(IndexParam.IndexType indexType) {
                this.indexType$value = indexType;
                this.indexType$set = true;
                return this.self();
            }

            public B metricType(IndexParam.MetricType metricType) {
                this.metricType$value = metricType;
                this.metricType$set = true;
                return this.self();
            }

            public B extraParams(Map<String, String> extraParams) {
                this.extraParams$value = extraParams;
                this.extraParams$set = true;
                return this.self();
            }

            public B indexedRows(long indexedRows) {
                this.indexedRows$value = indexedRows;
                this.indexedRows$set = true;
                return this.self();
            }

            public B totalRows(long totalRows) {
                this.totalRows$value = totalRows;
                this.totalRows$set = true;
                return this.self();
            }

            public B pendingIndexRows(long pendingIndexRows) {
                this.pendingIndexRows$value = pendingIndexRows;
                this.pendingIndexRows$set = true;
                return this.self();
            }

            public B indexState(IndexBuildState indexState) {
                this.indexState$value = indexState;
                this.indexState$set = true;
                return this.self();
            }

            public B indexFailedReason(String indexFailedReason) {
                this.indexFailedReason$value = indexFailedReason;
                this.indexFailedReason$set = true;
                return this.self();
            }

            @Deprecated
            public B properties(Map<String, String> properties) {
                this.properties$value = properties;
                this.properties$set = true;
                return this.self();
            }

            public String toString() {
                return "DescribeIndexResp.IndexDesc.IndexDescBuilder(fieldName=" + this.fieldName + ", indexName=" + this.indexName + ", id=" + this.id + ", indexType$value=" + (Object)((Object)this.indexType$value) + ", metricType$value=" + (Object)((Object)this.metricType$value) + ", extraParams$value=" + this.extraParams$value + ", indexedRows$value=" + this.indexedRows$value + ", totalRows$value=" + this.totalRows$value + ", pendingIndexRows$value=" + this.pendingIndexRows$value + ", indexState$value=" + (Object)((Object)this.indexState$value) + ", indexFailedReason$value=" + this.indexFailedReason$value + ", properties$value=" + this.properties$value + ")";
            }
        }
    }
}

