/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.utility;

import io.milvus.grpc.AlterAliasRequest;
import io.milvus.grpc.CheckHealthRequest;
import io.milvus.grpc.CheckHealthResponse;
import io.milvus.grpc.CreateAliasRequest;
import io.milvus.grpc.DescribeAliasRequest;
import io.milvus.grpc.DescribeAliasResponse;
import io.milvus.grpc.DescribeCollectionRequest;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.DropAliasRequest;
import io.milvus.grpc.FlushRequest;
import io.milvus.grpc.FlushResponse;
import io.milvus.grpc.GetCompactionStateRequest;
import io.milvus.grpc.GetCompactionStateResponse;
import io.milvus.grpc.GetFlushStateRequest;
import io.milvus.grpc.GetFlushStateResponse;
import io.milvus.grpc.GetPersistentSegmentInfoRequest;
import io.milvus.grpc.GetPersistentSegmentInfoResponse;
import io.milvus.grpc.GetQuerySegmentInfoRequest;
import io.milvus.grpc.GetQuerySegmentInfoResponse;
import io.milvus.grpc.ListAliasesRequest;
import io.milvus.grpc.ListAliasesResponse;
import io.milvus.grpc.LongArray;
import io.milvus.grpc.ManualCompactionRequest;
import io.milvus.grpc.ManualCompactionResponse;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.Status;
import io.milvus.v2.common.CompactionState;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.utility.request.AlterAliasReq;
import io.milvus.v2.service.utility.request.CompactReq;
import io.milvus.v2.service.utility.request.CreateAliasReq;
import io.milvus.v2.service.utility.request.DescribeAliasReq;
import io.milvus.v2.service.utility.request.DropAliasReq;
import io.milvus.v2.service.utility.request.FlushReq;
import io.milvus.v2.service.utility.request.GetCompactionStateReq;
import io.milvus.v2.service.utility.request.GetPersistentSegmentInfoReq;
import io.milvus.v2.service.utility.request.GetQuerySegmentInfoReq;
import io.milvus.v2.service.utility.request.ListAliasesReq;
import io.milvus.v2.service.utility.response.CheckHealthResp;
import io.milvus.v2.service.utility.response.CompactResp;
import io.milvus.v2.service.utility.response.DescribeAliasResp;
import io.milvus.v2.service.utility.response.FlushResp;
import io.milvus.v2.service.utility.response.GetCompactionStateResp;
import io.milvus.v2.service.utility.response.GetPersistentSegmentInfoResp;
import io.milvus.v2.service.utility.response.GetQuerySegmentInfoResp;
import io.milvus.v2.service.utility.response.ListAliasResp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UtilityService
extends BaseService {
    public FlushResp flush(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, FlushReq request) {
        List<String> collectionNames = request.getCollectionNames();
        String title = String.format("Flush collections %s", collectionNames);
        if (collectionNames.isEmpty()) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Collection name list can not be null or empty");
        }
        FlushRequest flushRequest = FlushRequest.newBuilder().addAllCollectionNames(collectionNames).build();
        FlushResponse response = blockingStub.flush(flushRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        Map<String, LongArray> rpcCollSegIDs = response.getCollSegIDsMap();
        HashMap<String, List<Long>> collectionSegmentIDs = new HashMap<String, List<Long>>();
        rpcCollSegIDs.forEach((key, value) -> collectionSegmentIDs.put((String)key, value.getDataList()));
        Map<String, Long> collectionFlushTs = response.getCollFlushTsMap();
        return ((FlushResp.FlushRespBuilder)((FlushResp.FlushRespBuilder)((FlushResp.FlushRespBuilder)FlushResp.builder().databaseName(response.getDbName())).collectionSegmentIDs(collectionSegmentIDs)).collectionFlushTs(collectionFlushTs)).build();
    }

    public Void waitFlush(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, FlushResp flushResp) {
        Map<String, List<Long>> collectionSegmentIDs = flushResp.getCollectionSegmentIDs();
        Map<String, Long> collectionFlushTs = flushResp.getCollectionFlushTs();
        collectionSegmentIDs.forEach((collectionName, segmentIDs) -> {
            if (collectionFlushTs.containsKey(collectionName)) {
                Long flushTs = (Long)collectionFlushTs.get(collectionName);
                boolean flushed = false;
                while (!flushed) {
                    GetFlushStateResponse flushResponse = blockingStub.getFlushState(GetFlushStateRequest.newBuilder().setDbName(flushResp.getDatabaseName()).addAllSegmentIDs((Iterable<? extends Long>)segmentIDs).setFlushTs(flushTs).build());
                    flushed = flushResponse.getFlushed();
                }
            }
        });
        return null;
    }

    public CompactResp compact(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CompactReq request) {
        String title = String.format("Compact collection %s", request.getCollectionName());
        DescribeCollectionResponse descResponse = blockingStub.describeCollection(DescribeCollectionRequest.newBuilder().setCollectionName(request.getCollectionName()).build());
        this.rpcUtils.handleResponse(title, descResponse.getStatus());
        ManualCompactionRequest compactRequest = ManualCompactionRequest.newBuilder().setCollectionID(descResponse.getCollectionID()).setMajorCompaction(request.getIsClustering()).build();
        ManualCompactionResponse response = blockingStub.manualCompaction(compactRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((CompactResp.CompactRespBuilder)CompactResp.builder().compactionID(response.getCompactionID())).build();
    }

    public GetCompactionStateResp getCompactionState(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GetCompactionStateReq request) {
        String title = "GetCompactionState";
        GetCompactionStateRequest getRequest = GetCompactionStateRequest.newBuilder().setCompactionID(request.getCompactionID()).build();
        GetCompactionStateResponse response = blockingStub.getCompactionState(getRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((GetCompactionStateResp.GetCompactionStateRespBuilder)((GetCompactionStateResp.GetCompactionStateRespBuilder)((GetCompactionStateResp.GetCompactionStateRespBuilder)((GetCompactionStateResp.GetCompactionStateRespBuilder)GetCompactionStateResp.builder().state(CompactionState.valueOf(response.getState().name()))).executingPlanNo(response.getExecutingPlanNo())).timeoutPlanNo(response.getTimeoutPlanNo())).completedPlanNo(response.getCompletedPlanNo())).build();
    }

    public Void createAlias(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateAliasReq request) {
        String title = String.format("CreateAlias %s for collection %s", request.getAlias(), request.getCollectionName());
        CreateAliasRequest createAliasRequest = CreateAliasRequest.newBuilder().setCollectionName(request.getCollectionName()).setAlias(request.getAlias()).build();
        Status status = blockingStub.createAlias(createAliasRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void dropAlias(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropAliasReq request) {
        String title = String.format("DropAlias %s", request.getAlias());
        DropAliasRequest dropAliasRequest = DropAliasRequest.newBuilder().setAlias(request.getAlias()).build();
        Status status = blockingStub.dropAlias(dropAliasRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void alterAlias(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, AlterAliasReq request) {
        String title = String.format("AlterAlias %s for collection %s", request.getAlias(), request.getCollectionName());
        AlterAliasRequest alterAliasRequest = AlterAliasRequest.newBuilder().setCollectionName(request.getCollectionName()).setAlias(request.getAlias()).build();
        Status status = blockingStub.alterAlias(alterAliasRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public DescribeAliasResp describeAlias(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeAliasReq request) {
        String title = String.format("DescribeAlias %s", request.getAlias());
        DescribeAliasRequest describeAliasRequest = DescribeAliasRequest.newBuilder().setAlias(request.getAlias()).build();
        DescribeAliasResponse response = blockingStub.describeAlias(describeAliasRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((DescribeAliasResp.DescribeAliasRespBuilder)((DescribeAliasResp.DescribeAliasRespBuilder)DescribeAliasResp.builder().collectionName(response.getCollection())).alias(response.getAlias())).build();
    }

    public ListAliasResp listAliases(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, ListAliasesReq request) {
        String title = "ListAliases";
        ListAliasesRequest listAliasesRequest = ListAliasesRequest.newBuilder().setCollectionName(request.getCollectionName()).build();
        ListAliasesResponse response = blockingStub.listAliases(listAliasesRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((ListAliasResp.ListAliasRespBuilder)((ListAliasResp.ListAliasRespBuilder)ListAliasResp.builder().collectionName(response.getCollectionName())).alias((List<String>)response.getAliasesList())).build();
    }

    public CheckHealthResp checkHealth(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        String title = "CheckHealth";
        CheckHealthResponse response = blockingStub.checkHealth(CheckHealthRequest.newBuilder().build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        ArrayList<String> states = new ArrayList<String>();
        response.getQuotaStatesList().forEach(s -> states.add(s.name()));
        return ((CheckHealthResp.CheckHealthRespBuilder)((CheckHealthResp.CheckHealthRespBuilder)((CheckHealthResp.CheckHealthRespBuilder)CheckHealthResp.builder().isHealthy(response.getIsHealthy())).reasons(response.getReasonsList().stream().collect(Collectors.toList()))).quotaStates(states)).build();
    }

    public GetPersistentSegmentInfoResp getPersistentSegmentInfo(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GetPersistentSegmentInfoReq request) {
        String title = String.format("GetPersistentSegmentInfo collectionName %s", request.getCollectionName());
        GetPersistentSegmentInfoResponse response = blockingStub.getPersistentSegmentInfo(GetPersistentSegmentInfoRequest.newBuilder().setCollectionName(request.getCollectionName()).build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        ArrayList<GetPersistentSegmentInfoResp.PersistentSegmentInfo> segmentInfos = new ArrayList<GetPersistentSegmentInfoResp.PersistentSegmentInfo>();
        response.getInfosList().forEach(info -> segmentInfos.add((GetPersistentSegmentInfoResp.PersistentSegmentInfo)((GetPersistentSegmentInfoResp.PersistentSegmentInfo.PersistentSegmentInfoBuilder)((GetPersistentSegmentInfoResp.PersistentSegmentInfo.PersistentSegmentInfoBuilder)((GetPersistentSegmentInfoResp.PersistentSegmentInfo.PersistentSegmentInfoBuilder)((GetPersistentSegmentInfoResp.PersistentSegmentInfo.PersistentSegmentInfoBuilder)((GetPersistentSegmentInfoResp.PersistentSegmentInfo.PersistentSegmentInfoBuilder)((GetPersistentSegmentInfoResp.PersistentSegmentInfo.PersistentSegmentInfoBuilder)((GetPersistentSegmentInfoResp.PersistentSegmentInfo.PersistentSegmentInfoBuilder)GetPersistentSegmentInfoResp.PersistentSegmentInfo.builder().segmentID(info.getSegmentID())).collectionID(info.getCollectionID())).partitionID(info.getPartitionID())).numOfRows(info.getNumRows())).state(info.getState().name())).level(info.getLevel().name())).isSorted(info.getIsSorted())).build()));
        return ((GetPersistentSegmentInfoResp.GetPersistentSegmentInfoRespBuilder)GetPersistentSegmentInfoResp.builder().segmentInfos(segmentInfos)).build();
    }

    public GetQuerySegmentInfoResp getQuerySegmentInfo(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GetQuerySegmentInfoReq request) {
        String title = String.format("GetQuerySegmentInfo collectionName %s", request.getCollectionName());
        GetQuerySegmentInfoResponse response = blockingStub.getQuerySegmentInfo(GetQuerySegmentInfoRequest.newBuilder().setCollectionName(request.getCollectionName()).build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        ArrayList<GetQuerySegmentInfoResp.QuerySegmentInfo> segmentInfos = new ArrayList<GetQuerySegmentInfoResp.QuerySegmentInfo>();
        response.getInfosList().forEach(info -> segmentInfos.add((GetQuerySegmentInfoResp.QuerySegmentInfo)((GetQuerySegmentInfoResp.QuerySegmentInfo.QuerySegmentInfoBuilder)((GetQuerySegmentInfoResp.QuerySegmentInfo.QuerySegmentInfoBuilder)((GetQuerySegmentInfoResp.QuerySegmentInfo.QuerySegmentInfoBuilder)((GetQuerySegmentInfoResp.QuerySegmentInfo.QuerySegmentInfoBuilder)((GetQuerySegmentInfoResp.QuerySegmentInfo.QuerySegmentInfoBuilder)((GetQuerySegmentInfoResp.QuerySegmentInfo.QuerySegmentInfoBuilder)((GetQuerySegmentInfoResp.QuerySegmentInfo.QuerySegmentInfoBuilder)((GetQuerySegmentInfoResp.QuerySegmentInfo.QuerySegmentInfoBuilder)((GetQuerySegmentInfoResp.QuerySegmentInfo.QuerySegmentInfoBuilder)((GetQuerySegmentInfoResp.QuerySegmentInfo.QuerySegmentInfoBuilder)((GetQuerySegmentInfoResp.QuerySegmentInfo.QuerySegmentInfoBuilder)GetQuerySegmentInfoResp.QuerySegmentInfo.builder().segmentID(info.getSegmentID())).collectionID(info.getCollectionID())).partitionID(info.getPartitionID())).memSize(info.getMemSize())).numOfRows(info.getNumRows())).indexName(info.getIndexName())).indexID(info.getIndexID())).state(info.getState().name())).level(info.getLevel().name())).nodeIDs(info.getNodeIdsList())).isSorted(info.getIsSorted())).build()));
        return ((GetQuerySegmentInfoResp.GetQuerySegmentInfoRespBuilder)GetQuerySegmentInfoResp.builder().segmentInfos(segmentInfos)).build();
    }
}

