/*
 * Decompiled with CFR 0.152.
 */
package io.minio.admin;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.bouncycastle.crypto.params.KeyParameter;

public class Crypto {
    private static final byte ARGON2ID_AES_GCM = 0;
    private static final int NONCE_LENGTH = 8;
    private static final int SALT_LENGTH = 32;
    private static final int BUFFER_SIZE = 16384;
    private static final SecureRandom RANDOM = new SecureRandom();

    private static byte[] random(int length) {
        byte[] data = new byte[length];
        RANDOM.nextBytes(data);
        return data;
    }

    private static byte[] generateKey(byte[] password, byte[] salt) {
        byte[] key = new byte[32];
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        Argon2Parameters params = new Argon2Parameters.Builder(2).withVersion(19).withSalt(salt).withMemoryAsKB(65536).withParallelism(4).withIterations(1).build();
        generator.init(params);
        generator.generateBytes(password, key);
        return key;
    }

    private static byte[] generateAdditionalData(byte[] key, byte[] paddedNonce) throws InvalidCipherTextException {
        GCMBlockCipher cipher = new GCMBlockCipher((BlockCipher)new AESEngine());
        cipher.init(true, (CipherParameters)new AEADParameters(new KeyParameter(key), 128, paddedNonce));
        int outputLength = cipher.getMac().length;
        byte[] additionalData = new byte[outputLength];
        cipher.doFinal(additionalData, 0);
        byte[] finalAdditionalData = new byte[outputLength + 1];
        System.arraycopy(additionalData, 0, finalAdditionalData, 1, additionalData.length);
        finalAdditionalData[0] = -128;
        return finalAdditionalData;
    }

    public static byte[] encrypt(String password, byte[] data) throws UnsupportedEncodingException, InvalidCipherTextException {
        Preconditions.checkArgument((data.length <= 16384 ? 1 : 0) != 0, (String)"Cannot encrypt data of length %d that is greater than block size %d, currently only n = 1 blocks (chunks) are supported.", (int)data.length, (int)16384);
        byte[] nonce = Crypto.random(8);
        byte[] paddedNonce = new byte[12];
        System.arraycopy(nonce, 0, paddedNonce, 0, nonce.length);
        byte[] salt = Crypto.random(32);
        byte[] key = Crypto.generateKey(password.getBytes("utf-8"), salt);
        byte[] additionalData = Crypto.generateAdditionalData(key, paddedNonce);
        paddedNonce[8] = 1;
        GCMBlockCipher cipher = new GCMBlockCipher((BlockCipher)new AESEngine());
        cipher.init(true, (CipherParameters)new AEADParameters(new KeyParameter(key), 128, paddedNonce, additionalData));
        int outputLength = cipher.getOutputSize(data.length);
        byte[] encryptedData = new byte[outputLength];
        int outputOffset = cipher.processBytes(data, 0, data.length, encryptedData, 0);
        cipher.doFinal(encryptedData, outputOffset);
        ByteBuffer payload = ByteBuffer.allocate(1 + salt.length + nonce.length + outputLength);
        payload.put(salt);
        payload.put((byte)0);
        payload.put(nonce);
        payload.put(encryptedData);
        return payload.array();
    }

    public static byte[] decrypt(String password, byte[] payload) throws UnsupportedEncodingException, InvalidCipherTextException {
        ByteBuffer payloadBuffer = ByteBuffer.wrap(payload);
        byte[] nonce = new byte[8];
        byte[] salt = new byte[32];
        payloadBuffer.get(salt);
        payloadBuffer.get();
        payloadBuffer.get(nonce);
        byte[] encryptedData = new byte[payloadBuffer.remaining()];
        payloadBuffer.get(encryptedData);
        byte[] key = Crypto.generateKey(password.getBytes("UTF-8"), salt);
        byte[] paddedNonce = new byte[12];
        System.arraycopy(nonce, 0, paddedNonce, 0, nonce.length);
        byte[] additionalData = Crypto.generateAdditionalData(key, paddedNonce);
        paddedNonce[8] = 1;
        GCMBlockCipher cipher = new GCMBlockCipher((BlockCipher)new AESEngine());
        cipher.init(false, (CipherParameters)new AEADParameters(new KeyParameter(key), 128, paddedNonce, additionalData));
        int outputLength = cipher.getOutputSize(encryptedData.length);
        byte[] decryptedData = new byte[outputLength];
        int outputOffset = cipher.processBytes(encryptedData, 0, encryptedData.length, decryptedData, 0);
        cipher.doFinal(decryptedData, outputOffset);
        return ByteBuffer.wrap(decryptedData).array();
    }
}

