/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.c7.elementtemplates.gen;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "name", "event", "scriptFormat", "source", "target", "expression", "variables", "sourceExpression"})
public class Binding {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type of the property binding")
    private Type type;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of binding xml property")
    private String name;
    @JsonProperty(value="event")
    @JsonPropertyDescription(value="The event type of an execution listener binding")
    private String event;
    @JsonProperty(value="scriptFormat")
    @JsonPropertyDescription(value="The format of a script property binding (camunda:outputParameter, camunda:inputParameter)")
    private String scriptFormat;
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="The source value of a property binding (camunda:outputParameter, camunda:out)")
    private String source;
    @JsonProperty(value="target")
    @JsonPropertyDescription(value="The target value to be mapped to (camunda:in)")
    private String target;
    @JsonProperty(value="expression")
    @JsonPropertyDescription(value="True indicates that the control field value is an expression (camunda:in, camunda:field)")
    private Boolean expression;
    @JsonProperty(value="variables")
    @JsonPropertyDescription(value="Either all or local indicating the variable mapping (camunda:in)")
    private Variables variables;
    @JsonProperty(value="sourceExpression")
    @JsonPropertyDescription(value="The string containing the expression for the source attribute (camunda:out)")
    private String sourceExpression;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    public Binding withType(Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Binding withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="event")
    public String getEvent() {
        return this.event;
    }

    @JsonProperty(value="event")
    public void setEvent(String event) {
        this.event = event;
    }

    public Binding withEvent(String event) {
        this.event = event;
        return this;
    }

    @JsonProperty(value="scriptFormat")
    public String getScriptFormat() {
        return this.scriptFormat;
    }

    @JsonProperty(value="scriptFormat")
    public void setScriptFormat(String scriptFormat) {
        this.scriptFormat = scriptFormat;
    }

    public Binding withScriptFormat(String scriptFormat) {
        this.scriptFormat = scriptFormat;
        return this;
    }

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(String source) {
        this.source = source;
    }

    public Binding withSource(String source) {
        this.source = source;
        return this;
    }

    @JsonProperty(value="target")
    public String getTarget() {
        return this.target;
    }

    @JsonProperty(value="target")
    public void setTarget(String target) {
        this.target = target;
    }

    public Binding withTarget(String target) {
        this.target = target;
        return this;
    }

    @JsonProperty(value="expression")
    public Boolean getExpression() {
        return this.expression;
    }

    @JsonProperty(value="expression")
    public void setExpression(Boolean expression) {
        this.expression = expression;
    }

    public Binding withExpression(Boolean expression) {
        this.expression = expression;
        return this;
    }

    @JsonProperty(value="variables")
    public Variables getVariables() {
        return this.variables;
    }

    @JsonProperty(value="variables")
    public void setVariables(Variables variables) {
        this.variables = variables;
    }

    public Binding withVariables(Variables variables) {
        this.variables = variables;
        return this;
    }

    @JsonProperty(value="sourceExpression")
    public String getSourceExpression() {
        return this.sourceExpression;
    }

    @JsonProperty(value="sourceExpression")
    public void setSourceExpression(String sourceExpression) {
        this.sourceExpression = sourceExpression;
    }

    public Binding withSourceExpression(String sourceExpression) {
        this.sourceExpression = sourceExpression;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Binding withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Binding.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("event");
        sb.append('=');
        sb.append(this.event == null ? "<null>" : this.event);
        sb.append(',');
        sb.append("scriptFormat");
        sb.append('=');
        sb.append(this.scriptFormat == null ? "<null>" : this.scriptFormat);
        sb.append(',');
        sb.append("source");
        sb.append('=');
        sb.append(this.source == null ? "<null>" : this.source);
        sb.append(',');
        sb.append("target");
        sb.append('=');
        sb.append(this.target == null ? "<null>" : this.target);
        sb.append(',');
        sb.append("expression");
        sb.append('=');
        sb.append(this.expression == null ? "<null>" : this.expression);
        sb.append(',');
        sb.append("variables");
        sb.append('=');
        sb.append(this.variables == null ? "<null>" : this.variables);
        sb.append(',');
        sb.append("sourceExpression");
        sb.append('=');
        sb.append(this.sourceExpression == null ? "<null>" : this.sourceExpression);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.variables == null ? 0 : this.variables.hashCode());
        result = result * 31 + (this.expression == null ? 0 : this.expression.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.sourceExpression == null ? 0 : this.sourceExpression.hashCode());
        result = result * 31 + (this.source == null ? 0 : this.source.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.event == null ? 0 : this.event.hashCode());
        result = result * 31 + (this.scriptFormat == null ? 0 : this.scriptFormat.hashCode());
        result = result * 31 + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Binding)) {
            return false;
        }
        Binding rhs = (Binding)other;
        return (this.variables == rhs.variables || this.variables != null && this.variables.equals((Object)rhs.variables)) && (this.expression == rhs.expression || this.expression != null && this.expression.equals(rhs.expression)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.sourceExpression == rhs.sourceExpression || this.sourceExpression != null && this.sourceExpression.equals(rhs.sourceExpression)) && (this.source == rhs.source || this.source != null && this.source.equals(rhs.source)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.event == rhs.event || this.event != null && this.event.equals(rhs.event)) && (this.scriptFormat == rhs.scriptFormat || this.scriptFormat != null && this.scriptFormat.equals(rhs.scriptFormat)) && (this.target == rhs.target || this.target != null && this.target.equals(rhs.target));
    }

    public static enum Type {
        PROPERTY("property"),
        CAMUNDA_PROPERTY("camunda:property"),
        CAMUNDA_INPUT_PARAMETER("camunda:inputParameter"),
        CAMUNDA_OUTPUT_PARAMETER("camunda:outputParameter"),
        CAMUNDA_IN("camunda:in"),
        CAMUNDA_OUT("camunda:out"),
        CAMUNDA_IN_BUSINESS_KEY("camunda:in:businessKey"),
        CAMUNDA_EXECUTION_LISTENER("camunda:executionListener"),
        CAMUNDA_FIELD("camunda:field");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Variables {
        ALL("all"),
        LOCAL("local");

        private final String value;
        private static final Map<String, Variables> CONSTANTS;

        private Variables(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Variables fromValue(String value) {
            Variables constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Variables>();
            for (Variables c : Variables.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

