/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.elementtemplate.c7;

import io.miragon.miranum.connect.c7.elementtemplates.gen.Binding;
import io.miragon.miranum.connect.c7.elementtemplates.gen.CamundaC7ElementTemplate;
import io.miragon.miranum.connect.c7.elementtemplates.gen.Constraints;
import io.miragon.miranum.connect.c7.elementtemplates.gen.Property;
import io.miragon.miranum.connect.elementtemplate.api.BPMNElementType;
import io.miragon.miranum.connect.elementtemplate.api.PropertyType;
import io.miragon.miranum.connect.elementtemplate.c7.CamundaC7ElementTemplateConverter;
import io.miragon.miranum.connect.elementtemplate.core.Camunda7Configuration;
import io.miragon.miranum.connect.elementtemplate.core.ElementTemplateGenerationResult;
import io.miragon.miranum.connect.elementtemplate.core.ElementTemplateGenerator;
import io.miragon.miranum.connect.elementtemplate.core.ElementTemplateInfo;
import io.miragon.miranum.connect.elementtemplate.core.ElementTemplatePropertyInfo;
import io.miragon.miranum.connect.elementtemplate.core.InputValueNamingPolicy;
import io.miragon.miranum.connect.elementtemplate.core.TargetPlatform;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Camunda7ElementTemplateGenerator
implements ElementTemplateGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Camunda7ElementTemplateGenerator.class);
    Camunda7Configuration camunda7Configuration;

    public ElementTemplateGenerationResult generate(ElementTemplateInfo elementTemplateInfo, InputValueNamingPolicy inputValueNamingPolicy) {
        Property property;
        CamundaC7ElementTemplate elementTemplate = new CamundaC7ElementTemplate().withName(elementTemplateInfo.getName()).withId(elementTemplateInfo.getId()).withAppliesTo(Collections.singletonList(BPMNElementType.BPMN_SERVICE_TASK.getValue()));
        if (elementTemplateInfo.getVersion() > 0) {
            elementTemplate.setVersion(Double.valueOf(elementTemplateInfo.getVersion()));
        }
        Property implementationProperty = this.createExternalTaskProperty();
        elementTemplate.getProperties().add(implementationProperty);
        Property implementationTopicProperty = this.createExternalTaskTopicProperty(elementTemplateInfo.getType());
        elementTemplate.getProperties().add(implementationTopicProperty);
        Property asyncBeforeProperty = this.createAsyncBeforeProperty();
        elementTemplate.getProperties().add(asyncBeforeProperty);
        Property asyncAfterProperty = this.createAsyncAfterProperty();
        elementTemplate.getProperties().add(asyncAfterProperty);
        for (ElementTemplatePropertyInfo inputProperty : elementTemplateInfo.getInputProperties()) {
            property = this.createInputParameterProp(inputProperty, inputValueNamingPolicy);
            elementTemplate.getProperties().add(property);
        }
        for (ElementTemplatePropertyInfo outputProperties : elementTemplateInfo.getOutputProperties()) {
            property = this.createOutputParameterProp(outputProperties);
            elementTemplate.getProperties().add(property);
        }
        String json = CamundaC7ElementTemplateConverter.toJsonString(elementTemplate);
        return new ElementTemplateGenerationResult(elementTemplateInfo.getId(), elementTemplateInfo.getVersion(), json, TargetPlatform.C7);
    }

    private Property createInputParameterProp(ElementTemplatePropertyInfo info, InputValueNamingPolicy inputValueNamingPolicy) {
        Property property = new Property().withLabel("Input: %s".formatted(info.getLabel()));
        Property property2 = property.withValue(switch (inputValueNamingPolicy) {
            default -> throw new IncompatibleClassChangeError();
            case InputValueNamingPolicy.EMPTY -> "${}";
            case InputValueNamingPolicy.ATTRIBUTE_NAME -> "${%s}".formatted(info.getName());
        }).withType(info.getType().getType()).withChoices(null).withBinding(new Binding().withType(Binding.Type.CAMUNDA_INPUT_PARAMETER).withName(info.getName()));
        if (!info.isNotEmpty()) {
            property2.setConstraints(new Constraints().withNotEmpty(info.isNotEmpty()));
        }
        if (!info.isEditable()) {
            property2.setEditable(info.isEditable());
        }
        return property2;
    }

    private Property createOutputParameterProp(ElementTemplatePropertyInfo info) {
        Property property = new Property().withLabel("Output: %s".formatted(info.getLabel())).withValue(info.getName()).withType(info.getType().getType()).withChoices(null).withBinding(new Binding().withType(Binding.Type.CAMUNDA_OUTPUT_PARAMETER).withSource("${%s}".formatted(info.getName())));
        if (!info.isNotEmpty()) {
            property.setConstraints(new Constraints().withNotEmpty(info.isNotEmpty()));
        }
        if (!info.isEditable()) {
            property.setEditable(info.isEditable());
        }
        return property;
    }

    private Property createExternalTaskProperty() {
        return new Property().withLabel("Implementation Type").withType(PropertyType.STRING.getType()).withValue("external").withEditable(false).withChoices(null).withBinding(new Binding().withType(Binding.Type.PROPERTY).withName("camunda:type"));
    }

    private Property createExternalTaskTopicProperty(String type) {
        return new Property().withLabel("Topic").withType(PropertyType.STRING.getType()).withValue(type).withEditable(false).withChoices(null).withBinding(new Binding().withType(Binding.Type.PROPERTY).withName("camunda:topic"));
    }

    private Property createAsyncBeforeProperty() {
        return new Property().withLabel("Async Before").withType("Boolean").withValue(this.camunda7Configuration.getAsyncBeforeDefaultValue()).withEditable(true).withChoices(null).withBinding(new Binding().withType(Binding.Type.PROPERTY).withName("camunda:asyncBefore"));
    }

    private Property createAsyncAfterProperty() {
        return new Property().withLabel("Async After").withType("Boolean").withValue(this.camunda7Configuration.getAsyncAfterDefaultValue()).withEditable(true).withChoices(null).withBinding(new Binding().withType(Binding.Type.PROPERTY).withName("camunda:asyncAfter"));
    }

    @Generated
    public Camunda7ElementTemplateGenerator(Camunda7Configuration camunda7Configuration) {
        this.camunda7Configuration = camunda7Configuration;
    }
}

