/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.elementtemplate;

import io.miragon.miranum.connect.elementtemplate.Camunda7ConfigImpl;
import io.miragon.miranum.connect.elementtemplate.ElementTemplateGeneratorsFactory;
import io.miragon.miranum.connect.elementtemplate.PlatformSpecificConfig;
import io.miragon.miranum.connect.elementtemplate.core.ElementTemplateGenerationResult;
import io.miragon.miranum.connect.elementtemplate.core.ElementTemplateGenerator;
import io.miragon.miranum.connect.elementtemplate.core.ElementTemplateInfo;
import io.miragon.miranum.connect.elementtemplate.core.ElementTemplateInfoMapper;
import io.miragon.miranum.connect.elementtemplate.core.InputValueNamingPolicy;
import io.miragon.miranum.connect.elementtemplate.core.TargetPlatform;
import io.miragon.miranum.connect.worker.api.Worker;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ElementTemplateGeneratorMojo
extends AbstractMojo {
    private final Log log = this.getLog();
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(name="targetPlatform", property="elementtemplategen.targetPlatform", required=true)
    TargetPlatform targetPlatform;
    @Parameter(property="elementtemplategen.outputDirectory", defaultValue="${project.build.directory/generated-sources/element-templates}")
    File outputDirectory;
    @Parameter(name="inputValueNamingPolicy", property="elementtemplategen.inputValueNamingPolicy", defaultValue="EMPTY")
    InputValueNamingPolicy inputValueNamingPolicy;
    @Parameter(name="clean", property="elementtemplategen.clean", defaultValue="false")
    Boolean clean;
    @Parameter
    PlatformSpecificConfig platformSpecificConfig;

    public void execute() throws MojoExecutionException {
        if (Objects.isNull(this.targetPlatform)) {
            this.getLog().info((CharSequence)"Element-Template generation failed. Please configure a target platform. Valid target platforms are: C7 or C8.");
            return;
        }
        if (Objects.isNull(this.platformSpecificConfig)) {
            this.getLog().info((CharSequence)"Platform specific configuration not provided. Using default configuration.");
            this.platformSpecificConfig = this.createDefaultPlatformSpecificConfig();
        }
        ElementTemplateGenerator generator = ElementTemplateGeneratorsFactory.create(this.targetPlatform, this.platformSpecificConfig);
        Set<Method> annotatedMethods = this.getWorkerAnnotatedMethods();
        if (annotatedMethods.isEmpty()) {
            this.log.info((CharSequence)"No methods annotated with @Worker found.");
            return;
        }
        if (this.clean.booleanValue()) {
            try (Stream<Path> paths = Files.walk(this.outputDirectory.toPath(), new FileVisitOption[0]);){
                paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        this.log.error((CharSequence)("Failed to delete file: " + String.valueOf(file)), (Throwable)e);
                    }
                });
            }
            catch (IOException e) {
                this.log.error((CharSequence)"Failed to clean output directory.", (Throwable)e);
            }
        }
        for (Method method : annotatedMethods) {
            ElementTemplateInfo data = ElementTemplateInfoMapper.map((Method)method);
            ElementTemplateGenerationResult generationResult = generator.generate(data, this.inputValueNamingPolicy);
            this.saveElementTemplateToFile(generationResult);
        }
    }

    private void saveElementTemplateToFile(ElementTemplateGenerationResult generationResult) {
        File elementTemplate = new File(this.outputDirectory, generationResult.getFileName());
        boolean dirsCreated = elementTemplate.getParentFile().mkdirs();
        try {
            boolean fileCreated = elementTemplate.createNewFile();
            Files.writeString(elementTemplate.toPath(), (CharSequence)generationResult.getJson(), new OpenOption[0]);
            this.log.info((CharSequence)("Element template file created: " + elementTemplate.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<Method> getWorkerAnnotatedMethods() throws MojoExecutionException {
        List classpathElements;
        try {
            classpathElements = this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
        ArrayList<URL> classpathURLs = new ArrayList<URL>();
        for (String element : classpathElements) {
            try {
                classpathURLs.add(new File(element).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Malformed classpath element: " + element, (Exception)e);
            }
        }
        URLClassLoader urlClassLoader = new URLClassLoader(classpathURLs.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{urlClassLoader})).addClassLoaders(new ClassLoader[]{urlClassLoader}).addScanners(new Scanner[]{Scanners.MethodsAnnotated}));
        return reflections.getMethodsAnnotatedWith(Worker.class);
    }

    private PlatformSpecificConfig createDefaultPlatformSpecificConfig() {
        PlatformSpecificConfig config = new PlatformSpecificConfig();
        Camunda7ConfigImpl c7Config = new Camunda7ConfigImpl();
        config.setC7(c7Config);
        return config;
    }
}

