/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.elementtemplate;

import io.miragon.miranum.connect.elementtemplate.PlatformSpecificConfig;
import io.miragon.miranum.connect.elementtemplate.c7.Camunda7ElementTemplateGenerator;
import io.miragon.miranum.connect.elementtemplate.c8.Camunda8ElementTemplateGenerator;
import io.miragon.miranum.connect.elementtemplate.core.Camunda7Configuration;
import io.miragon.miranum.connect.elementtemplate.core.ElementTemplateGenerator;
import io.miragon.miranum.connect.elementtemplate.core.TargetPlatform;
import java.util.ArrayList;
import java.util.List;

public class ElementTemplateGeneratorsFactory {
    public static List<ElementTemplateGenerator> create(TargetPlatform[] targetPlatform, PlatformSpecificConfig platformSpecificConfig) {
        ArrayList<ElementTemplateGenerator> generators = new ArrayList<ElementTemplateGenerator>(targetPlatform.length);
        for (TargetPlatform platform : targetPlatform) {
            generators.add(ElementTemplateGeneratorsFactory.create(platform, platformSpecificConfig));
        }
        return generators;
    }

    public static ElementTemplateGenerator create(TargetPlatform targetPlatform, PlatformSpecificConfig platformSpecificConfig) {
        switch (targetPlatform) {
            case C7: {
                return new Camunda7ElementTemplateGenerator((Camunda7Configuration)platformSpecificConfig.getC7());
            }
            case C8: {
                return new Camunda8ElementTemplateGenerator();
            }
        }
        throw new IllegalArgumentException("Unknown target platform: " + String.valueOf(targetPlatform));
    }
}

