/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.adapter.in.c7.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.camunda.bpm.client.interceptor.ClientRequestInterceptor;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class Camunda7oAuthAutoConfiguration {
    @Value(value="${miranum.c7.auth.server.url}")
    private String authServerUrl;
    @Value(value="${miranum.c7.client.id}")
    private String clientId;
    @Value(value="${miranum.c7.client.secret}")
    private String clientSecret;

    @Bean
    public ClientRequestInterceptor interceptor() {
        return context -> context.addHeader("Authorization", this.getAccessToken());
    }

    @Autowired
    public void addOAuthInterceptor(ApiClient apiClient) {
        apiClient.setHttpClient(apiClient.getHttpClient().newBuilder().addInterceptor(this::intercept).build());
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        Request requestWithToken = originalRequest.newBuilder().header("Authorization", this.getAccessToken()).build();
        return chain.proceed(requestWithToken);
    }

    public String getAccessToken() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"client_credentials");
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity response = new RestTemplate().postForEntity(this.authServerUrl, (Object)request, JsonNode.class, new Object[0]);
        return "Bearer " + ((JsonNode)response.getBody()).get("access_token").asText();
    }
}

