/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.adapter.in.c7.process;

import io.miragon.miranum.connect.c7.utils.Camunda7RestValueMapper;
import io.miragon.miranum.connect.process.api.ProcessStartingException;
import io.miragon.miranum.connect.process.api.StartProcessCommand;
import io.miragon.miranum.connect.process.impl.StartProcessPort;
import java.util.Map;
import org.camunda.community.rest.client.api.ProcessDefinitionApi;
import org.camunda.community.rest.client.dto.ProcessInstanceWithVariablesDto;
import org.camunda.community.rest.client.dto.StartProcessInstanceDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Camunda7ProcessAdapter
implements StartProcessPort {
    private static final Logger log = LoggerFactory.getLogger(Camunda7ProcessAdapter.class);
    private final ProcessDefinitionApi processDefinitionApi;
    private final Camunda7RestValueMapper baseVariableMapper;

    public void startProcess(StartProcessCommand startProcessCommand) throws ProcessStartingException {
        try {
            Map variables = this.baseVariableMapper.map(startProcessCommand.getVariables());
            ProcessInstanceWithVariablesDto processInstance = this.processDefinitionApi.startProcessInstanceByKey(startProcessCommand.getProcessKey(), new StartProcessInstanceDto().variables(variables));
            log.info("Started new process instance with id {}", (Object)processInstance.getId());
        }
        catch (Exception e) {
            throw new ProcessStartingException("Failed to create new process instance.", e);
        }
    }

    public Camunda7ProcessAdapter(ProcessDefinitionApi processDefinitionApi, Camunda7RestValueMapper baseVariableMapper) {
        this.processDefinitionApi = processDefinitionApi;
        this.baseVariableMapper = baseVariableMapper;
    }
}

