/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.adapter.in.c8.process;

import io.camunda.zeebe.client.ZeebeClient;
import io.miragon.miranum.connect.process.api.ProcessStartingException;
import io.miragon.miranum.connect.process.api.StartProcessCommand;
import io.miragon.miranum.connect.process.impl.StartProcessPort;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Camunda8ProcessAdapter
implements StartProcessPort {
    private static final Logger log = LoggerFactory.getLogger(Camunda8ProcessAdapter.class);
    private final ZeebeClient zeebeClient;

    public void startProcess(StartProcessCommand startProcessCommand) throws ProcessStartingException {
        this.zeebeClient.newCreateInstanceCommand().bpmnProcessId(startProcessCommand.getProcessKey()).latestVersion().variables(startProcessCommand.getVariables()).send().whenComplete((result, exception) -> {
            if (!Objects.isNull(exception)) {
                throw new ProcessStartingException("Failed to create new process instance.", (Exception)exception);
            }
            log.info("Started new process instance with id {}", (Object)result.getProcessInstanceKey());
        });
    }

    public Camunda8ProcessAdapter(ZeebeClient zeebeClient) {
        this.zeebeClient = zeebeClient;
    }
}

