/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.json.registry.adapter.in;

import com.fasterxml.jackson.databind.JsonNode;
import io.miragon.miranum.connect.json.registry.adapter.in.SchemaCreateDto;
import io.miragon.miranum.connect.json.registry.application.ports.in.ReadSchemaUseCase;
import io.miragon.miranum.connect.json.registry.application.ports.in.SaveSchemaInCommand;
import io.miragon.miranum.connect.json.registry.application.ports.in.SaveSchemaUseCase;
import io.miragon.miranum.connect.json.registry.domain.Schema;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.NoSuchElementException;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@Transactional
@RestController
@RequestMapping(value={"/schema"})
@Tag(name="Schema", description="API to handle schemas")
public class SchemaRestController {
    private final ReadSchemaUseCase readSchemaUseCase;
    private final SaveSchemaUseCase createSchemaUseCase;

    @PostMapping(value={"/{bundle}/{ref}"})
    @Operation(description="create new schema")
    public ResponseEntity<Void> createSchema(@PathVariable String bundle, @PathVariable String ref, @RequestBody @Valid SchemaCreateDto schemaCreateDto) {
        this.createSchemaUseCase.saveSchema(new SaveSchemaInCommand(bundle, ref, schemaCreateDto.getTags(), schemaCreateDto.getJsonNode()));
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{bundle}/{ref}/{tag}"})
    @Operation(description="get latest schema by ref")
    public ResponseEntity<JsonNode> getSchemaByTag(@PathVariable String bundle, @PathVariable String ref, @PathVariable String tag) {
        try {
            Schema schema = this.readSchemaUseCase.loadSchema(bundle, ref, tag);
            return ResponseEntity.ok((Object)schema.getJsonNode());
        }
        catch (NoSuchElementException exception) {
            return ResponseEntity.notFound().build();
        }
    }

    public SchemaRestController(ReadSchemaUseCase readSchemaUseCase, SaveSchemaUseCase createSchemaUseCase) {
        this.readSchemaUseCase = readSchemaUseCase;
        this.createSchemaUseCase = createSchemaUseCase;
    }
}

