/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.json.registry.adapter.in.handler;

import io.miragon.miranum.connect.shared.ObjectNotFoundException;
import jakarta.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class SchemaExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(SchemaExceptionHandler.class);

    @ExceptionHandler(value={ObjectNotFoundException.class})
    public ResponseEntity<String> handleOperationNotAllowed(ObjectNotFoundException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)exception.getMessage());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<String> handleConstraintViolationException(ConstraintViolationException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)exception.getMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<String> handleInternalServerError(RuntimeException exception) {
        log.error("Internal server error:", (Throwable)exception);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Internal server error");
    }
}

