/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.json.registry.adapter.out;

import io.miragon.miranum.connect.json.registry.adapter.out.SchemaEntity;
import io.miragon.miranum.connect.json.registry.adapter.out.SchemaEntityMapper;
import io.miragon.miranum.connect.json.registry.adapter.out.SchemaRepository;
import io.miragon.miranum.connect.json.registry.application.ports.out.LoadSchemaPort;
import io.miragon.miranum.connect.json.registry.application.ports.out.SaveSchemaPort;
import io.miragon.miranum.connect.json.registry.domain.Schema;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Repository;

@Repository
public class SchemaPersistenceAdapter
implements SaveSchemaPort,
LoadSchemaPort {
    private final SchemaRepository schemaRepository;
    private final SchemaEntityMapper schemaEntityMapper;

    @Override
    public List<Schema> loadAllSchemaByRefAndBundle(String bundle, String ref) {
        return this.schemaRepository.findAllByBundleAndRef(bundle, ref).stream().map(this.schemaEntityMapper::map).toList();
    }

    @Override
    public Optional<Schema> loadTaggedSchema(String bundle, String ref, String tag) {
        Optional<SchemaEntity> entity = this.schemaRepository.findByBundleAndRefAndTag(bundle, ref, tag);
        return entity.map(this.schemaEntityMapper::map);
    }

    @Override
    public List<Schema> saveAllSchemas(List<@Valid Schema> schemasToSave) {
        return this.schemaRepository.saveAll(schemasToSave.stream().map(this.schemaEntityMapper::map).toList()).stream().map(this.schemaEntityMapper::map).toList();
    }

    public SchemaPersistenceAdapter(SchemaRepository schemaRepository, SchemaEntityMapper schemaEntityMapper) {
        this.schemaRepository = schemaRepository;
        this.schemaEntityMapper = schemaEntityMapper;
    }
}

