/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.json.registry.application.service;

import io.miragon.miranum.connect.json.registry.application.ports.in.ReadSchemaUseCase;
import io.miragon.miranum.connect.json.registry.application.ports.in.SaveSchemaInCommand;
import io.miragon.miranum.connect.json.registry.application.ports.in.SaveSchemaUseCase;
import io.miragon.miranum.connect.json.registry.application.ports.out.LoadSchemaPort;
import io.miragon.miranum.connect.json.registry.application.ports.out.SaveSchemaPort;
import io.miragon.miranum.connect.json.registry.domain.Schema;
import io.miragon.miranum.connect.shared.ObjectNotFoundException;
import jakarta.transaction.Transactional;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SchemaService
implements SaveSchemaUseCase,
ReadSchemaUseCase {
    private final SaveSchemaPort saveSchemaPort;
    private final LoadSchemaPort loadSchemaPort;

    @Override
    @Transactional
    public List<Schema> saveSchema(SaveSchemaInCommand saveSchemaInCommand) {
        List<Schema> existingSchemas = this.loadSchemaPort.loadAllSchemaByRefAndBundle(saveSchemaInCommand.getBundle(), saveSchemaInCommand.getRef());
        List<Schema> schemasToCreate = saveSchemaInCommand.getTags().stream().map(tag -> this.mapToSchema(existingSchemas, saveSchemaInCommand, tag.trim().toLowerCase())).toList();
        return this.saveSchemaPort.saveAllSchemas(schemasToCreate);
    }

    @Override
    public Schema loadSchema(String bundle, String ref, String tag) {
        return this.loadSchemaPort.loadTaggedSchema(bundle, ref, tag).orElseThrow(() -> new ObjectNotFoundException(String.format("No schema found for bundle %s, ref %s and tag %s", bundle, ref, tag)));
    }

    private Schema mapToSchema(List<Schema> existingSchemasByRefAndBundle, SaveSchemaInCommand saveSchemaInCommand, String tag) {
        return existingSchemasByRefAndBundle.stream().filter(schema -> schema.getTag().equals(tag)).findFirst().map(existing -> new Schema((Schema)existing, saveSchemaInCommand.getJsonNode())).orElse(new Schema(saveSchemaInCommand.getBundle(), saveSchemaInCommand.getRef(), tag, saveSchemaInCommand.getJsonNode()));
    }

    public SchemaService(SaveSchemaPort saveSchemaPort, LoadSchemaPort loadSchemaPort) {
        this.saveSchemaPort = saveSchemaPort;
        this.loadSchemaPort = loadSchemaPort;
    }
}

