/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.json.registry.domain;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.UUID;

public class Schema {
    @NotNull
    @Size(min=36, max=36)
    private final @NotNull @Size(min=36, max=36) String id;
    @NotNull
    @Size(min=1, max=255)
    private final @NotNull @Size(min=1, max=255) String bundle;
    @NotNull
    @Size(min=1, max=255)
    private final @NotNull @Size(min=1, max=255) String ref;
    @NotNull
    @Size(min=1, max=255)
    private final @NotNull @Size(min=1, max=255) String tag;
    @NotNull
    private final JsonNode jsonNode;

    public Schema(String bundle, String ref, String tag, JsonNode jsonNode) {
        this(UUID.randomUUID().toString(), bundle, ref, tag, jsonNode);
    }

    public Schema(Schema latestSchema, JsonNode jsonNode) {
        this.id = latestSchema.getId();
        this.bundle = latestSchema.getBundle();
        this.ref = latestSchema.getRef();
        this.tag = latestSchema.getTag();
        this.jsonNode = jsonNode;
    }

    public Schema(String id, String bundle, String ref, String tag, JsonNode jsonNode) {
        this.id = id;
        this.bundle = bundle;
        this.ref = ref;
        this.tag = tag;
        this.jsonNode = jsonNode;
    }

    public String getId() {
        return this.id;
    }

    public String getBundle() {
        return this.bundle;
    }

    public String getRef() {
        return this.ref;
    }

    public String getTag() {
        return this.tag;
    }

    public JsonNode getJsonNode() {
        return this.jsonNode;
    }
}

