/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.adapter.in.c7.worker;

import io.miragon.miranum.connect.c7.utils.Camunda7PojoMapper;
import io.miragon.miranum.connect.worker.api.BusinessException;
import io.miragon.miranum.connect.worker.api.TechnicalException;
import io.miragon.miranum.connect.worker.api.WorkerExecuteApi;
import io.miragon.miranum.connect.worker.api.WorkerSubscription;
import io.miragon.miranum.connect.worker.impl.WorkerExecutor;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.camunda.bpm.client.ExternalTaskClient;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskService;

public class Camunda7WorkerAdapter
implements WorkerSubscription {
    private static final Logger log = Logger.getLogger(Camunda7WorkerAdapter.class.getName());
    private final ExternalTaskClient externalTaskClient;
    private final WorkerExecuteApi workerExecuteApi;
    private final Camunda7PojoMapper camunda7PojoMapper;

    public void subscribe(WorkerExecutor executor) {
        this.externalTaskClient.subscribe(executor.getType()).lockDuration(executor.getTimeout().longValue()).handler((externalTask, externalTaskService) -> this.execute(executor, externalTask, externalTaskService)).open();
    }

    public void execute(WorkerExecutor executor, ExternalTask externalTask, ExternalTaskService service) {
        try {
            Map data = this.camunda7PojoMapper.mapFromEngineData(externalTask.getAllVariablesTyped());
            Map result = this.workerExecuteApi.execute(executor, (Object)data);
            service.complete(externalTask, null, (Map)this.camunda7PojoMapper.mapToEngineData(result));
        }
        catch (BusinessException exception) {
            log.severe("use case could not be executed " + exception.getMessage());
            service.handleBpmnError(externalTask, exception.getCode());
        }
        catch (TechnicalException error) {
            log.severe("Technical error while executing task " + error.getMessage());
            service.handleFailure(externalTask, error.getMessage(), Arrays.toString(error.getStackTrace()), 0, 0L);
        }
        catch (Exception error) {
            log.severe("Error while executing external task " + error.getMessage());
            int retries = Objects.isNull(externalTask.getRetries()) ? 1 : externalTask.getRetries();
            service.handleFailure(externalTask, error.getMessage(), Arrays.toString(error.getStackTrace()), retries - 1, 5000L);
        }
    }

    public Camunda7WorkerAdapter(ExternalTaskClient externalTaskClient, WorkerExecuteApi workerExecuteApi, Camunda7PojoMapper camunda7PojoMapper) {
        this.externalTaskClient = externalTaskClient;
        this.workerExecuteApi = workerExecuteApi;
        this.camunda7PojoMapper = camunda7PojoMapper;
    }
}

