/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.adapter.in.c8.worker;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.miragon.miranum.connect.worker.api.BusinessException;
import io.miragon.miranum.connect.worker.api.TechnicalException;
import io.miragon.miranum.connect.worker.api.WorkerExecuteApi;
import io.miragon.miranum.connect.worker.api.WorkerSubscription;
import io.miragon.miranum.connect.worker.impl.WorkerExecutor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Camunda8WorkerAdapter
implements WorkerSubscription {
    private static final Logger log = LoggerFactory.getLogger(Camunda8WorkerAdapter.class);
    private final ZeebeClient client;
    private final WorkerExecuteApi workerExecuteApi;

    public void subscribe(WorkerExecutor executor) {
        this.client.newWorker().jobType(executor.getType()).handler((client, job) -> this.execute(client, job, executor)).name(executor.getType()).timeout(executor.getTimeout().longValue()).open();
    }

    public void execute(JobClient client, ActivatedJob job, WorkerExecutor workerExecutor) {
        try {
            Map result = this.workerExecuteApi.execute(workerExecutor, job.getVariablesAsType(workerExecutor.getInputType()));
            CompleteJobCommandStep1 cmd = client.newCompleteCommand(job.getKey());
            cmd.variables(result);
            cmd.send().join();
        }
        catch (BusinessException exception) {
            log.error("business error detected", (Throwable)exception);
            client.newThrowErrorCommand(job.getKey()).errorCode(exception.getCode()).send().join();
        }
        catch (TechnicalException exception) {
            log.error("technical error detected", (Throwable)exception);
            client.newFailCommand(job.getKey()).retries(0).send().join();
        }
        catch (Exception exception) {
            log.error("general exception detected", (Throwable)exception);
            client.newFailCommand(job.getKey()).retries(job.getRetries() - 1).send().join();
        }
    }

    public Camunda8WorkerAdapter(ZeebeClient client, WorkerExecuteApi workerExecuteApi) {
        this.client = client;
        this.workerExecuteApi = workerExecuteApi;
    }
}

