/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.worker.impl;

import io.miragon.miranum.connect.worker.api.Worker;
import io.miragon.miranum.connect.worker.api.WorkerRegistry;
import io.miragon.miranum.connect.worker.impl.WorkerExecutor;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import lombok.NonNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class WorkerAnnotationBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = Logger.getLogger(WorkerAnnotationBeanPostProcessor.class.getName());
    private final WorkerRegistry workerRegistry;

    public Object postProcessBeforeInitialization(Object bean, @NonNull String beanName) throws BeansException {
        if (beanName == null) {
            throw new NullPointerException("beanName is marked non-null but is null");
        }
        ReflectionUtils.doWithMethods(bean.getClass(), method -> {
            if (method.isAnnotationPresent(Worker.class)) {
                Worker annotInstance = method.getAnnotation(Worker.class);
                this.workerRegistry.register(this.buildWorker(annotInstance, bean, method));
            }
        });
        return bean;
    }

    private WorkerExecutor buildWorker(Worker worker, Object bean, Method method) {
        Class<?>[] inputParameterTypes = method.getParameterTypes();
        if (inputParameterTypes.length > 1) {
            throw new IllegalArgumentException("Too many parameters");
        }
        Class<?> inputParameter = inputParameterTypes.length == 0 ? null : inputParameterTypes[0];
        return new WorkerExecutor(worker.type(), worker.timeout(), bean, method, inputParameter, method.getReturnType());
    }

    public WorkerAnnotationBeanPostProcessor(WorkerRegistry workerRegistry) {
        this.workerRegistry = workerRegistry;
    }
}

