/*
 * Decompiled with CFR 0.152.
 */
package io.miragon.miranum.connect.worker.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.miragon.miranum.connect.worker.api.WorkerExecuteApi;
import io.miragon.miranum.connect.worker.api.WorkerInterceptor;
import io.miragon.miranum.connect.worker.impl.WorkerExecutor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkerExecuteApiImpl
implements WorkerExecuteApi {
    private final List<WorkerInterceptor> interceptors;

    @Override
    public Map<String, Object> execute(WorkerExecutor executor, Object data) {
        try {
            Object in = this.mapInput(executor.getInputType(), data);
            this.interceptors.forEach(obj -> obj.intercept(executor, in));
            return this.mapOutput(executor.execute(in));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getTargetException();
        }
    }

    private Object mapInput(Class<?> inputType, Object object) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper.convertValue(object, inputType);
    }

    private Map<String, Object> mapOutput(Object output) {
        if (Objects.isNull(output)) {
            return new HashMap<String, Object>();
        }
        ObjectMapper mapper = new ObjectMapper();
        return (Map)mapper.convertValue(output, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public WorkerExecuteApiImpl(List<WorkerInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

