/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.android.advice;

import io.mockk.core.ValueClassSupport;
import io.mockk.proxy.MockKAgentException;
import io.mockk.proxy.MockKInvocationHandler;
import io.mockk.proxy.android.AndroidMockKMap;
import io.mockk.proxy.android.MethodDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0003\u001b\u001c\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\rJ1\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\n2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J1\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\r2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u0001J\f\u0010\u001a\u001a\u00020\u0018*\u00020\u0001H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/mockk/proxy/android/advice/Advice;", "", "handlers", "Lio/mockk/proxy/android/AndroidMockKMap;", "staticHandlers", "constructorHandlers", "(Lio/mockk/proxy/android/AndroidMockKMap;Lio/mockk/proxy/android/AndroidMockKMap;Lio/mockk/proxy/android/AndroidMockKMap;)V", "selfCallInfo", "Lio/mockk/proxy/android/advice/Advice$SelfCallInfo;", "getOrigin", "Ljava/lang/reflect/Method;", "instance", "methodWithTypeAndSignature", "", "handle", "Ljava/util/concurrent/Callable;", "origin", "arguments", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/util/concurrent/Callable;", "handleConstructor", "methodDescriptor", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/concurrent/Callable;", "isInternalHashMap", "", "isMock", "checkSelfCall", "Companion", "SelfCallInfo", "SuperMethodCall", "mockk-agent-android_release"})
public final class Advice {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidMockKMap handlers;
    @NotNull
    private final AndroidMockKMap staticHandlers;
    @NotNull
    private final AndroidMockKMap constructorHandlers;
    @NotNull
    private final SelfCallInfo selfCallInfo;

    public Advice(@NotNull AndroidMockKMap handlers, @NotNull AndroidMockKMap staticHandlers, @NotNull AndroidMockKMap constructorHandlers) {
        Intrinsics.checkNotNullParameter((Object)handlers, (String)"handlers");
        Intrinsics.checkNotNullParameter((Object)staticHandlers, (String)"staticHandlers");
        Intrinsics.checkNotNullParameter((Object)constructorHandlers, (String)"constructorHandlers");
        this.handlers = handlers;
        this.staticHandlers = staticHandlers;
        this.constructorHandlers = constructorHandlers;
        this.selfCallInfo = new SelfCallInfo();
    }

    @Nullable
    public final Method getOrigin(@Nullable Object instance, @NotNull String methodWithTypeAndSignature) {
        Class<?> obj;
        Intrinsics.checkNotNullParameter((Object)methodWithTypeAndSignature, (String)"methodWithTypeAndSignature");
        MethodDescriptor methodDesc = new MethodDescriptor(methodWithTypeAndSignature);
        Class<?> clazz = instance;
        if (clazz == null) {
            clazz = MethodDescriptor.Companion.classForTypeName(methodDesc.getClassName());
        }
        if (!this.checkSelfCall(obj = clazz)) {
            return null;
        }
        if (instance != null && Advice.Companion.isOverridden(instance.getClass(), methodDesc.getMethod())) {
            return null;
        }
        return methodDesc.getMethod();
    }

    @Nullable
    public final Callable<?> handle(@NotNull Object instance, @NotNull Method origin, @NotNull Object[] arguments) {
        MockKInvocationHandler mockKInvocationHandler;
        Class<?> instanceOrClass;
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (this.isInternalHashMap(instance)) {
            return null;
        }
        if (Modifier.isStatic(origin.getModifiers())) {
            MethodDescriptor methodDesc = new MethodDescriptor((String)((Object)instance));
            clazz = MethodDescriptor.Companion.classForTypeName(methodDesc.getClassName());
        } else {
            clazz = instanceOrClass = instance;
        }
        if ((mockKInvocationHandler = (MockKInvocationHandler)this.handlers.get(instanceOrClass)) == null && (mockKInvocationHandler = (MockKInvocationHandler)this.staticHandlers.get(instanceOrClass)) == null && (mockKInvocationHandler = (MockKInvocationHandler)this.constructorHandlers.get(instanceOrClass)) == null) {
            return null;
        }
        MockKInvocationHandler handler = mockKInvocationHandler;
        SuperMethodCall superMethodCall = new SuperMethodCall(this.selfCallInfo, origin, instanceOrClass, arguments);
        return () -> Advice.handle$lambda$0(handler, instanceOrClass, origin, superMethodCall, arguments);
    }

    private final boolean isInternalHashMap(Object instance) {
        return this.handlers.isInternalHashMap(instance) || this.staticHandlers.isInternalHashMap(instance) || this.constructorHandlers.isInternalHashMap(instance);
    }

    @Nullable
    public final Callable<?> handleConstructor(@NotNull Object instance, @NotNull String methodDescriptor, @NotNull Object[] arguments) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)methodDescriptor, (String)"methodDescriptor");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        MethodDescriptor methodDesc = new MethodDescriptor(methodDescriptor);
        Class<?> cls = MethodDescriptor.Companion.classForTypeName(methodDesc.getClassName());
        MockKInvocationHandler mockKInvocationHandler = (MockKInvocationHandler)this.constructorHandlers.get(cls);
        if (mockKInvocationHandler == null) {
            return null;
        }
        MockKInvocationHandler handler = mockKInvocationHandler;
        return () -> Advice.handleConstructor$lambda$1(handler, instance, arguments);
    }

    public final boolean isMock(@NotNull Object instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        if (this.isInternalHashMap(instance)) {
            return false;
        }
        return this.handlers.containsKey(instance) || this.staticHandlers.containsKey(instance) || this.constructorHandlers.containsKey(instance);
    }

    private final boolean checkSelfCall(Object $this$checkSelfCall) {
        return this.selfCallInfo.checkSelfCall($this$checkSelfCall);
    }

    private static final Object handle$lambda$0(MockKInvocationHandler $handler, Object $instanceOrClass, Method $origin, SuperMethodCall $superMethodCall, Object[] $arguments) {
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        Intrinsics.checkNotNullParameter((Object)$instanceOrClass, (String)"$instanceOrClass");
        Intrinsics.checkNotNullParameter((Object)$origin, (String)"$origin");
        Intrinsics.checkNotNullParameter((Object)$superMethodCall, (String)"$superMethodCall");
        Intrinsics.checkNotNullParameter((Object)$arguments, (String)"$arguments");
        Object object = $handler.invocation($instanceOrClass, $origin, (Callable)$superMethodCall, $arguments);
        return object != null ? ValueClassSupport.INSTANCE.getBoxedValue(object) : null;
    }

    private static final Object handleConstructor$lambda$1(MockKInvocationHandler $handler, Object $instance, Object[] $arguments) {
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        Intrinsics.checkNotNullParameter((Object)$instance, (String)"$instance");
        Intrinsics.checkNotNullParameter((Object)$arguments, (String)"$arguments");
        return $handler.invocation($instance, null, null, $arguments);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\n\u001a\u0004\u0018\u00010\b*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0010\u001a\u00020\u0004*\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\bH\u0082\u0010J\f\u0010\u0012\u001a\u00020\u0013*\u00020\bH\u0002J,\u0010\u0014\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u000eH\u0082\u0004\u00a2\u0006\u0002\u0010\u0017R\u001c\u0010\u0003\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\u00a8\u0006\u0018"}, d2={"Lio/mockk/proxy/android/advice/Advice$Companion;", "", "()V", "final", "", "Ljava/lang/Class;", "getFinal", "(Ljava/lang/Class;)Z", "Ljava/lang/reflect/Method;", "(Ljava/lang/reflect/Method;)Z", "findMethod", "name", "", "parameters", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "isOverridden", "origin", "makeAccessible", "", "refEquals", "T", "other", "([Ljava/lang/Object;[Ljava/lang/Object;)Z", "mockk-agent-android_release"})
    @SourceDebugExtension(value={"SMAP\nAdvice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Advice.kt\nio/mockk/proxy/android/advice/Advice$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1282#2,2:187\n2624#3,3:189\n*S KotlinDebug\n*F\n+ 1 Advice.kt\nio/mockk/proxy/android/advice/Advice$Companion\n*L\n165#1:187,2\n171#1:189,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isOverridden(Class<?> $this$isOverridden, Method origin) {
            Method method;
            while (true) {
                if ($this$isOverridden == null) {
                    return false;
                }
                String string = origin.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"origin.name");
                Class<?>[] classArray = origin.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"origin.parameterTypes");
                method = this_.findMethod($this$isOverridden, string, classArray);
                if (method != null) break;
                Companion companion = this_;
                Class<?> clazz = $this$isOverridden.getSuperclass();
                Method method2 = origin;
                Companion this_ = companion;
                $this$isOverridden = clazz;
                origin = method2;
            }
            Method method3 = method;
            return origin.getDeclaringClass() != method3.getDeclaringClass();
        }

        /*
         * Unable to fully structure code
         */
        private final Method findMethod(Class<?> $this$findMethod, String name, Class<?>[] parameters) {
            block3: {
                v0 = $this$findMethod.getDeclaredMethods();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"declaredMethods");
                $this$firstOrNull$iv = v0;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (Method)element$iv;
                    $i$a$-firstOrNull-Advice$Companion$findMethod$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) ** GOTO lbl-1000
                    v1 = it.getParameterTypes();
                    Intrinsics.checkNotNullExpressionValue(v1, (String)"it.parameterTypes");
                    if (Advice.Companion.refEquals((Object[])v1, parameters)) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (!v2) continue;
                    v3 = element$iv;
                    break block3;
                }
                v3 = null;
            }
            return (Method)v3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final <T> boolean refEquals(T[] $this$refEquals, T[] other) {
            boolean bl;
            if ($this$refEquals.length != other.length) return false;
            Iterable $this$none$iv = ArraysKt.zip((Object[])$this$refEquals, (Object[])other);
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$none$iv.iterator();
            do {
                Object b;
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                Object a = pair.component1();
                if (a != (b = pair.component2())) {
                    return false;
                }
                bl = false;
            } while (!bl);
            return false;
        }

        private final boolean getFinal(Class<?> $this$final) {
            return Modifier.isFinal($this$final.getModifiers());
        }

        private final boolean getFinal(Method $this$final) {
            return Modifier.isFinal($this$final.getModifiers());
        }

        private final void makeAccessible(Method $this$makeAccessible) {
            if (!Modifier.isPublic($this$makeAccessible.getDeclaringClass().getModifiers() & $this$makeAccessible.getModifiers())) {
                $this$makeAccessible.setAccessible(true);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002\u00a8\u0006\u0007"}, d2={"Lio/mockk/proxy/android/advice/Advice$SelfCallInfo;", "Ljava/lang/ThreadLocal;", "", "()V", "checkSelfCall", "", "value", "mockk-agent-android_release"})
    private static final class SelfCallInfo
    extends ThreadLocal<Object> {
        public final boolean checkSelfCall(@NotNull Object value) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (this.get() == value) {
                this.set(null);
                bl = false;
            } else {
                bl = true;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016R\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/mockk/proxy/android/advice/Advice$SuperMethodCall;", "Ljava/util/concurrent/Callable;", "", "selfCallInfo", "Lio/mockk/proxy/android/advice/Advice$SelfCallInfo;", "origin", "Ljava/lang/reflect/Method;", "instance", "arguments", "", "(Lio/mockk/proxy/android/advice/Advice$SelfCallInfo;Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)V", "[Ljava/lang/Object;", "call", "mockk-agent-android_release"})
    private static final class SuperMethodCall
    implements Callable<Object> {
        @NotNull
        private final SelfCallInfo selfCallInfo;
        @NotNull
        private final Method origin;
        @NotNull
        private final Object instance;
        @NotNull
        private final Object[] arguments;

        public SuperMethodCall(@NotNull SelfCallInfo selfCallInfo, @NotNull Method origin, @NotNull Object instance, @NotNull Object[] arguments) {
            Intrinsics.checkNotNullParameter((Object)selfCallInfo, (String)"selfCallInfo");
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            this.selfCallInfo = selfCallInfo;
            this.origin = origin;
            this.instance = instance;
            this.arguments = arguments;
        }

        @Override
        @Nullable
        public Object call() {
            Object object;
            try {
                Companion.makeAccessible(this.origin);
                this.selfCallInfo.set(this.instance);
                object = this.arguments;
                object = this.origin.invoke(this.instance, Arrays.copyOf(object, ((Object[])object).length));
            }
            catch (InvocationTargetException exception) {
                Throwable throwable = exception.getCause();
                throw throwable == null ? (Throwable)new MockKAgentException("no cause for InvocationTargetException", (Throwable)exception) : throwable;
            }
            return object;
        }
    }
}

