/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm.advice.jvm;

import io.mockk.proxy.jvm.advice.BaseAdvice;
import io.mockk.proxy.jvm.advice.ProxyAdviceId;
import io.mockk.proxy.jvm.advice.jvm.MockHandlerMap;
import io.mockk.proxy.jvm.dispatcher.JvmMockKDispatcher;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.Callable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;

public class JvmMockKProxyAdvice
extends BaseAdvice {
    public JvmMockKProxyAdvice(MockHandlerMap handlers) {
        super(handlers);
    }

    @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
    private static Callable<?> enter(@ProxyAdviceId long id, @Advice.This Object self, @Advice.Origin Method method, @Advice.AllArguments Object[] arguments) throws Throwable {
        JvmMockKDispatcher dispatcher;
        if (self.getClass() == HashMap.class) {
            if (arguments.length == 1 && arguments[0] == HashMap.class) {
                return null;
            }
            if (arguments.length == 2 && arguments[1] == HashMap.class) {
                return null;
            }
        }
        if ((dispatcher = JvmMockKDispatcher.get((long)id, (Object)self)) == null || !dispatcher.isMock(self)) {
            return null;
        }
        return dispatcher.handler(self, method, arguments);
    }

    @Advice.OnMethodExit
    private static void exit(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Object returned, @Advice.This Object self, @Advice.Origin Method method, @Advice.Enter Callable<?> mocked) throws Throwable {
        if (mocked != null) {
            returned = mocked.call();
        }
    }
}

