/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm.advice;

import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0016\u0010\u0015\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0016"}, d2={"Lio/mockk/proxy/jvm/advice/SelfCallEliminator;", "", "()V", "selfCall", "Ljava/lang/ThreadLocal;", "getSelfCall", "()Ljava/lang/ThreadLocal;", "selfCallMethod", "Ljava/lang/reflect/Method;", "getSelfCallMethod", "apply", "T", "self", "method", "block", "Lkotlin/Function0;", "(Ljava/lang/Object;Ljava/lang/reflect/Method;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "checkOverride", "", "method1", "method2", "isSelf", "mockk-agent-jvm"})
public final class SelfCallEliminator {
    @NotNull
    public static final SelfCallEliminator INSTANCE = new SelfCallEliminator();
    @NotNull
    private static final ThreadLocal<Object> selfCall = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<Method> selfCallMethod = new ThreadLocal();

    private SelfCallEliminator() {
    }

    @NotNull
    public final ThreadLocal<Object> getSelfCall() {
        return selfCall;
    }

    @NotNull
    public final ThreadLocal<Method> getSelfCallMethod() {
        return selfCallMethod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSelf(@NotNull Object self, @NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (selfCall.get() != self) return false;
        Method method2 = selfCallMethod.get();
        Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"selfCallMethod.get()");
        if (!this.checkOverride(method2, method)) return false;
        return true;
    }

    private final boolean checkOverride(Method method1, Method method2) {
        return Intrinsics.areEqual((Object)method1.getName(), (Object)method2.getName()) && Arrays.equals(method1.getParameterTypes(), method2.getParameterTypes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T apply(@NotNull Object self, @NotNull Method method, @NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$apply = false;
        Object prevSelf = this.getSelfCall().get();
        Method prevMethod = this.getSelfCallMethod().get();
        this.getSelfCall().set(self);
        this.getSelfCallMethod().set(method);
        try {
            object = block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.getSelfCall().set(prevSelf);
            this.getSelfCallMethod().set(prevMethod);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }
}

