/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm;

import io.mockk.proxy.Cancelable;
import io.mockk.proxy.MockKAgentException;
import io.mockk.proxy.MockKAgentLogger;
import io.mockk.proxy.MockKInvocationHandler;
import io.mockk.proxy.MockKStaticProxyMaker;
import io.mockk.proxy.common.CancelableResult;
import io.mockk.proxy.common.transformation.InlineInstrumentation;
import io.mockk.proxy.common.transformation.TransformationRequest;
import io.mockk.proxy.common.transformation.TransformationType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000f\u001a\u00020\tH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/mockk/proxy/jvm/StaticProxyMaker;", "Lio/mockk/proxy/MockKStaticProxyMaker;", "log", "Lio/mockk/proxy/MockKAgentLogger;", "inliner", "Lio/mockk/proxy/common/transformation/InlineInstrumentation;", "staticHandlers", "", "", "Lio/mockk/proxy/MockKInvocationHandler;", "(Lio/mockk/proxy/MockKAgentLogger;Lio/mockk/proxy/common/transformation/InlineInstrumentation;Ljava/util/Map;)V", "staticProxy", "Lio/mockk/proxy/Cancelable;", "Ljava/lang/Class;", "clazz", "handler", "mockk-agent"})
public final class StaticProxyMaker
implements MockKStaticProxyMaker {
    @NotNull
    private final MockKAgentLogger log;
    @Nullable
    private final InlineInstrumentation inliner;
    @NotNull
    private final Map<Object, MockKInvocationHandler> staticHandlers;

    public StaticProxyMaker(@NotNull MockKAgentLogger log, @Nullable InlineInstrumentation inliner, @NotNull Map<Object, MockKInvocationHandler> staticHandlers) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(staticHandlers, (String)"staticHandlers");
        this.log = log;
        this.inliner = inliner;
        this.staticHandlers = staticHandlers;
    }

    @NotNull
    public Cancelable<Class<?>> staticProxy(@NotNull Class<?> clazz, @NotNull MockKInvocationHandler handler) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (this.inliner == null) {
            throw new MockKAgentException("Failed to create static proxy for " + clazz + ".\nTry running VM with MockK Java Agent\ni.e. with -javaagent:mockk-agent.jar option.");
        }
        this.log.debug("Transforming " + clazz + " for static method interception");
        TransformationRequest request = new TransformationRequest(SetsKt.setOf(clazz), TransformationType.STATIC, false, 4, null);
        Function0 cancellation = this.inliner.execute(request);
        this.staticHandlers.put(clazz, handler);
        return (Cancelable)new CancelableResult(clazz, cancellation).alsoOnCancel((Function0)new Function0<Unit>(this, clazz){
            final /* synthetic */ StaticProxyMaker this$0;
            final /* synthetic */ Class<?> $clazz;
            {
                this.this$0 = $receiver;
                this.$clazz = $clazz;
                super(0);
            }

            public final void invoke() {
                StaticProxyMaker.access$getStaticHandlers$p(this.this$0).remove(this.$clazz);
            }
        });
    }

    public static final /* synthetic */ Map access$getStaticHandlers$p(StaticProxyMaker $this) {
        return $this.staticHandlers;
    }
}

