/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm.dispatcher;

import io.mockk.proxy.MockKAgentLogger;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\f0\fH\u0002J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\r\u0010\u0012\u001a\u00020\u0013*\u00020\u0013H\u0082\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/mockk/proxy/jvm/dispatcher/BootJarLoader;", "", "log", "Lio/mockk/proxy/MockKAgentLogger;", "(Lio/mockk/proxy/MockKAgentLogger;)V", "addClass", "", "out", "Ljava/util/jar/JarOutputStream;", "source", "", "buildBootJar", "Ljava/io/File;", "createTempBootFile", "kotlin.jvm.PlatformType", "loadBootJar", "instrumentation", "Ljava/lang/instrument/Instrumentation;", "root", "Ljava/lang/ClassLoader;", "Companion", "mockk-agent"})
@SourceDebugExtension(value={"SMAP\nBootJarLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BootJarLoader.kt\nio/mockk/proxy/jvm/dispatcher/BootJarLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class BootJarLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MockKAgentLogger log;
    @NotNull
    private static final String pkg = BootJarLoader.class.getPackage().getName() + ".";
    @NotNull
    private static final Random rnd = new Random();
    @NotNull
    private static final String[] classNames;

    public BootJarLoader(@NotNull MockKAgentLogger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
    }

    public final boolean loadBootJar(@NotNull Instrumentation instrumentation) {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        File file = this.buildBootJar();
        if (file == null) {
            return false;
        }
        File bootJar = file;
        try {
            instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(bootJar));
        }
        catch (IOException e) {
            this.log.trace((Throwable)e, "Can't add to bootstrap classpath");
            return false;
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getSystemClassLoader()");
        ClassLoader classLoader2 = this.root(classLoader);
        for (String name : classNames) {
            Class<?> clazz;
            try {
                clazz = classLoader2.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                this.log.trace((Throwable)cnfe, "Can't load class " + name);
                return false;
            }
            Class<?> cls = clazz;
            if (cls.getClassLoader() != null) {
                this.log.trace("Classloader is not bootstrap for " + name);
                return false;
            }
            this.log.trace("Bootstrap class loaded " + cls.getName());
        }
        return true;
    }

    private final ClassLoader root(ClassLoader $this$root) {
        while ($this$root.getParent() != null) {
            ClassLoader classLoader;
            BootJarLoader bootJarLoader = this_;
            Intrinsics.checkNotNullExpressionValue((Object)$this$root.getParent(), (String)"parent");
            BootJarLoader this_ = bootJarLoader;
            $this$root = classLoader;
        }
        return $this$root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File buildBootJar() {
        try {
            File boot = this.createTempBootFile();
            boot.deleteOnExit();
            Closeable closeable = new JarOutputStream(new FileOutputStream(boot));
            Throwable throwable = null;
            try {
                JarOutputStream out = (JarOutputStream)closeable;
                boolean bl = false;
                for (String name : classNames) {
                    if (this.addClass(out, name)) continue;
                    File file = null;
                    return file;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return boot;
        }
        catch (IOException ex) {
            this.log.trace((Throwable)ex, "Error creating boot jar");
            return null;
        }
    }

    private final File createTempBootFile() {
        File file;
        try {
            file = File.createTempFile("mockk_boot", ".jar");
        }
        catch (IOException ex) {
            file = new File("mockk_boot_" + Math.abs(rnd.nextLong()) + ".jar");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addClass(JarOutputStream out, String source) throws IOException {
        InputStream inputStream;
        String fileName = StringsKt.replace$default((String)source, (char)'.', (char)'/', (boolean)false, (int)4, null);
        ClassLoader classLoader = BootJarLoader.class.getClassLoader();
        InputStream inputStream2 = classLoader.getResourceAsStream(fileName + ".clazz");
        if (inputStream2 == null) {
            inputStream2 = classLoader.getResourceAsStream(fileName + ".class");
        }
        if ((inputStream = inputStream2) == null) {
            this.log.trace(fileName + " not found");
            return false;
        }
        out.putNextEntry(new JarEntry(fileName + ".class"));
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)out, (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        out.closeEntry();
        return true;
    }

    static {
        String[] stringArray = new String[]{pkg + "JvmMockKDispatcher", pkg + "JvmMockKWeakMap", pkg + "JvmMockKWeakMap$StrongKey", pkg + "JvmMockKWeakMap$WeakKey"};
        classNames = stringArray;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/mockk/proxy/jvm/dispatcher/BootJarLoader$Companion;", "", "()V", "classNames", "", "", "[Ljava/lang/String;", "pkg", "rnd", "Ljava/util/Random;", "mockk-agent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

