/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm;

import io.mockk.agent.MockKInstantiatior;
import io.mockk.proxy.jvm.CacheKey;
import io.mockk.proxy.jvm.JvmMockKProxyMaker;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

public class JvmMockKInstantiatior
implements MockKInstantiatior {
    private final TypeCache<CacheKey> instanceProxyClassCache;
    private static final Object BOOTSTRAP_MONITOR = new Object();
    private final ObjenesisStd objenesis;
    private final Map<Class<?>, ObjectInstantiator<?>> instantiators = Collections.synchronizedMap(new WeakHashMap());
    private final ByteBuddy byteBuddy;

    public JvmMockKInstantiatior() {
        this.objenesis = new ObjenesisStd(true);
        this.instanceProxyClassCache = new TypeCache(TypeCache.Sort.SOFT);
        this.byteBuddy = new ByteBuddy().with(TypeValidation.DISABLED);
    }

    public <T> T instance(Class<T> cls) {
        if (!Modifier.isFinal(cls.getModifiers())) {
            try {
                T instance = this.instantiateViaProxy(cls);
                if (instance != null) {
                    return instance;
                }
            }
            catch (Exception ex) {
                JvmMockKProxyMaker.log.trace((Throwable)ex, "Failed to instantiate via proxy " + cls + ". Doing objenesis instantiation");
            }
        }
        return this.instanceViaObjenesis(cls);
    }

    private <T> T instantiateViaProxy(final Class<T> cls) {
        JvmMockKProxyMaker.log.trace("Instantiating " + cls + " via subclass proxy");
        final ClassLoader classLoader = cls.getClassLoader();
        Object monitor = classLoader == null ? BOOTSTRAP_MONITOR : classLoader;
        Class proxyCls = this.instanceProxyClassCache.findOrInsert(classLoader, (Object)new CacheKey(cls, new Class[0]), new Callable<Class<?>>(){

            @Override
            public Class<?> call() {
                return JvmMockKInstantiatior.this.byteBuddy.subclass(cls).make().load(classLoader).getLoaded();
            }
        }, monitor);
        return cls.cast(this.instanceViaObjenesis(proxyCls));
    }

    private <T> T instanceViaObjenesis(Class<T> clazz) {
        JvmMockKProxyMaker.log.trace("Creating new empty instance of " + clazz);
        ObjectInstantiator inst = this.instantiators.get(clazz);
        if (inst == null) {
            inst = this.objenesis.getInstantiatorOf(clazz);
            this.instantiators.put(clazz, inst);
        }
        return clazz.cast(inst.newInstance());
    }
}

