/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm;

import io.mockk.agent.MockKInvocationHandler;
import io.mockk.proxy.jvm.JvmMockKDispatcher;
import io.mockk.proxy.jvm.MockKCallProxy;
import io.mockk.proxy.jvm.MockKSelfCall;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;

public class JvmMockKProxyDispatcher
extends JvmMockKDispatcher {
    private static final Random RNG = new Random();
    private final long id = RNG.nextLong();
    private final Map<Object, MockKInvocationHandler> handlers;

    public JvmMockKProxyDispatcher(Map<Object, MockKInvocationHandler> handlers) {
        this.handlers = handlers;
    }

    public long getId() {
        return this.id;
    }

    public Callable<?> handler(Object self, Method method, Object[] arguments) throws Exception {
        MockKInvocationHandler handler = this.handlers.get(self);
        if (handler == null) {
            return null;
        }
        if (MockKSelfCall.isSelf(self, method)) {
            return null;
        }
        return new MockKCallProxy(handler, self, method, arguments);
    }

    public Object handle(Object self, Method method, Object[] arguments, Callable<Object> originalMethod) throws Exception {
        MockKInvocationHandler handler = this.handlers.get(self);
        if (handler == null) {
            return this.callIfNotNull(originalMethod);
        }
        if (MockKSelfCall.isSelf(self, method)) {
            return this.callIfNotNull(originalMethod);
        }
        return this.handler(self, method, arguments).call();
    }

    private Object callIfNotNull(Callable<Object> originalMethod) throws Exception {
        return originalMethod != null ? originalMethod.call() : null;
    }
}

