/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm;

import io.mockk.agent.MockKAgentException;
import io.mockk.agent.MockKAgentLogger;
import io.mockk.agent.MockKInstantiatior;
import io.mockk.agent.MockKInvocationHandler;
import io.mockk.agent.MockKProxyMaker;
import io.mockk.proxy.jvm.MockKInstrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class JvmMockKProxyMaker
implements MockKProxyMaker {
    private static final Set<Class<?>> EXCLUDES = new HashSet<Class>(Arrays.asList(Class.class, Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, String.class));
    public static MockKAgentLogger log = MockKAgentLogger.NO_OP;
    private final MockKInstantiatior instantiatior;
    private MockKInstrumentation instrumentation;

    public JvmMockKProxyMaker(MockKInstantiatior instantiatior, MockKInstrumentation instrumentation) {
        this.instantiatior = instantiatior;
        this.instrumentation = instrumentation;
    }

    public <T> T proxy(Class<T> clazz, Class<?>[] interfaces, MockKInvocationHandler handler, boolean useDefaultConstructor, Object instance) {
        Class<Object> proxyClass;
        boolean transformed;
        boolean bl = transformed = this.canInject(clazz) && this.instrumentation.inject(this.getAllSuperclasses(clazz));
        if (!Modifier.isFinal(clazz.getModifiers())) {
            log.trace("Building subclass proxy for " + clazz + " with additional interfaces " + Arrays.asList(interfaces));
            proxyClass = this.instrumentation.subclass(clazz, interfaces);
            if (!transformed) {
                this.warnOnFinalMethods(clazz);
            }
        } else {
            if (!transformed) {
                if (clazz.isPrimitive()) {
                    throw new MockKAgentException("Failed to create proxy for " + clazz + ".\n" + clazz + " is a primitive");
                }
                if (clazz.isArray()) {
                    throw new MockKAgentException("Failed to create proxy for " + clazz + ".\n" + clazz + " is an array");
                }
                if (!this.canInject(clazz)) {
                    throw new MockKAgentException("Failed to create proxy for " + clazz + ".\n" + clazz + " is one of excluded classes");
                }
                throw new MockKAgentException("Failed to create proxy for " + clazz + ".\nInstrumentation is not available and class is final.\nAdd -javaagent option to enabled MockK Java Agent at JVM startup");
            }
            if (interfaces.length != 0) {
                throw new MockKAgentException("Failed to create proxy for " + clazz + ".\nMore interfaces requested and class is final.");
            }
            log.trace("Taking instance of " + clazz + " itself because it is final.");
            proxyClass = clazz;
        }
        try {
            if (instance == null) {
                if (useDefaultConstructor) {
                    log.trace("Instantiating proxy for " + clazz + " via default constructor.");
                } else {
                    log.trace("Instantiating proxy for " + clazz + " via objenesis.");
                }
                instance = clazz.cast(useDefaultConstructor ? this.newInstanceViaDefaultConstructor(proxyClass) : this.instantiatior.instance(proxyClass));
            }
            this.instrumentation.hook(instance, handler);
            return clazz.cast(instance);
        }
        catch (Exception e) {
            throw new MockKAgentException("Instantiation exception", (Throwable)e);
        }
    }

    private Object newInstanceViaDefaultConstructor(Class<?> cls) {
        try {
            Constructor<?> defaultConstructor = cls.getDeclaredConstructor(new Class[0]);
            try {
                defaultConstructor.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MockKAgentException("Default constructor instantiation exception", (Throwable)e);
        }
    }

    public void unproxy(Object instance) {
        this.instrumentation.unhook(instance);
    }

    private <T> boolean canInject(Class<T> clazz) {
        return !EXCLUDES.contains(clazz);
    }

    private void warnOnFinalMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        while (clazz != null && !clazz.getName().equals(Object.class.getName())) {
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
            clazz = clazz.getSuperclass();
        }
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (Modifier.isPrivate(modifiers) || !Modifier.isFinal(modifiers)) continue;
            log.debug("It is impossible to intercept calls to " + method + " for " + method.getDeclaringClass() + " because it is final");
        }
    }

    private static ElementMatcher.Junction<MethodDescription> any() {
        return ElementMatchers.any();
    }

    private List<Class<?>> getAllSuperclasses(Class<?> clazz) {
        HashSet result = new HashSet();
        while (clazz != null) {
            result.add(clazz);
            this.addInterfaces(result, clazz);
            clazz = clazz.getSuperclass();
        }
        return new ArrayList(result);
    }

    private void addInterfaces(Set<Class<?>> result, Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            result.add(intf);
            this.addInterfaces(result, intf.getSuperclass());
        }
    }
}

