/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm;

import io.mockk.agent.MockKAgentException;
import io.mockk.agent.MockKInvocationHandler;
import io.mockk.agent.MockKStaticProxyMaker;
import io.mockk.proxy.jvm.JvmMockKProxyMaker;
import io.mockk.proxy.jvm.MockKInstrumentation;
import java.util.ArrayList;

public class JvmMockKStaticProxyMaker
implements MockKStaticProxyMaker {
    private MockKInstrumentation instrumentation;

    public JvmMockKStaticProxyMaker(MockKInstrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    public void staticProxy(Class<?> clazz, MockKInvocationHandler handler) {
        JvmMockKProxyMaker.log.debug("Injecting handle to " + clazz + " for static methods");
        ArrayList lst = new ArrayList();
        lst.add(clazz);
        boolean transformed = this.instrumentation.inject(lst);
        if (!transformed) {
            throw new MockKAgentException("Failed to create static proxy for " + clazz + ".\nTry running VM with MockK Java Agent\ni.e. with -javaagent:mockk-agent.jar option.");
        }
        this.instrumentation.hookStatic(clazz, handler);
    }

    public void staticUnProxy(Class<?> clazz) {
        this.instrumentation.unhookStatic(clazz);
    }
}

