/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm;

import io.mockk.agent.MockKAgentLogger;
import io.mockk.agent.MockKInvocationHandler;
import io.mockk.proxy.jvm.CacheKey;
import io.mockk.proxy.jvm.JvmMockKDispatcher;
import io.mockk.proxy.jvm.JvmMockKProxyDispatcher;
import io.mockk.proxy.jvm.JvmMockKWeakMap;
import io.mockk.proxy.jvm.MockKHashMapStaticProxyAdvice;
import io.mockk.proxy.jvm.MockKInstrumentationLoader;
import io.mockk.proxy.jvm.MockKProxyAdvice;
import io.mockk.proxy.jvm.MockKProxyAdviceId;
import io.mockk.proxy.jvm.MockKProxyInterceptor;
import io.mockk.proxy.jvm.MockKStaticProxyAdvice;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Type;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.MultipleParentClassLoader;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class MockKInstrumentation
implements ClassFileTransformer {
    public static MockKAgentLogger log = MockKAgentLogger.NO_OP;
    private Map<Object, MockKInvocationHandler> handlers;
    private Map<Object, MockKInvocationHandler> staticHandlers;
    private volatile Instrumentation instrumentation;
    private MockKProxyInterceptor interceptor;
    private MockKProxyAdvice advice;
    private MockKStaticProxyAdvice staticAdvice;
    private MockKHashMapStaticProxyAdvice staticHashMapAdvice;
    private final Set<Class<?>> classesToTransform = Collections.synchronizedSet(new HashSet());
    private static final Object BOOTSTRAP_MONITOR = new Object();
    private final TypeCache<CacheKey> proxyClassCache;
    private ByteBuddy byteBuddy;

    public MockKInstrumentation() {
        this.instrumentation = ByteBuddyAgent.install();
        if (this.instrumentation != null) {
            log.trace("Byte buddy agent installed");
            if (MockKInstrumentationLoader.LOADER.loadBootJar(this.instrumentation)) {
                log.trace("Installing MockKInstrumentation transformer");
                this.instrumentation.addTransformer(this, true);
            } else {
                log.trace("Can't inject boot jar.");
                this.instrumentation = null;
            }
        } else {
            log.debug("Can't install ByteBuddy agent.\nTry running VM with MockK Java Agent\ni.e. with -javaagent:mockk-agent.jar option.");
        }
        this.byteBuddy = new ByteBuddy().with(TypeValidation.DISABLED);
        if (this.instrumentation != null) {
            class AdviceBuilder {
                AdviceBuilder() {
                }

                void build() {
                    MockKInstrumentation.this.handlers = (Map)new JvmMockKWeakMap();
                    MockKInstrumentation.this.advice = new MockKProxyAdvice(MockKInstrumentation.this.handlers);
                    MockKInstrumentation.this.interceptor = new MockKProxyInterceptor(MockKInstrumentation.this.handlers);
                    MockKInstrumentation.this.staticHandlers = (Map)new JvmMockKWeakMap();
                    MockKInstrumentation.this.staticAdvice = new MockKStaticProxyAdvice(MockKInstrumentation.this.staticHandlers);
                    MockKInstrumentation.this.staticHashMapAdvice = new MockKHashMapStaticProxyAdvice(MockKInstrumentation.this.staticHandlers);
                    JvmMockKDispatcher.set((long)MockKInstrumentation.this.advice.getId(), (JvmMockKDispatcher)MockKInstrumentation.this.advice);
                    JvmMockKDispatcher.set((long)MockKInstrumentation.this.staticAdvice.getId(), (JvmMockKDispatcher)MockKInstrumentation.this.staticAdvice);
                    JvmMockKDispatcher.set((long)MockKInstrumentation.this.staticHashMapAdvice.getId(), (JvmMockKDispatcher)MockKInstrumentation.this.staticHashMapAdvice);
                    JvmMockKDispatcher.set((long)MockKInstrumentation.this.interceptor.getId(), (JvmMockKDispatcher)MockKInstrumentation.this.interceptor);
                }
            }
            new AdviceBuilder().build();
        } else {
            this.handlers = Collections.synchronizedMap(new IdentityHashMap());
            this.staticHandlers = Collections.synchronizedMap(new IdentityHashMap());
        }
        this.proxyClassCache = new TypeCache(TypeCache.Sort.WEAK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inject(List<Class<?>> classes) {
        if (this.instrumentation == null) {
            return false;
        }
        Set<Class<?>> set = this.classesToTransform;
        synchronized (set) {
            classes.removeAll(this.classesToTransform);
            if (classes.isEmpty()) {
                return true;
            }
            log.trace("Injecting handle to " + classes);
            this.classesToTransform.addAll(classes);
        }
        Class[] cls = classes.toArray(new Class[classes.size()]);
        try {
            this.instrumentation.retransformClasses(cls);
            log.trace("Injected OK");
            return true;
        }
        catch (UnmodifiableClassException e) {
            return false;
        }
    }

    public void enable() {
        this.instrumentation = ByteBuddyAgent.getInstrumentation();
    }

    public void disable() {
        this.instrumentation = null;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!this.classesToTransform.contains(classBeingRedefined)) {
            return null;
        }
        try {
            DynamicType.Unloaded unloaded = this.byteBuddy.redefine(classBeingRedefined, ClassFileLocator.Simple.of((String)classBeingRedefined.getName(), (byte[])classfileBuffer)).visit((AsmVisitorWrapper)Advice.withCustomMapping().bind(MockKProxyAdviceId.class, (Object)this.advice.getId()).to(MockKProxyAdvice.class).on((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isStatic())).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDefaultFinalizer())))).visit((AsmVisitorWrapper)Advice.withCustomMapping().bind(MockKProxyAdviceId.class, (Object)this.staticProxyAdviceId(className)).to(this.staticProxyAdvice(className)).on((ElementMatcher)ElementMatchers.isStatic().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isTypeInitializer())).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isConstructor())))).make();
            return unloaded.getBytes();
        }
        catch (Throwable e) {
            log.warn(e, "Failed to transform class");
            return null;
        }
    }

    public <T> Class<?> subclass(final Class<T> clazz, final Class<?>[] interfaces) {
        CacheKey key = new CacheKey(clazz, interfaces);
        ClassLoader classLoader = clazz.getClassLoader();
        Object monitor = classLoader == null ? BOOTSTRAP_MONITOR : classLoader;
        return this.proxyClassCache.findOrInsert(classLoader, (Object)key, new Callable<Class<?>>(){

            @Override
            public Class<?> call() {
                ClassLoader classLoader = new MultipleParentClassLoader.Builder().append(new Class[]{clazz}).append(interfaces).append(new ClassLoader[]{Thread.currentThread().getContextClassLoader()}).append(new Class[]{MockKProxyInterceptor.class}).build(MockKProxyInterceptor.class.getClassLoader());
                return MockKInstrumentation.this.byteBuddy.subclass(clazz).implement((Type[])interfaces).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{TargetMethodAnnotationDrivenBinder.ParameterBinder.ForFixedValue.OfConstant.of(MockKProxyAdviceId.class, (Object)MockKInstrumentation.this.interceptor.getId())}).to(MockKProxyInterceptor.class)).make().load(classLoader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
            }
        }, monitor);
    }

    private long staticProxyAdviceId(String className) {
        return className.equals("java/util/HashMap") ? this.staticHashMapAdvice.getId() : this.staticAdvice.getId();
    }

    private Class<? extends JvmMockKProxyDispatcher> staticProxyAdvice(String className) {
        return className.equals("java/util/HashMap") ? MockKHashMapStaticProxyAdvice.class : MockKStaticProxyAdvice.class;
    }

    private static ElementMatcher.Junction<MethodDescription> isPackagePrivateJavaMethods() {
        return ElementMatchers.isDeclaredBy((ElementMatcher)ElementMatchers.nameStartsWith((String)"java.")).and((ElementMatcher)ElementMatchers.isPackagePrivate());
    }

    public <T> void hook(T instance, MockKInvocationHandler handler) {
        this.handlers.put(instance, handler);
    }

    public <T> void unhook(T instance) {
        this.handlers.remove(instance);
    }

    public void hookStatic(Class<?> clazz, MockKInvocationHandler handler) {
        this.staticHandlers.put(clazz, handler);
    }

    public void unhookStatic(Class<?> clazz) {
        this.staticHandlers.remove(clazz);
    }

    public MockKInvocationHandler getHook(Object self) {
        return this.handlers.get(self);
    }
}

