/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm;

import io.mockk.agent.MockKAgentLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class MockKInstrumentationLoader {
    public static MockKAgentLogger log = MockKAgentLogger.NO_OP;
    private static final String PKG = "io.mockk.proxy.jvm.";
    private static final String[] BOOTSTRAP_CLASS_NAMES = new String[]{"io.mockk.proxy.jvm.JvmMockKDispatcher", "io.mockk.proxy.jvm.JvmMockKWeakMap", "io.mockk.proxy.jvm.JvmMockKWeakMap$StrongKey", "io.mockk.proxy.jvm.JvmMockKWeakMap$WeakKey"};
    public static final MockKInstrumentationLoader LOADER = new MockKInstrumentationLoader();

    private MockKInstrumentationLoader() {
    }

    public boolean loadBootJar(Instrumentation instrumentation) {
        File bootJar = this.getBootJar();
        if (bootJar == null) {
            return false;
        }
        try {
            instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(bootJar));
        }
        catch (IOException e) {
            log.trace((Throwable)e, "Can't add to bootstrap classpath");
            return false;
        }
        try {
            boolean i = false;
            for (String name : BOOTSTRAP_CLASS_NAMES) {
                Class<?> cls = this.topClassLoader().loadClass(name);
                if (cls.getClassLoader() != null) {
                    log.trace("Classloader is not bootstrap for " + name);
                    return false;
                }
                log.trace("Bootstrap class loaded " + cls.getName());
            }
        }
        catch (ClassNotFoundException cnfe) {
            log.trace((Throwable)cnfe, "Can't load class");
            return false;
        }
        return true;
    }

    private ClassLoader topClassLoader() {
        ClassLoader cls = ClassLoader.getSystemClassLoader();
        while (cls.getParent() != null) {
            cls = cls.getParent();
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getBootJar() {
        try {
            File boot = File.createTempFile("mockk_boot", ".jar");
            boot.deleteOnExit();
            JarOutputStream out = new JarOutputStream(new FileOutputStream(boot));
            try {
                String[] stringArray = BOOTSTRAP_CLASS_NAMES;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (!this.addClass(out, name)) {
                        File file = null;
                        return file;
                    }
                    ++n2;
                }
                return boot;
            }
            finally {
                out.close();
            }
        }
        catch (IOException ex) {
            log.trace((Throwable)ex, "Error creating boot jar");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addClass(JarOutputStream out, String source) throws IOException {
        source = source.replace('.', '/');
        InputStream inputStream = MockKInstrumentationLoader.class.getClassLoader().getResourceAsStream(source + ".clazz");
        if (inputStream == null) {
            inputStream = MockKInstrumentationLoader.class.getClassLoader().getResourceAsStream(source + ".class");
        }
        if (inputStream == null) {
            log.trace(source + " not found");
            return false;
        }
        out.putNextEntry(new JarEntry(source + ".class"));
        try {
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
        }
        finally {
            inputStream.close();
        }
        out.closeEntry();
        return true;
    }
}

