/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.verify;

import io.mockk.Invocation;
import io.mockk.MockKSettings;
import io.mockk.RecordedCall;
import io.mockk.StackElement;
import io.mockk.StackTracesAlignment;
import io.mockk.impl.InternalPlatform;
import io.mockk.impl.Ref;
import io.mockk.impl.stub.StubRepository;
import io.mockk.impl.verify.LCSMatchingAlgo;
import io.mockk.impl.verify.VerificationHelpers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J$\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0002J,\u0010\r\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006J\u0014\u0010\u0015\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lio/mockk/impl/verify/VerificationHelpers;", "", "()V", "formatCalls", "", "calls", "", "Lio/mockk/Invocation;", "verifiedCalls", "formatMatchers", "matchers", "Lio/mockk/RecordedCall;", "verifiedMatchers", "reportCalls", "allCalls", "lcs", "Lio/mockk/impl/verify/LCSMatchingAlgo;", "stackTrace", "prefix", "", "Lio/mockk/StackElement;", "stackTraces", "allInvocations", "stubRepo", "Lio/mockk/impl/stub/StubRepository;", "mockk"})
@SourceDebugExtension(value={"SMAP\nVerificationHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerificationHelpers.kt\nio/mockk/impl/verify/VerificationHelpers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1559#2:95\n1590#2,4:96\n1559#2:100\n1590#2,4:101\n1549#2:105\n1620#2,3:106\n1549#2:109\n1620#2,3:110\n1360#2:113\n1446#2,5:114\n1045#2:119\n1549#2:121\n1620#2,3:122\n1#3:120\n*S KotlinDebug\n*F\n+ 1 VerificationHelpers.kt\nio/mockk/impl/verify/VerificationHelpers\n*L\n13#1:95\n13#1:96,4\n21#1:100\n21#1:101,4\n67#1:105\n67#1:106,3\n69#1:109\n69#1:110,3\n70#1:113\n70#1:114,5\n71#1:119\n30#1:121\n30#1:122,3\n*E\n"})
public final class VerificationHelpers {
    @NotNull
    public static final VerificationHelpers INSTANCE = new VerificationHelpers();

    private VerificationHelpers() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String formatCalls(@NotNull List<Invocation> calls2, @NotNull List<Invocation> verifiedCalls) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(calls2, (String)"calls");
        Intrinsics.checkNotNullParameter(verifiedCalls, (String)"verifiedCalls");
        Iterable $this$mapIndexed$iv = calls2;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void idx;
            void call2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Invocation invocation2 = (Invocation)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String plusSign = verifiedCalls.contains(call2) ? "+" : "";
            collection.add((int)(idx + true) + ") " + plusSign + call2);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public static /* synthetic */ String formatCalls$default(VerificationHelpers verificationHelpers, List list, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return verificationHelpers.formatCalls(list, list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String stackTraces(@NotNull List<Invocation> calls2) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(calls2, (String)"calls");
        Iterable $this$mapIndexed$iv = calls2;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void call2;
            void idx;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Invocation invocation2 = (Invocation)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String prefix = "" + (int)(idx + true) + ')';
            collection.add(prefix + ' ' + INSTANCE.stackTrace(prefix.length() + 1, (List)call2.getCallStack().invoke()));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String stackTrace(int prefix, @NotNull List<StackElement> stackTrace2) {
        Intrinsics.checkNotNullParameter(stackTrace2, (String)"stackTrace");
        int maxClassNameLen2 = VerificationHelpers.stackTrace$columnSize(stackTrace2, (Function1<? super StackElement, String>)((Function1)stackTrace.maxClassNameLen.1.INSTANCE));
        int maxMethodLen2 = VerificationHelpers.stackTrace$columnSize(stackTrace2, (Function1<? super StackElement, String>)((Function1)stackTrace.maxMethodLen.1.INSTANCE));
        int maxThirdColumn2 = VerificationHelpers.stackTrace$columnSize(stackTrace2, (Function1<? super StackElement, String>)((Function1)stackTrace.maxThirdColumn.1.INSTANCE));
        Function1 lineFormatter2 = MockKSettings.INSTANCE.getStackTracesAlignment() == StackTracesAlignment.CENTER ? (Function1)new Function1<StackElement, String>(prefix, maxClassNameLen2, maxMethodLen2, maxThirdColumn2){
            final /* synthetic */ int $prefix;
            final /* synthetic */ int $maxClassNameLen;
            final /* synthetic */ int $maxMethodLen;
            final /* synthetic */ int $maxThirdColumn;
            {
                this.$prefix = $prefix;
                this.$maxClassNameLen = $maxClassNameLen;
                this.$maxMethodLen = $maxMethodLen;
                this.$maxThirdColumn = $maxThirdColumn;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull StackElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return VerificationHelpers.access$stackTrace$spaces(this.$prefix) + VerificationHelpers.access$stackTrace$columnRight(it.getClassName(), this.$maxClassNameLen) + '.' + VerificationHelpers.access$stackTrace$columnLeft(it.getMethodName(), this.$maxMethodLen) + ' ' + VerificationHelpers.access$stackTrace$columnLeft(VerificationHelpers.access$stackTrace$fileLine(it), this.$maxThirdColumn);
            }
        } : (Function1)new Function1<StackElement, String>(prefix){
            final /* synthetic */ int $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull StackElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return VerificationHelpers.access$stackTrace$spaces(this.$prefix) + it.getClassName() + '.' + it.getMethodName() + ' ' + VerificationHelpers.access$stackTrace$fileLine(it);
            }
        };
        String string = CollectionsKt.joinToString$default((Iterable)stackTrace2, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<StackElement, CharSequence>((Function1<? super StackElement, String>)lineFormatter2){
            final /* synthetic */ Function1<StackElement, String> $lineFormatter;
            {
                this.$lineFormatter = $lineFormatter;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull StackElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CharSequence)this.$lineFormatter.invoke((Object)it);
            }
        }), (int)30, null).substring(prefix);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Invocation> allInvocations(@NotNull List<RecordedCall> $this$allInvocations, @NotNull StubRepository stubRepo) {
        void $this$flatMapTo$iv$iv;
        Ref it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$allInvocations, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stubRepo, (String)"stubRepo");
        Iterable $this$map$iv = $this$allInvocations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RecordedCall recordedCall = (RecordedCall)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(InternalPlatform.INSTANCE.ref(it.getMatcher().getSelf()));
        }
        $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Ref)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = stubRepo.stubFor(it).allRecordedCalls();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Invocation it = (Invocation)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTimestamp());
                it = (Invocation)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
            }
        });
    }

    @NotNull
    public final String reportCalls(@NotNull List<RecordedCall> matchers2, @NotNull List<Invocation> allCalls, @NotNull LCSMatchingAlgo lcs) {
        Intrinsics.checkNotNullParameter(matchers2, (String)"matchers");
        Intrinsics.checkNotNullParameter(allCalls, (String)"allCalls");
        Intrinsics.checkNotNullParameter((Object)lcs, (String)"lcs");
        return "\n\nMatchers: \n" + this.formatMatchers(matchers2, lcs.getVerifiedMatchers()) + "\n\nCalls:\n" + this.formatCalls(allCalls, lcs.getVerifiedCalls()) + '\n' + (MockKSettings.INSTANCE.getStackTracesOnVerify() ? "\nStack traces:\n" + this.stackTraces(allCalls) : "");
    }

    public static /* synthetic */ String reportCalls$default(VerificationHelpers verificationHelpers, List list, List list2, LCSMatchingAlgo lCSMatchingAlgo, int n, Object object) {
        if ((n & 4) != 0) {
            LCSMatchingAlgo lCSMatchingAlgo2;
            LCSMatchingAlgo $this$reportCalls_u24lambda_u248 = lCSMatchingAlgo2 = new LCSMatchingAlgo(list2, list, null, 4, null);
            boolean bl = false;
            $this$reportCalls_u24lambda_u248.lcs();
            lCSMatchingAlgo = lCSMatchingAlgo2;
        }
        return verificationHelpers.reportCalls(list, list2, lCSMatchingAlgo);
    }

    private final String formatMatchers(List<RecordedCall> matchers2, List<RecordedCall> verifiedMatchers) {
        return CollectionsKt.joinToString$default((Iterable)matchers2, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<RecordedCall, CharSequence>(verifiedMatchers){
            final /* synthetic */ List<RecordedCall> $verifiedMatchers;
            {
                this.$verifiedMatchers = $verifiedMatchers;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull RecordedCall it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (this.$verifiedMatchers.contains(it) ? "+" : "") + it.getMatcher();
            }
        }), (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final int stackTrace$columnSize(List<StackElement> $stackTrace, Function1<? super StackElement, String> block2) {
        Comparable comparable;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = $stackTrace;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add(block2.invoke(item$iv$iv));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.length());
        }
        Iterator iterator = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            int it = ((Number)iterator.next()).intValue();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it);
            while (iterator.hasNext()) {
                int it2 = ((Number)iterator.next()).intValue();
                $i$a$-maxOfOrNull-VerificationHelpers$stackTrace$columnSize$2 = false;
                Comparable comparable3 = Integer.valueOf(it2);
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : 0;
    }

    private static final String stackTrace$fileLine(StackElement $this$stackTrace_u24fileLine) {
        return '(' + $this$stackTrace_u24fileLine.getFileName() + ':' + $this$stackTrace_u24fileLine.getLine() + ')' + ($this$stackTrace_u24fileLine.getNativeMethod() ? "N" : "");
    }

    private static final String stackTrace$spaces(int n) {
        return n < 0 ? "" : CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, n)), (CharSequence)"", null, null, (int)0, null, (Function1)stackTrace.spaces.1.INSTANCE, (int)30, null);
    }

    private static final String stackTrace$columnRight(String s, int sz) {
        return VerificationHelpers.stackTrace$spaces(sz - s.length()) + s;
    }

    private static final String stackTrace$columnLeft(String s, int sz) {
        return s + VerificationHelpers.stackTrace$spaces(sz - s.length());
    }

    public static final /* synthetic */ String access$stackTrace$fileLine(StackElement $receiver) {
        return VerificationHelpers.stackTrace$fileLine($receiver);
    }

    public static final /* synthetic */ String access$stackTrace$spaces(int n) {
        return VerificationHelpers.stackTrace$spaces(n);
    }

    public static final /* synthetic */ String access$stackTrace$columnRight(String s, int sz) {
        return VerificationHelpers.stackTrace$columnRight(s, sz);
    }

    public static final /* synthetic */ String access$stackTrace$columnLeft(String s, int sz) {
        return VerificationHelpers.stackTrace$columnLeft(s, sz);
    }
}

