/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.json.schema.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import io.modelcontextprotocol.json.schema.JsonSchemaValidator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJsonSchemaValidator
implements JsonSchemaValidator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJsonSchemaValidator.class);
    private final ObjectMapper objectMapper;
    private final JsonSchemaFactory schemaFactory;
    private final ConcurrentHashMap<String, JsonSchema> schemaCache;

    public DefaultJsonSchemaValidator() {
        this(new ObjectMapper());
    }

    public DefaultJsonSchemaValidator(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.schemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012);
        this.schemaCache = new ConcurrentHashMap();
    }

    public JsonSchemaValidator.ValidationResponse validate(Map<String, Object> schema, Object structuredContent) {
        if (schema == null) {
            throw new IllegalArgumentException("Schema must not be null");
        }
        if (structuredContent == null) {
            throw new IllegalArgumentException("Structured content must not be null");
        }
        try {
            JsonNode jsonStructuredOutput = structuredContent instanceof String ? this.objectMapper.readTree((String)structuredContent) : this.objectMapper.valueToTree(structuredContent);
            Set validationResult = this.getOrCreateJsonSchema(schema).validate(jsonStructuredOutput);
            if (!validationResult.isEmpty()) {
                return JsonSchemaValidator.ValidationResponse.asInvalid((String)("Validation failed: structuredContent does not match tool outputSchema. Validation errors: " + String.valueOf(validationResult)));
            }
            return JsonSchemaValidator.ValidationResponse.asValid((String)jsonStructuredOutput.toString());
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to validate CallToolResult: Error parsing schema: {}", (Throwable)e);
            return JsonSchemaValidator.ValidationResponse.asInvalid((String)("Error parsing tool JSON Schema: " + e.getMessage()));
        }
        catch (Exception e) {
            logger.error("Failed to validate CallToolResult: Unexpected error: {}", (Throwable)e);
            return JsonSchemaValidator.ValidationResponse.asInvalid((String)("Unexpected validation error: " + e.getMessage()));
        }
    }

    private JsonSchema getOrCreateJsonSchema(Map<String, Object> schema) throws JsonProcessingException {
        String cacheKey = this.generateCacheKey(schema);
        JsonSchema cachedSchema = this.schemaCache.get(cacheKey);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        JsonSchema newSchema = this.createJsonSchema(schema);
        JsonSchema existingSchema = this.schemaCache.putIfAbsent(cacheKey, newSchema);
        return existingSchema != null ? existingSchema : newSchema;
    }

    private JsonSchema createJsonSchema(Map<String, Object> schema) throws JsonProcessingException {
        JsonNode schemaNode = this.objectMapper.valueToTree(schema);
        if (schemaNode == null) {
            throw new JsonProcessingException("Failed to convert schema to JsonNode"){};
        }
        return this.schemaFactory.getSchema(schemaNode);
    }

    protected String generateCacheKey(Map<String, Object> schema) {
        if (schema.containsKey("$id")) {
            return String.valueOf(schema.get("$id"));
        }
        return String.valueOf(schema.hashCode());
    }

    public void clearCache() {
        this.schemaCache.clear();
    }

    public int getCacheSize() {
        return this.schemaCache.size();
    }
}

