/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server.transport;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.server.McpStatelessServerHandler;
import io.modelcontextprotocol.server.McpTransportContextExtractor;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStatelessServerTransport;
import io.modelcontextprotocol.util.Assert;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

public class WebFluxStatelessServerTransport
implements McpStatelessServerTransport {
    private static final Logger logger = LoggerFactory.getLogger(WebFluxStatelessServerTransport.class);
    private final ObjectMapper objectMapper;
    private final String mcpEndpoint;
    private final RouterFunction<?> routerFunction;
    private McpStatelessServerHandler mcpHandler;
    private McpTransportContextExtractor<ServerRequest> contextExtractor;
    private volatile boolean isClosing = false;

    private WebFluxStatelessServerTransport(ObjectMapper objectMapper, String mcpEndpoint, McpTransportContextExtractor<ServerRequest> contextExtractor) {
        Assert.notNull((Object)objectMapper, (String)"objectMapper must not be null");
        Assert.notNull((Object)mcpEndpoint, (String)"mcpEndpoint must not be null");
        Assert.notNull(contextExtractor, (String)"contextExtractor must not be null");
        this.objectMapper = objectMapper;
        this.mcpEndpoint = mcpEndpoint;
        this.contextExtractor = contextExtractor;
        this.routerFunction = RouterFunctions.route().GET(this.mcpEndpoint, this::handleGet).POST(this.mcpEndpoint, this::handlePost).build();
    }

    public void setMcpHandler(McpStatelessServerHandler mcpHandler) {
        this.mcpHandler = mcpHandler;
    }

    public Mono<Void> closeGracefully() {
        return Mono.fromRunnable(() -> {
            this.isClosing = true;
        });
    }

    public RouterFunction<?> getRouterFunction() {
        return this.routerFunction;
    }

    private Mono<ServerResponse> handleGet(ServerRequest request) {
        return ServerResponse.status((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED).build();
    }

    private Mono<ServerResponse> handlePost(ServerRequest request) {
        if (this.isClosing) {
            return ServerResponse.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).bodyValue((Object)"Server is shutting down");
        }
        McpTransportContext transportContext = this.contextExtractor.extract((Object)request);
        List acceptHeaders = request.headers().asHttpHeaders().getAccept();
        if (!acceptHeaders.contains(MediaType.APPLICATION_JSON) || !acceptHeaders.contains(MediaType.TEXT_EVENT_STREAM)) {
            return ServerResponse.badRequest().build();
        }
        return request.bodyToMono(String.class).flatMap(body -> {
            try {
                McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage((ObjectMapper)this.objectMapper, (String)body);
                if (message instanceof McpSchema.JSONRPCRequest) {
                    McpSchema.JSONRPCRequest jsonrpcRequest = (McpSchema.JSONRPCRequest)message;
                    return this.mcpHandler.handleRequest(transportContext, jsonrpcRequest).flatMap(jsonrpcResponse -> ServerResponse.ok().contentType(MediaType.APPLICATION_JSON).bodyValue(jsonrpcResponse));
                }
                if (message instanceof McpSchema.JSONRPCNotification) {
                    McpSchema.JSONRPCNotification jsonrpcNotification = (McpSchema.JSONRPCNotification)message;
                    return this.mcpHandler.handleNotification(transportContext, jsonrpcNotification).then(ServerResponse.accepted().build());
                }
                return ServerResponse.badRequest().bodyValue((Object)new McpError((Object)"The server accepts either requests or notifications"));
            }
            catch (IOException | IllegalArgumentException e) {
                logger.error("Failed to deserialize message: {}", (Object)e.getMessage());
                return ServerResponse.badRequest().bodyValue((Object)new McpError((Object)"Invalid message format"));
            }
        }).contextWrite(ctx -> ctx.put((Object)"MCP_TRANSPORT_CONTEXT", (Object)transportContext));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ObjectMapper objectMapper;
        private String mcpEndpoint = "/mcp";
        private McpTransportContextExtractor<ServerRequest> contextExtractor = serverRequest -> McpTransportContext.EMPTY;

        private Builder() {
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder messageEndpoint(String messageEndpoint) {
            Assert.notNull((Object)messageEndpoint, (String)"Message endpoint must not be null");
            this.mcpEndpoint = messageEndpoint;
            return this;
        }

        public Builder contextExtractor(McpTransportContextExtractor<ServerRequest> contextExtractor) {
            Assert.notNull(contextExtractor, (String)"Context extractor must not be null");
            this.contextExtractor = contextExtractor;
            return this;
        }

        public WebFluxStatelessServerTransport build() {
            Assert.notNull((Object)this.objectMapper, (String)"ObjectMapper must be set");
            Assert.notNull((Object)this.mcpEndpoint, (String)"Message endpoint must be set");
            return new WebFluxStatelessServerTransport(this.objectMapper, this.mcpEndpoint, this.contextExtractor);
        }
    }
}

