/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.time.Duration;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public abstract class AbstractMcpAsyncServerTests {
    private static final String TEST_TOOL_NAME = "test-tool";
    private static final String TEST_RESOURCE_URI = "test://resource";
    private static final String TEST_PROMPT_NAME = "test-prompt";
    String emptyJsonSchema = "{\n\t\"$schema\": \"http://json-schema.org/draft-07/schema#\",\n\t\"type\": \"object\",\n\t\"properties\": {}\n}\n";

    protected abstract McpServerTransportProvider createMcpTransportProvider();

    protected void onStart() {
    }

    protected void onClose() {
    }

    @BeforeEach
    void setUp() {
    }

    @AfterEach
    void tearDown() {
        this.onClose();
    }

    @Test
    void testConstructorWithInvalidArguments() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpServer.async((McpServerTransportProvider)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Transport provider must not be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo((McpSchema.Implementation)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Server info must not be null");
    }

    @Test
    void testGracefulShutdown() {
        McpAsyncServer mcpAsyncServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        StepVerifier.create((Publisher)mcpAsyncServer.closeGracefully()).verifyComplete();
    }

    @Test
    void testImmediateClose() {
        McpAsyncServer mcpAsyncServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        Assertions.assertThatCode(() -> mcpAsyncServer.close()).doesNotThrowAnyException();
    }

    @Test
    void testAddTool() {
        McpSchema.Tool newTool = new McpSchema.Tool("new-tool", "New test tool", this.emptyJsonSchema);
        McpAsyncServer mcpAsyncServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).build();
        StepVerifier.create((Publisher)mcpAsyncServer.addTool(new McpServerFeatures.AsyncToolSpecification(newTool, (exchange, args) -> Mono.just((Object)new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false)))))).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testAddDuplicateTool() {
        McpSchema.Tool duplicateTool = new McpSchema.Tool(TEST_TOOL_NAME, "Duplicate tool", this.emptyJsonSchema);
        McpAsyncServer mcpAsyncServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tool(duplicateTool, (exchange, args) -> Mono.just((Object)new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false)))).build();
        StepVerifier.create((Publisher)mcpAsyncServer.addTool(new McpServerFeatures.AsyncToolSpecification(duplicateTool, (exchange, args) -> Mono.just((Object)new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false)))))).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(McpError.class)).hasMessage("Tool with name 'test-tool' already exists"));
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testRemoveTool() {
        McpSchema.Tool too = new McpSchema.Tool(TEST_TOOL_NAME, "Duplicate tool", this.emptyJsonSchema);
        McpAsyncServer mcpAsyncServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tool(too, (exchange, args) -> Mono.just((Object)new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false)))).build();
        StepVerifier.create((Publisher)mcpAsyncServer.removeTool(TEST_TOOL_NAME)).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testRemoveNonexistentTool() {
        McpAsyncServer mcpAsyncServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).build();
        StepVerifier.create((Publisher)mcpAsyncServer.removeTool("nonexistent-tool")).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(McpError.class)).hasMessage("Tool with name 'nonexistent-tool' not found"));
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testNotifyToolsListChanged() {
        McpSchema.Tool too = new McpSchema.Tool(TEST_TOOL_NAME, "Duplicate tool", this.emptyJsonSchema);
        McpAsyncServer mcpAsyncServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tool(too, (exchange, args) -> Mono.just((Object)new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false)))).build();
        StepVerifier.create((Publisher)mcpAsyncServer.notifyToolsListChanged()).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testNotifyResourcesListChanged() {
        McpAsyncServer mcpAsyncServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        StepVerifier.create((Publisher)mcpAsyncServer.notifyResourcesListChanged()).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testAddResource() {
        McpAsyncServer mcpAsyncServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        McpSchema.Resource resource = new McpSchema.Resource(TEST_RESOURCE_URI, "Test Resource", "text/plain", "Test resource description", null);
        McpServerFeatures.AsyncResourceSpecification specification = new McpServerFeatures.AsyncResourceSpecification(resource, (exchange, req) -> Mono.just((Object)new McpSchema.ReadResourceResult(List.of())));
        StepVerifier.create((Publisher)mcpAsyncServer.addResource(specification)).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testAddResourceWithNullSpecification() {
        McpAsyncServer mcpAsyncServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        StepVerifier.create((Publisher)mcpAsyncServer.addResource((McpServerFeatures.AsyncResourceSpecification)null)).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(McpError.class)).hasMessage("Resource must not be null"));
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testAddResourceWithoutCapability() {
        McpAsyncServer serverWithoutResources = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        McpSchema.Resource resource = new McpSchema.Resource(TEST_RESOURCE_URI, "Test Resource", "text/plain", "Test resource description", null);
        McpServerFeatures.AsyncResourceSpecification specification = new McpServerFeatures.AsyncResourceSpecification(resource, (exchange, req) -> Mono.just((Object)new McpSchema.ReadResourceResult(List.of())));
        StepVerifier.create((Publisher)serverWithoutResources.addResource(specification)).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(McpError.class)).hasMessage("Server must be configured with resource capabilities"));
    }

    @Test
    void testRemoveResourceWithoutCapability() {
        McpAsyncServer serverWithoutResources = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        StepVerifier.create((Publisher)serverWithoutResources.removeResource(TEST_RESOURCE_URI)).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(McpError.class)).hasMessage("Server must be configured with resource capabilities"));
    }

    @Test
    void testNotifyPromptsListChanged() {
        McpAsyncServer mcpAsyncServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        StepVerifier.create((Publisher)mcpAsyncServer.notifyPromptsListChanged()).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testAddPromptWithNullSpecification() {
        McpAsyncServer mcpAsyncServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().prompts(Boolean.valueOf(false)).build()).build();
        StepVerifier.create((Publisher)mcpAsyncServer.addPrompt((McpServerFeatures.AsyncPromptSpecification)null)).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(McpError.class)).hasMessage("Prompt specification must not be null"));
    }

    @Test
    void testAddPromptWithoutCapability() {
        McpAsyncServer serverWithoutPrompts = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        McpSchema.Prompt prompt = new McpSchema.Prompt(TEST_PROMPT_NAME, "Test Prompt", List.of());
        McpServerFeatures.AsyncPromptSpecification specification = new McpServerFeatures.AsyncPromptSpecification(prompt, (exchange, req) -> Mono.just((Object)new McpSchema.GetPromptResult("Test prompt description", List.of(new McpSchema.PromptMessage(McpSchema.Role.ASSISTANT, (McpSchema.Content)new McpSchema.TextContent("Test content"))))));
        StepVerifier.create((Publisher)serverWithoutPrompts.addPrompt(specification)).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(McpError.class)).hasMessage("Server must be configured with prompt capabilities"));
    }

    @Test
    void testRemovePromptWithoutCapability() {
        McpAsyncServer serverWithoutPrompts = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        StepVerifier.create((Publisher)serverWithoutPrompts.removePrompt(TEST_PROMPT_NAME)).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(McpError.class)).hasMessage("Server must be configured with prompt capabilities"));
    }

    @Test
    void testRemovePrompt() {
        String TEST_PROMPT_NAME_TO_REMOVE = "TEST_PROMPT_NAME678";
        McpSchema.Prompt prompt = new McpSchema.Prompt(TEST_PROMPT_NAME_TO_REMOVE, "Test Prompt", List.of());
        McpServerFeatures.AsyncPromptSpecification specification = new McpServerFeatures.AsyncPromptSpecification(prompt, (exchange, req) -> Mono.just((Object)new McpSchema.GetPromptResult("Test prompt description", List.of(new McpSchema.PromptMessage(McpSchema.Role.ASSISTANT, (McpSchema.Content)new McpSchema.TextContent("Test content"))))));
        McpAsyncServer mcpAsyncServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().prompts(Boolean.valueOf(true)).build()).prompts(new McpServerFeatures.AsyncPromptSpecification[]{specification}).build();
        StepVerifier.create((Publisher)mcpAsyncServer.removePrompt(TEST_PROMPT_NAME_TO_REMOVE)).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testRemoveNonexistentPrompt() {
        McpAsyncServer mcpAsyncServer2 = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().prompts(Boolean.valueOf(true)).build()).build();
        StepVerifier.create((Publisher)mcpAsyncServer2.removePrompt("nonexistent-prompt")).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(McpError.class)).hasMessage("Prompt with name 'nonexistent-prompt' not found"));
        Assertions.assertThatCode(() -> mcpAsyncServer2.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testRootsChangeHandlers() {
        McpSchema.Root[] rootsReceived = new McpSchema.Root[1];
        boolean[] consumerCalled = new boolean[1];
        McpAsyncServer singleConsumerServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").rootsChangeHandlers(List.of((exchange, roots) -> Mono.fromRunnable(() -> {
            consumerCalled[0] = true;
            if (!roots.isEmpty()) {
                rootsReceived[0] = (McpSchema.Root)roots.get(0);
            }
        }))).build();
        Assertions.assertThat((Object)singleConsumerServer).isNotNull();
        Assertions.assertThatCode(() -> singleConsumerServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
        this.onClose();
        boolean[] consumer1Called = new boolean[1];
        boolean[] consumer2Called = new boolean[1];
        List[] rootsContent = new List[1];
        McpAsyncServer multipleConsumersServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").rootsChangeHandlers(List.of((exchange, roots) -> Mono.fromRunnable(() -> {
            consumer1Called[0] = true;
            rootsContent[0] = roots;
        }), (exchange, roots) -> Mono.fromRunnable(() -> {
            consumer2Called[0] = true;
        }))).build();
        Assertions.assertThat((Object)multipleConsumersServer).isNotNull();
        Assertions.assertThatCode(() -> multipleConsumersServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
        this.onClose();
        McpAsyncServer errorHandlingServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").rootsChangeHandlers(List.of((exchange, roots) -> {
            throw new RuntimeException("Test error");
        })).build();
        Assertions.assertThat((Object)errorHandlingServer).isNotNull();
        Assertions.assertThatCode(() -> errorHandlingServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
        this.onClose();
        McpAsyncServer noConsumersServer = McpServer.async((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        Assertions.assertThat((Object)noConsumersServer).isNotNull();
        Assertions.assertThatCode(() -> noConsumersServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }
}

