/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.spec.ClientMcpTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public abstract class AbstractMcpAsyncClientTests {
    private McpAsyncClient mcpAsyncClient;
    protected ClientMcpTransport mcpTransport;
    private static final Duration TIMEOUT = Duration.ofSeconds(20L);
    private static final String ECHO_TEST_MESSAGE = "Hello MCP Spring AI!";

    protected abstract ClientMcpTransport createMcpTransport();

    protected void onStart() {
    }

    protected void onClose() {
    }

    @BeforeEach
    void setUp() {
        this.onStart();
        this.mcpTransport = this.createMcpTransport();
        Assertions.assertThatCode(() -> {
            this.mcpAsyncClient = McpClient.async((ClientMcpTransport)this.mcpTransport).requestTimeout(TIMEOUT).capabilities(McpSchema.ClientCapabilities.builder().roots(Boolean.valueOf(true)).build()).build();
            this.mcpAsyncClient.initialize().block(Duration.ofSeconds(10L));
        }).doesNotThrowAnyException();
    }

    @AfterEach
    void tearDown() {
        if (this.mcpAsyncClient != null) {
            Assertions.assertThatCode(() -> this.mcpAsyncClient.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
        }
        this.onClose();
    }

    @Test
    void testConstructorWithInvalidArguments() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpClient.sync(null).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Transport must not be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpClient.sync((ClientMcpTransport)this.mcpTransport).requestTimeout(null).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Request timeout must not be null");
    }

    @Test
    void testListTools() {
        StepVerifier.create((Publisher)this.mcpAsyncClient.listTools(null)).consumeNextWith(result -> {
            ((ListAssert)Assertions.assertThat((List)result.tools()).isNotNull()).isNotEmpty();
            McpSchema.Tool firstTool = (McpSchema.Tool)result.tools().get(0);
            Assertions.assertThat((String)firstTool.name()).isNotNull();
            Assertions.assertThat((String)firstTool.description()).isNotNull();
        }).verifyComplete();
    }

    @Test
    void testPing() {
        Assertions.assertThatCode(() -> this.mcpAsyncClient.ping().block()).doesNotThrowAnyException();
    }

    @Test
    void testCallTool() {
        McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest("echo", Map.of("message", ECHO_TEST_MESSAGE));
        StepVerifier.create((Publisher)this.mcpAsyncClient.callTool(callToolRequest)).consumeNextWith(callToolResult -> ((ObjectAssert)Assertions.assertThat((Object)callToolResult).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.content()).isNotNull();
            Assertions.assertThat((Boolean)result.isError()).isNull();
        }})).verifyComplete();
    }

    @Test
    void testCallToolWithInvalidTool() {
        McpSchema.CallToolRequest invalidRequest = new McpSchema.CallToolRequest("nonexistent_tool", Map.of("message", ECHO_TEST_MESSAGE));
        Assertions.assertThatThrownBy(() -> this.mcpAsyncClient.callTool(invalidRequest).block()).isInstanceOf(Exception.class);
    }

    @Test
    void testListResources() {
        StepVerifier.create((Publisher)this.mcpAsyncClient.listResources(null)).consumeNextWith(resources -> ((ObjectAssert)Assertions.assertThat((Object)resources).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.resources()).isNotNull();
            if (!result.resources().isEmpty()) {
                McpSchema.Resource firstResource = (McpSchema.Resource)result.resources().get(0);
                Assertions.assertThat((String)firstResource.uri()).isNotNull();
                Assertions.assertThat((String)firstResource.name()).isNotNull();
            }
        }})).verifyComplete();
    }

    @Test
    void testMcpAsyncClientState() {
        Assertions.assertThat((Object)this.mcpAsyncClient).isNotNull();
    }

    @Test
    void testListPrompts() {
        StepVerifier.create((Publisher)this.mcpAsyncClient.listPrompts(null)).consumeNextWith(prompts -> ((ObjectAssert)Assertions.assertThat((Object)prompts).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.prompts()).isNotNull();
            if (!result.prompts().isEmpty()) {
                McpSchema.Prompt firstPrompt = (McpSchema.Prompt)result.prompts().get(0);
                Assertions.assertThat((String)firstPrompt.name()).isNotNull();
                Assertions.assertThat((String)firstPrompt.description()).isNotNull();
            }
        }})).verifyComplete();
    }

    @Test
    void testGetPrompt() {
        StepVerifier.create((Publisher)this.mcpAsyncClient.getPrompt(new McpSchema.GetPromptRequest("simple_prompt", Map.of()))).consumeNextWith(prompt -> ((ObjectAssert)Assertions.assertThat((Object)prompt).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.messages()).isNotEmpty();
            Assertions.assertThat((List)result.messages()).hasSize(1);
        }})).verifyComplete();
    }

    @Test
    void testRootsListChanged() {
        Assertions.assertThatCode(() -> this.mcpAsyncClient.rootsListChangedNotification().block()).doesNotThrowAnyException();
    }

    @Test
    void testInitializeWithRootsListProviders() {
        ClientMcpTransport transport = this.createMcpTransport();
        McpAsyncClient client = McpClient.async((ClientMcpTransport)transport).requestTimeout(TIMEOUT).roots(new McpSchema.Root[]{new McpSchema.Root("file:///test/path", "test-root")}).build();
        Assertions.assertThatCode(() -> client.initialize().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> client.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testAddRoot() {
        McpSchema.Root newRoot = new McpSchema.Root("file:///new/test/path", "new-test-root");
        Assertions.assertThatCode(() -> this.mcpAsyncClient.addRoot(newRoot).block()).doesNotThrowAnyException();
    }

    @Test
    void testAddRootWithNullValue() {
        Assertions.assertThatThrownBy(() -> this.mcpAsyncClient.addRoot(null).block()).hasMessageContaining("Root must not be null");
    }

    @Test
    void testRemoveRoot() {
        McpSchema.Root root = new McpSchema.Root("file:///test/path/to/remove", "root-to-remove");
        Assertions.assertThatCode(() -> {
            this.mcpAsyncClient.addRoot(root).block();
            this.mcpAsyncClient.removeRoot(root.uri()).block();
        }).doesNotThrowAnyException();
    }

    @Test
    void testRemoveNonExistentRoot() {
        Assertions.assertThatThrownBy(() -> this.mcpAsyncClient.removeRoot("nonexistent-uri").block()).hasMessageContaining("Root with uri 'nonexistent-uri' not found");
    }

    @Test
    @Disabled
    void testReadResource() {
        StepVerifier.create((Publisher)this.mcpAsyncClient.listResources()).consumeNextWith(resources -> {
            if (!resources.resources().isEmpty()) {
                McpSchema.Resource firstResource = (McpSchema.Resource)resources.resources().get(0);
                StepVerifier.create((Publisher)this.mcpAsyncClient.readResource(firstResource)).consumeNextWith(result -> {
                    Assertions.assertThat((Object)result).isNotNull();
                    Assertions.assertThat((List)result.contents()).isNotNull();
                }).verifyComplete();
            }
        }).verifyComplete();
    }

    @Test
    void testListResourceTemplates() {
        StepVerifier.create((Publisher)this.mcpAsyncClient.listResourceTemplates()).consumeNextWith(result -> {
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((List)result.resourceTemplates()).isNotNull();
        }).verifyComplete();
    }

    void testResourceSubscription() {
        StepVerifier.create((Publisher)this.mcpAsyncClient.listResources()).consumeNextWith(resources -> {
            if (!resources.resources().isEmpty()) {
                McpSchema.Resource firstResource = (McpSchema.Resource)resources.resources().get(0);
                StepVerifier.create((Publisher)this.mcpAsyncClient.subscribeResource(new McpSchema.SubscribeRequest(firstResource.uri()))).verifyComplete();
                StepVerifier.create((Publisher)this.mcpAsyncClient.unsubscribeResource(new McpSchema.UnsubscribeRequest(firstResource.uri()))).verifyComplete();
            }
        }).verifyComplete();
    }

    @Test
    void testNotificationHandlers() {
        AtomicBoolean toolsNotificationReceived = new AtomicBoolean(false);
        AtomicBoolean resourcesNotificationReceived = new AtomicBoolean(false);
        AtomicBoolean promptsNotificationReceived = new AtomicBoolean(false);
        ClientMcpTransport transport = this.createMcpTransport();
        McpAsyncClient client = McpClient.async((ClientMcpTransport)transport).requestTimeout(TIMEOUT).toolsChangeConsumer(tools -> Mono.fromRunnable(() -> toolsNotificationReceived.set(true))).resourcesChangeConsumer(resources -> Mono.fromRunnable(() -> resourcesNotificationReceived.set(true))).promptsChangeConsumer(prompts -> Mono.fromRunnable(() -> promptsNotificationReceived.set(true))).build();
        Assertions.assertThatCode(() -> {
            client.initialize().block();
            client.sendResourcesListChanged().block();
            client.promptListChangedNotification().block();
            client.closeGracefully().block();
        }).doesNotThrowAnyException();
    }

    @Test
    void testInitializeWithSamplingCapability() {
        ClientMcpTransport transport = this.createMcpTransport();
        McpSchema.ClientCapabilities capabilities = McpSchema.ClientCapabilities.builder().sampling().build();
        McpAsyncClient client = McpClient.async((ClientMcpTransport)transport).requestTimeout(TIMEOUT).capabilities(capabilities).sampling(request -> Mono.just((Object)McpSchema.CreateMessageResult.builder().message("test").model("test-model").build())).build();
        Assertions.assertThatCode(() -> {
            client.initialize().block(Duration.ofSeconds(10L));
            client.closeGracefully().block(Duration.ofSeconds(10L));
        }).doesNotThrowAnyException();
    }

    @Test
    void testInitializeWithAllCapabilities() {
        ClientMcpTransport transport = this.createMcpTransport();
        McpSchema.ClientCapabilities capabilities = McpSchema.ClientCapabilities.builder().experimental(Map.of("feature", "test")).roots(Boolean.valueOf(true)).sampling().build();
        Function<McpSchema.CreateMessageRequest, Mono> samplingHandler = request -> Mono.just((Object)McpSchema.CreateMessageResult.builder().message("test").model("test-model").build());
        McpAsyncClient client = McpClient.async((ClientMcpTransport)transport).requestTimeout(TIMEOUT).capabilities(capabilities).sampling(samplingHandler).build();
        Assertions.assertThatCode(() -> {
            McpSchema.InitializeResult result = (McpSchema.InitializeResult)client.initialize().block(Duration.ofSeconds(10L));
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((Object)result.capabilities()).isNotNull();
            client.closeGracefully().block(Duration.ofSeconds(10L));
        }).doesNotThrowAnyException();
    }

    @Test
    void testLoggingLevels() {
        for (McpSchema.LoggingLevel level : McpSchema.LoggingLevel.values()) {
            StepVerifier.create((Publisher)this.mcpAsyncClient.setLoggingLevel(level)).verifyComplete();
        }
    }

    @Test
    void testLoggingConsumer() {
        AtomicBoolean logReceived = new AtomicBoolean(false);
        ClientMcpTransport transport = this.createMcpTransport();
        McpAsyncClient client = McpClient.async((ClientMcpTransport)transport).requestTimeout(TIMEOUT).loggingConsumer(notification -> Mono.fromRunnable(() -> logReceived.set(true))).build();
        Assertions.assertThatCode(() -> {
            client.initialize().block(Duration.ofSeconds(10L));
            client.closeGracefully().block(Duration.ofSeconds(10L));
        }).doesNotThrowAnyException();
    }

    @Test
    void testLoggingWithNullNotification() {
        Assertions.assertThatThrownBy(() -> this.mcpAsyncClient.setLoggingLevel(null).block()).hasMessageContaining("Logging level must not be null");
    }
}

