/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server.transport;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.ServerMcpTransport;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@WebServlet(asyncSupported=true)
@Deprecated
public class HttpServletSseServerTransport
extends HttpServlet
implements ServerMcpTransport {
    private static final Logger logger = LoggerFactory.getLogger(HttpServletSseServerTransport.class);
    public static final String UTF_8 = "UTF-8";
    public static final String APPLICATION_JSON = "application/json";
    public static final String FAILED_TO_SEND_ERROR_RESPONSE = "Failed to send error response: {}";
    public static final String DEFAULT_SSE_ENDPOINT = "/sse";
    public static final String MESSAGE_EVENT_TYPE = "message";
    public static final String ENDPOINT_EVENT_TYPE = "endpoint";
    private final ObjectMapper objectMapper;
    private final String messageEndpoint;
    private final String sseEndpoint;
    private final Map<String, ClientSession> sessions = new ConcurrentHashMap<String, ClientSession>();
    private final AtomicBoolean isClosing = new AtomicBoolean(false);
    private Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> connectHandler;

    public HttpServletSseServerTransport(ObjectMapper objectMapper, String messageEndpoint, String sseEndpoint) {
        this.objectMapper = objectMapper;
        this.messageEndpoint = messageEndpoint;
        this.sseEndpoint = sseEndpoint;
    }

    public HttpServletSseServerTransport(ObjectMapper objectMapper, String messageEndpoint) {
        this(objectMapper, messageEndpoint, DEFAULT_SSE_ENDPOINT);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (!this.sseEndpoint.equals(pathInfo)) {
            response.sendError(404);
            return;
        }
        if (this.isClosing.get()) {
            response.sendError(503, "Server is shutting down");
            return;
        }
        response.setContentType("text/event-stream");
        response.setCharacterEncoding(UTF_8);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "keep-alive");
        response.setHeader("Access-Control-Allow-Origin", "*");
        String sessionId = UUID.randomUUID().toString();
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        PrintWriter writer = response.getWriter();
        ClientSession session = new ClientSession(sessionId, asyncContext, writer);
        this.sessions.put(sessionId, session);
        this.sendEvent(writer, ENDPOINT_EVENT_TYPE, this.messageEndpoint);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isClosing.get()) {
            response.sendError(503, "Server is shutting down");
            return;
        }
        String pathInfo = request.getPathInfo();
        if (!this.messageEndpoint.equals(pathInfo)) {
            response.sendError(404);
            return;
        }
        try {
            String line;
            BufferedReader reader = request.getReader();
            StringBuilder body = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                body.append(line);
            }
            McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage(this.objectMapper, body.toString());
            if (this.connectHandler != null) {
                this.connectHandler.apply((Mono<McpSchema.JSONRPCMessage>)Mono.just((Object)message)).subscribe(responseMessage -> {
                    try {
                        response.setContentType(APPLICATION_JSON);
                        response.setCharacterEncoding(UTF_8);
                        String jsonResponse = this.objectMapper.writeValueAsString(responseMessage);
                        PrintWriter writer = response.getWriter();
                        writer.write(jsonResponse);
                        writer.flush();
                    }
                    catch (Exception e) {
                        logger.error("Error sending response: {}", (Object)e.getMessage());
                        try {
                            response.sendError(500, "Error processing response: " + e.getMessage());
                        }
                        catch (IOException ex) {
                            logger.error(FAILED_TO_SEND_ERROR_RESPONSE, (Object)ex.getMessage());
                        }
                    }
                }, error -> {
                    try {
                        logger.error("Error processing message: {}", (Object)error.getMessage());
                        McpError mcpError = new McpError((Object)error.getMessage());
                        response.setContentType(APPLICATION_JSON);
                        response.setCharacterEncoding(UTF_8);
                        response.setStatus(500);
                        String jsonError = this.objectMapper.writeValueAsString((Object)mcpError);
                        PrintWriter writer = response.getWriter();
                        writer.write(jsonError);
                        writer.flush();
                    }
                    catch (IOException e) {
                        logger.error(FAILED_TO_SEND_ERROR_RESPONSE, (Object)e.getMessage());
                        try {
                            response.sendError(500, "Error sending error response: " + e.getMessage());
                        }
                        catch (IOException ex) {
                            logger.error(FAILED_TO_SEND_ERROR_RESPONSE, (Object)ex.getMessage());
                        }
                    }
                });
            } else {
                response.sendError(503, "No message handler configured");
            }
        }
        catch (Exception e) {
            logger.error("Invalid message format: {}", (Object)e.getMessage());
            try {
                McpError mcpError = new McpError((Object)("Invalid message format: " + e.getMessage()));
                response.setContentType(APPLICATION_JSON);
                response.setCharacterEncoding(UTF_8);
                response.setStatus(400);
                String jsonError = this.objectMapper.writeValueAsString((Object)mcpError);
                PrintWriter writer = response.getWriter();
                writer.write(jsonError);
                writer.flush();
            }
            catch (IOException ex) {
                logger.error(FAILED_TO_SEND_ERROR_RESPONSE, (Object)ex.getMessage());
                response.sendError(400, "Invalid message format");
            }
        }
    }

    @Override
    public Mono<Void> connect(Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> handler) {
        this.connectHandler = handler;
        return Mono.empty();
    }

    @Override
    public Mono<Void> sendMessage(McpSchema.JSONRPCMessage message) {
        if (this.sessions.isEmpty()) {
            logger.debug("No active sessions to broadcast message to");
            return Mono.empty();
        }
        return Mono.create(sink -> {
            try {
                String jsonText = this.objectMapper.writeValueAsString((Object)message);
                this.sessions.values().forEach(session -> {
                    try {
                        this.sendEvent(session.writer, MESSAGE_EVENT_TYPE, jsonText);
                    }
                    catch (IOException e) {
                        logger.error("Failed to send message to session {}: {}", (Object)session.id, (Object)e.getMessage());
                        this.removeSession((ClientSession)session);
                    }
                });
                sink.success();
            }
            catch (Exception e) {
                logger.error("Failed to process message: {}", (Object)e.getMessage());
                sink.error((Throwable)new McpError((Object)("Failed to process message: " + e.getMessage())));
            }
        });
    }

    @Override
    public void close() {
        ServerMcpTransport.super.close();
    }

    @Override
    public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
        return (T)this.objectMapper.convertValue(data, typeRef);
    }

    @Override
    public Mono<Void> closeGracefully() {
        this.isClosing.set(true);
        logger.debug("Initiating graceful shutdown with {} active sessions", (Object)this.sessions.size());
        return Mono.create(sink -> {
            this.sessions.values().forEach(this::removeSession);
            sink.success();
        });
    }

    private void sendEvent(PrintWriter writer, String eventType, String data) throws IOException {
        writer.write("event: " + eventType + "\n");
        writer.write("data: " + data + "\n\n");
        writer.flush();
        if (writer.checkError()) {
            throw new IOException("Client disconnected");
        }
    }

    private void removeSession(ClientSession session) {
        this.sessions.remove(session.id);
        session.asyncContext.complete();
    }

    public void destroy() {
        this.closeGracefully().block();
        super.destroy();
    }

    private static class ClientSession {
        private final String id;
        private final AsyncContext asyncContext;
        private final PrintWriter writer;

        ClientSession(String id, AsyncContext asyncContext, PrintWriter writer) {
            this.id = id;
            this.asyncContext = asyncContext;
            this.writer = writer;
        }
    }
}

