/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class McpServerFeatures {

    @Deprecated
    public record SyncPromptRegistration(McpSchema.Prompt prompt, Function<McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler) {
        public SyncPromptSpecification toSpecification() {
            return new SyncPromptSpecification(this.prompt, (exchange, request) -> this.promptHandler.apply((McpSchema.GetPromptRequest)request));
        }
    }

    @Deprecated
    public record SyncResourceRegistration(McpSchema.Resource resource, Function<McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler) {
        public SyncResourceSpecification toSpecification() {
            return new SyncResourceSpecification(this.resource, (exchange, request) -> this.readHandler.apply((McpSchema.ReadResourceRequest)request));
        }
    }

    @Deprecated
    public record SyncToolRegistration(McpSchema.Tool tool, Function<Map<String, Object>, McpSchema.CallToolResult> call) {
        public SyncToolSpecification toSpecification() {
            return new SyncToolSpecification(this.tool, (exchange, map) -> this.call.apply((Map<String, Object>)map));
        }
    }

    @Deprecated
    public record AsyncPromptRegistration(McpSchema.Prompt prompt, Function<McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler) {
        static AsyncPromptRegistration fromSync(SyncPromptRegistration prompt) {
            if (prompt == null) {
                return null;
            }
            return new AsyncPromptRegistration(prompt.prompt(), req -> Mono.fromCallable(() -> prompt.promptHandler().apply((McpSchema.GetPromptRequest)req)).subscribeOn(Schedulers.boundedElastic()));
        }

        public AsyncPromptSpecification toSpecification() {
            return new AsyncPromptSpecification(this.prompt(), (exchange, request) -> this.promptHandler.apply((McpSchema.GetPromptRequest)request));
        }
    }

    @Deprecated
    public record AsyncResourceRegistration(McpSchema.Resource resource, Function<McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler) {
        static AsyncResourceRegistration fromSync(SyncResourceRegistration resource) {
            if (resource == null) {
                return null;
            }
            return new AsyncResourceRegistration(resource.resource(), req -> Mono.fromCallable(() -> resource.readHandler().apply((McpSchema.ReadResourceRequest)req)).subscribeOn(Schedulers.boundedElastic()));
        }

        public AsyncResourceSpecification toSpecification() {
            return new AsyncResourceSpecification(this.resource(), (exchange, request) -> this.readHandler.apply((McpSchema.ReadResourceRequest)request));
        }
    }

    @Deprecated
    public record AsyncToolRegistration(McpSchema.Tool tool, Function<Map<String, Object>, Mono<McpSchema.CallToolResult>> call) {
        static AsyncToolRegistration fromSync(SyncToolRegistration tool) {
            if (tool == null) {
                return null;
            }
            return new AsyncToolRegistration(tool.tool(), map -> Mono.fromCallable(() -> tool.call().apply((Map<String, Object>)map)).subscribeOn(Schedulers.boundedElastic()));
        }

        public AsyncToolSpecification toSpecification() {
            return new AsyncToolSpecification(this.tool(), (exchange, map) -> this.call.apply((Map<String, Object>)map));
        }
    }

    public record SyncPromptSpecification(McpSchema.Prompt prompt, BiFunction<McpSyncServerExchange, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler) {
    }

    public record SyncResourceSpecification(McpSchema.Resource resource, BiFunction<McpSyncServerExchange, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler) {
    }

    public record SyncToolSpecification(McpSchema.Tool tool, BiFunction<McpSyncServerExchange, Map<String, Object>, McpSchema.CallToolResult> call) {
    }

    public record AsyncPromptSpecification(McpSchema.Prompt prompt, BiFunction<McpAsyncServerExchange, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler) {
        static AsyncPromptSpecification fromSync(SyncPromptSpecification prompt) {
            if (prompt == null) {
                return null;
            }
            return new AsyncPromptSpecification(prompt.prompt(), (exchange, req) -> Mono.fromCallable(() -> prompt.promptHandler().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (McpSchema.GetPromptRequest)req)).subscribeOn(Schedulers.boundedElastic()));
        }
    }

    public record AsyncResourceSpecification(McpSchema.Resource resource, BiFunction<McpAsyncServerExchange, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler) {
        static AsyncResourceSpecification fromSync(SyncResourceSpecification resource) {
            if (resource == null) {
                return null;
            }
            return new AsyncResourceSpecification(resource.resource(), (exchange, req) -> Mono.fromCallable(() -> resource.readHandler().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (McpSchema.ReadResourceRequest)req)).subscribeOn(Schedulers.boundedElastic()));
        }
    }

    public record AsyncToolSpecification(McpSchema.Tool tool, BiFunction<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> call) {
        static AsyncToolSpecification fromSync(SyncToolSpecification tool) {
            if (tool == null) {
                return null;
            }
            return new AsyncToolSpecification(tool.tool(), (exchange, map) -> Mono.fromCallable(() -> tool.call().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (Map<String, Object>)map)).subscribeOn(Schedulers.boundedElastic()));
        }
    }

    record Sync(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<SyncToolSpecification> tools, Map<String, SyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, SyncPromptSpecification> prompts, List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeConsumers) {
        Sync(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<SyncToolSpecification> tools, Map<String, SyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, SyncPromptSpecification> prompts, List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeConsumers) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities(null, new McpSchema.ServerCapabilities.LoggingCapabilities(), !Utils.isEmpty(prompts) ? new McpSchema.ServerCapabilities.PromptCapabilities(false) : null, !Utils.isEmpty(resources) ? new McpSchema.ServerCapabilities.ResourceCapabilities(false, false) : null, !Utils.isEmpty(tools) ? new McpSchema.ServerCapabilities.ToolCapabilities(false) : null);
            this.tools = tools != null ? tools : new ArrayList();
            this.resources = resources != null ? resources : new HashMap();
            this.resourceTemplates = resourceTemplates != null ? resourceTemplates : new ArrayList();
            this.prompts = prompts != null ? prompts : new HashMap();
            this.rootsChangeConsumers = rootsChangeConsumers != null ? rootsChangeConsumers : new ArrayList();
        }
    }

    record Async(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<AsyncToolSpecification> tools, Map<String, AsyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, AsyncPromptSpecification> prompts, List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers) {
        Async(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<AsyncToolSpecification> tools, Map<String, AsyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, AsyncPromptSpecification> prompts, List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities(null, new McpSchema.ServerCapabilities.LoggingCapabilities(), !Utils.isEmpty(prompts) ? new McpSchema.ServerCapabilities.PromptCapabilities(false) : null, !Utils.isEmpty(resources) ? new McpSchema.ServerCapabilities.ResourceCapabilities(false, false) : null, !Utils.isEmpty(tools) ? new McpSchema.ServerCapabilities.ToolCapabilities(false) : null);
            this.tools = tools != null ? tools : List.of();
            this.resources = resources != null ? resources : Map.of();
            this.resourceTemplates = resourceTemplates != null ? resourceTemplates : List.of();
            this.prompts = prompts != null ? prompts : Map.of();
            this.rootsChangeConsumers = rootsChangeConsumers != null ? rootsChangeConsumers : List.of();
        }

        static Async fromSync(Sync syncSpec) {
            ArrayList<AsyncToolSpecification> tools = new ArrayList<AsyncToolSpecification>();
            for (SyncToolSpecification tool : syncSpec.tools()) {
                tools.add(AsyncToolSpecification.fromSync(tool));
            }
            HashMap<String, AsyncResourceSpecification> resources = new HashMap<String, AsyncResourceSpecification>();
            syncSpec.resources().forEach((key, resource) -> resources.put((String)key, AsyncResourceSpecification.fromSync(resource)));
            HashMap<String, AsyncPromptSpecification> prompts = new HashMap<String, AsyncPromptSpecification>();
            syncSpec.prompts().forEach((key, prompt) -> prompts.put((String)key, AsyncPromptSpecification.fromSync(prompt)));
            ArrayList<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootChangeConsumers = new ArrayList<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>>();
            for (BiConsumer<McpSyncServerExchange, List<McpSchema.Root>> rootChangeConsumer : syncSpec.rootsChangeConsumers()) {
                rootChangeConsumers.add((exchange, list) -> Mono.fromRunnable(() -> rootChangeConsumer.accept(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (List<McpSchema.Root>)list)).subscribeOn(Schedulers.boundedElastic()));
            }
            return new Async(syncSpec.serverInfo(), syncSpec.serverCapabilities(), tools, resources, syncSpec.resourceTemplates(), prompts, rootChangeConsumers);
        }
    }
}

