

package net.starlark.java.syntax;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_FileOptions extends FileOptions {

  private final boolean restrictStringEscapes;

  private final boolean allowLoadPrivateSymbols;

  private final boolean allowToplevelRebinding;

  private final boolean requireLoadStatementsFirst;

  private final boolean recordScope;

  private AutoValue_FileOptions(
      boolean restrictStringEscapes,
      boolean allowLoadPrivateSymbols,
      boolean allowToplevelRebinding,
      boolean requireLoadStatementsFirst,
      boolean recordScope) {
    this.restrictStringEscapes = restrictStringEscapes;
    this.allowLoadPrivateSymbols = allowLoadPrivateSymbols;
    this.allowToplevelRebinding = allowToplevelRebinding;
    this.requireLoadStatementsFirst = requireLoadStatementsFirst;
    this.recordScope = recordScope;
  }

  @Override
  public boolean restrictStringEscapes() {
    return restrictStringEscapes;
  }

  @Override
  public boolean allowLoadPrivateSymbols() {
    return allowLoadPrivateSymbols;
  }

  @Override
  public boolean allowToplevelRebinding() {
    return allowToplevelRebinding;
  }

  @Override
  public boolean requireLoadStatementsFirst() {
    return requireLoadStatementsFirst;
  }

  @Override
  public boolean recordScope() {
    return recordScope;
  }

  @Override
  public String toString() {
    return "FileOptions{"
         + "restrictStringEscapes=" + restrictStringEscapes + ", "
         + "allowLoadPrivateSymbols=" + allowLoadPrivateSymbols + ", "
         + "allowToplevelRebinding=" + allowToplevelRebinding + ", "
         + "requireLoadStatementsFirst=" + requireLoadStatementsFirst + ", "
         + "recordScope=" + recordScope
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof FileOptions) {
      FileOptions that = (FileOptions) o;
      return this.restrictStringEscapes == that.restrictStringEscapes()
          && this.allowLoadPrivateSymbols == that.allowLoadPrivateSymbols()
          && this.allowToplevelRebinding == that.allowToplevelRebinding()
          && this.requireLoadStatementsFirst == that.requireLoadStatementsFirst()
          && this.recordScope == that.recordScope();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= restrictStringEscapes ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= allowLoadPrivateSymbols ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= allowToplevelRebinding ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= requireLoadStatementsFirst ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= recordScope ? 1231 : 1237;
    return h$;
  }

  @Override
  public FileOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends FileOptions.Builder {
    private Boolean restrictStringEscapes;
    private Boolean allowLoadPrivateSymbols;
    private Boolean allowToplevelRebinding;
    private Boolean requireLoadStatementsFirst;
    private Boolean recordScope;
    Builder() {
    }
    private Builder(FileOptions source) {
      this.restrictStringEscapes = source.restrictStringEscapes();
      this.allowLoadPrivateSymbols = source.allowLoadPrivateSymbols();
      this.allowToplevelRebinding = source.allowToplevelRebinding();
      this.requireLoadStatementsFirst = source.requireLoadStatementsFirst();
      this.recordScope = source.recordScope();
    }
    @Override
    public FileOptions.Builder restrictStringEscapes(boolean restrictStringEscapes) {
      this.restrictStringEscapes = restrictStringEscapes;
      return this;
    }
    @Override
    public FileOptions.Builder allowLoadPrivateSymbols(boolean allowLoadPrivateSymbols) {
      this.allowLoadPrivateSymbols = allowLoadPrivateSymbols;
      return this;
    }
    @Override
    public FileOptions.Builder allowToplevelRebinding(boolean allowToplevelRebinding) {
      this.allowToplevelRebinding = allowToplevelRebinding;
      return this;
    }
    @Override
    public FileOptions.Builder requireLoadStatementsFirst(boolean requireLoadStatementsFirst) {
      this.requireLoadStatementsFirst = requireLoadStatementsFirst;
      return this;
    }
    @Override
    public FileOptions.Builder recordScope(boolean recordScope) {
      this.recordScope = recordScope;
      return this;
    }
    @Override
    public FileOptions build() {
      String missing = "";
      if (this.restrictStringEscapes == null) {
        missing += " restrictStringEscapes";
      }
      if (this.allowLoadPrivateSymbols == null) {
        missing += " allowLoadPrivateSymbols";
      }
      if (this.allowToplevelRebinding == null) {
        missing += " allowToplevelRebinding";
      }
      if (this.requireLoadStatementsFirst == null) {
        missing += " requireLoadStatementsFirst";
      }
      if (this.recordScope == null) {
        missing += " recordScope";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_FileOptions(
          this.restrictStringEscapes,
          this.allowLoadPrivateSymbols,
          this.allowToplevelRebinding,
          this.requireLoadStatementsFirst,
          this.recordScope);
    }
  }

}
