/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsEntityFetcher;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.exceptions.DgsBadRequestException;
import com.netflix.graphql.dgs.exceptions.DgsEntityNotFoundException;
import graphql.execution.DataFetcherResult;
import graphql.relay.Connection;
import graphql.relay.SimpleListConnection;
import graphql.schema.DataFetchingEnvironment;
import io.moderne.cli.recipe.RecipeMarketplace;
import io.moderne.dx.auditlog.AuditLog;
import io.moderne.dx.auditlog.a;
import io.moderne.dx.config.DxConfiguration;
import io.moderne.dx.graphql.ExtendedRelayConnection;
import io.moderne.dx.recipe.RecipeDeployer;
import io.moderne.dx.recipe.b;
import io.moderne.dx.types.Recipe;
import io.moderne.dx.types.RecipeArtifact;
import io.moderne.dx.types.RecipeCategory;
import io.moderne.dx.types.RecipeCategoryBreadcrumb;
import io.moderne.dx.types.RecipeDeploymentResult;
import io.moderne.dx.types.RecipeDeploymentState;
import io.moderne.dx.types.RecipeSortKey;
import io.moderne.dx.types.SortOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.config.CategoryTree;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.GroupArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestHeader;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@DgsComponent
public class RecipeDataFetcher {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(RecipeDataFetcher.class);
    private static final Pattern b = Pattern.compile("^([A-Za-z0-9]+)+(\\.[A-Za-z0-9]+)*$");
    private final AuditLog c;
    private final RecipeDeployer d;
    private final RecipeMarketplace e;
    private final DxConfiguration f;

    @DgsQuery
    Flux<RecipeDeploymentResult> latestRecipeDeployments(@InputArgument String string, @InputArgument String string2, @RequestHeader(name="x-moderne-authemail", required=false, defaultValue="dev@null") String string3) {
        return this.c.a(string3, "recipe.deployments", "get.latest.recipe.deployment", a.b, "Get latest recipe deployments.", this.d.a(recipeDeploymentResult -> StringUtils.matchesGlob((String)recipeDeploymentResult.getArtifact().getGroupId(), (String)string) && StringUtils.matchesGlob((String)recipeDeploymentResult.getArtifact().getArtifactId(), (String)string2)));
    }

    @DgsQuery
    Mono<RecipeDeploymentResult> recipeDeployment(@InputArgument String string, @RequestHeader(name="x-moderne-authemail", required=false, defaultValue="dev@null") String string2) {
        return this.c.a(string2, "recipe.deployments", "get.recipe.deployment", a.b, "Get recipe deployment with id " + string + ".", this.d.a(recipeDeploymentResult -> recipeDeploymentResult.getId().equals(string)).next().switchIfEmpty(Mono.error((Throwable)new DgsEntityNotFoundException("Recipe deployment not found."))));
    }

    @DgsQuery
    Flux<RecipeDeploymentResult> recipeDeployments(@InputArgument @Nullable RecipeDeploymentState recipeDeploymentState, @RequestHeader(name="x-moderne-authemail", required=false, defaultValue="dev@null") String string) {
        return this.c.a(string, "recipe.deployments", "get.recipe.deployments", a.b, (String)(recipeDeploymentState == null ? "Get all recipe deployments." : "Get all recipe deployments with state " + recipeDeploymentState.name() + "."), this.d.a(recipeDeploymentResult -> recipeDeploymentState == null || recipeDeploymentResult.getState() == recipeDeploymentState));
    }

    @DgsQuery
    public Flux<RecipeArtifact> recipeArtifacts(@RequestHeader(name="x-moderne-authemail", required=false, defaultValue="dev@null") String string) {
        return this.c.a(string, "recipe.artifacts", "get.recipe.artifacts", a.b, "Get all recipe artifacts currently loaded into the catalog.", Mono.fromCallable(() -> this.e.countByArtifact().keySet().stream().map(b::a).collect(Collectors.toList()))).flatMapMany(Flux::fromIterable).subscribeOn(Schedulers.boundedElastic());
    }

    @DgsQuery
    public Flux<DataFetcherResult<RecipeCategory>> categories(@InputArgument @Nullable String string, @RequestHeader(name="x-moderne-authemail", required=false, defaultValue="dev@null") String string2) {
        String string3 = "Get categories of " + (StringUtils.isBlank((String)string) ? "root" : string) + ".";
        return this.c.a(string2, "recipes", "get.recipe.categories", a.b, string3, Flux.defer(() -> {
            List<CategoryTree> list;
            if (string == null || string.isBlank()) {
                list = this.e.categoryTree().getCategories();
            } else {
                if (!b.matcher(string).matches()) {
                    throw new DgsBadRequestException("categoryId must be a valid Java package name (or not specified)");
                }
                CategoryTree categoryTree = this.e.categoryTree().getCategory(string);
                if (categoryTree == null) {
                    throw new DgsEntityNotFoundException();
                }
                list = List.of(categoryTree);
            }
            return b.a((Collection)list);
        }));
    }

    @DgsData(parentType="RecipeCategory")
    public Flux<DataFetcherResult<RecipeCategory>> categories(DgsDataFetchingEnvironment dgsDataFetchingEnvironment) {
        CategoryTree categoryTree = (CategoryTree)dgsDataFetchingEnvironment.getLocalContext();
        return b.a((Collection)categoryTree.getCategories());
    }

    @DgsData(parentType="RecipeCategory")
    public List<Recipe> recipes(DgsDataFetchingEnvironment dgsDataFetchingEnvironment) {
        CategoryTree categoryTree = (CategoryTree)dgsDataFetchingEnvironment.getLocalContext();
        ArrayList<Recipe> arrayList = new ArrayList<Recipe>(categoryTree.getRecipeCount());
        for (RecipeDescriptor recipeDescriptor : categoryTree.getRecipes()) {
            arrayList.add(b.a((RecipeDescriptor)recipeDescriptor));
        }
        return arrayList;
    }

    @DgsQuery
    public Mono<Recipe> recipe(@InputArgument String string, @RequestHeader(name="x-moderne-authemail", required=false, defaultValue="dev@null") String string2) {
        return this.c.a(string2, "recipes", "get.recipe", a.b, "Get a specific recipe and its details.", this.a(string));
    }

    @DgsEntityFetcher(name="Recipe")
    public Mono<Recipe> recipeEntityFetcher(Map<String, Object> map) {
        String string = (String)map.get("id");
        return this.a(string);
    }

    private Mono<Recipe> a(String string) {
        return Mono.fromCallable(() -> this.e.categoryTree().getRecipe(string)).switchIfEmpty(Mono.error((Throwable)new DgsEntityNotFoundException("Recipe not found for " + string))).map(b::a);
    }

    @DgsQuery
    public Mono<ExtendedRelayConnection<Recipe>> searchRecipes(@InputArgument String string, @InputArgument Integer n2, @InputArgument SortOrder sortOrder, @InputArgument RecipeSortKey recipeSortKey, @Nullable @InputArgument String string2, @RequestHeader(name="x-moderne-authemail", required=false, defaultValue="dev@null") String string3, DataFetchingEnvironment dataFetchingEnvironment) {
        return this.c.a(string3, "recipes", "search.recipes", a.b, "Search for recipes for query \"${query}\" in the catalog.", a2 -> Mono.fromCallable(() -> {
            a2.a("query", string);
            Comparator comparator = this.a(sortOrder, recipeSortKey);
            this.e.assertInstalled();
            List<String> list = this.e.findRecipes(String.join((CharSequence)" ", string), n2 == null ? 50 : n2).stream().map(RecipeDescriptor::getName).toList();
            Connection connection = new SimpleListConnection(list.stream().map(string -> this.e.categoryTree().getRecipe(string)).filter(Objects::nonNull).map(b::a).sorted(comparator).collect(Collectors.toList())).get(dataFetchingEnvironment);
            return new ExtendedRelayConnection(connection.getEdges(), connection.getPageInfo(), Integer.valueOf(list.size()));
        }));
    }

    private Comparator<Recipe> a(SortOrder sortOrder, RecipeSortKey recipeSortKey) {
        Comparator comparator = RecipeSortKey.DEFAULT.equals((Object)recipeSortKey) ? (recipe, recipe2) -> 0 : (RecipeSortKey.TOTAL_RECIPES.equals((Object)recipeSortKey) ? (recipe, recipe2) -> SortOrder.DESC.equals((Object)sortOrder) ? recipe2.getTotalRecipes() - recipe.getTotalRecipes() : recipe.getTotalRecipes() - recipe2.getTotalRecipes() : (recipe, recipe2) -> SortOrder.ASC.equals((Object)sortOrder) ? recipe.getName().compareToIgnoreCase(recipe2.getName()) : recipe2.getName().compareToIgnoreCase(recipe.getName()));
        return comparator;
    }

    @DgsData(parentType="RecipeCategory")
    public List<RecipeCategoryBreadcrumb> breadcrumbs(DgsDataFetchingEnvironment dgsDataFetchingEnvironment) {
        CategoryTree categoryTree;
        RecipeCategory recipeCategory = (RecipeCategory)dgsDataFetchingEnvironment.getSource();
        String[] stringArray = recipeCategory.getId().split("\\.");
        ArrayList<RecipeCategoryBreadcrumb> arrayList = new ArrayList<RecipeCategoryBreadcrumb>();
        for (int i2 = 2; i2 < stringArray.length - 1 && (categoryTree = this.e.categoryTree().getCategory(Arrays.copyOfRange(stringArray, 0, i2 + 1))) != null; ++i2) {
            arrayList.add(new RecipeCategoryBreadcrumb(categoryTree.getDescriptor().getPackageName(), categoryTree.getDescriptor().getDisplayName()));
        }
        return arrayList;
    }

    @DgsData(parentType="Recipe")
    @Nullable
    public Mono<RecipeArtifact> recipeArtifact(DgsDataFetchingEnvironment dgsDataFetchingEnvironment) {
        Recipe recipe = (Recipe)dgsDataFetchingEnvironment.getSource();
        return Mono.fromCallable(() -> {
            GroupArtifact groupArtifact = (GroupArtifact)this.e.categoryTree().getRecipeGroup(recipe.getId());
            if (groupArtifact == null) {
                return null;
            }
            return Mono.justOrEmpty((Object)this.e.countByArtifact().keySet().stream().filter(resolvedGroupArtifactVersion -> resolvedGroupArtifactVersion.getGroupId().equals(groupArtifact.getGroupId()) && resolvedGroupArtifactVersion.getArtifactId().equals(groupArtifact.getArtifactId())).findAny().map(b::a).orElse(null));
        }).flatMap(Function.identity()).subscribeOn(Schedulers.boundedElastic());
    }

    @DgsMutation
    public Mono<RecipeDeploymentResult> loadRecipes(@InputArgument String string, @InputArgument String string2, @InputArgument String string3, @Nullable @InputArgument String string4, @RequestHeader(name="x-moderne-authemail", required=false, defaultValue="dev@null") String string5, @Nullable @RequestHeader(value="Authorization") String string6) {
        return this.c.a(string5, "recipe.artifacts", "load.recipes", a.c, "Load/deploy recipe artifact ${groupId}:${artifactId}:${version} into the recipe catalog.", a2 -> Mono.defer(() -> {
            a2.a("groupId", string);
            a2.a("artifactId", string2);
            a2.a("version", string3);
            if (string6 == null || !this.f.getToken().contains(string6.replace("Bearer", "").trim())) {
                throw new DgsBadRequestException("Invalid token or unauthorized.");
            }
            return this.d.a(string, string2, string3, string4);
        }));
    }

    @Generated
    public RecipeDataFetcher(AuditLog auditLog, RecipeDeployer recipeDeployer, RecipeMarketplace recipeMarketplace, DxConfiguration dxConfiguration) {
        this.c = auditLog;
        this.d = recipeDeployer;
        this.e = recipeMarketplace;
        this.f = dxConfiguration;
    }
}

